% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEAM.R
\name{BEAM}
\alias{BEAM}
\title{Branched expression analysis modeling (BEAM).}
\usage{
BEAM(
  cds,
  fullModelFormulaStr = "~sm.ns(Pseudotime, df = 3)*Branch",
  reducedModelFormulaStr = "~sm.ns(Pseudotime, df = 3)",
  branch_states = NULL,
  branch_point = 1,
  relative_expr = TRUE,
  branch_labels = NULL,
  verbose = FALSE,
  cores = 1,
  ...
)
}
\arguments{
\item{cds}{a CellDataSet object upon which to perform this operation}

\item{fullModelFormulaStr}{a formula string specifying the full model in differential expression tests (i.e. likelihood ratio tests) for each gene/feature.}

\item{reducedModelFormulaStr}{a formula string specifying the reduced model in differential expression tests (i.e. likelihood ratio tests) for each gene/feature.}

\item{branch_states}{ids for the immediate branch branch which obtained from branch construction based on MST}

\item{branch_point}{The ID of the branch point to analyze. Can only be used when reduceDimension is called with method = "DDRTree".}

\item{relative_expr}{a logic flag to determine whether or not the relative gene expression should be used}

\item{branch_labels}{the name for each branch, for example, "AT1" or "AT2"}

\item{verbose}{Whether to generate verbose output}

\item{cores}{the number of cores to be used while testing each gene for differential expression}

\item{...}{additional arguments to be passed to differentialGeneTest}
}
\value{
a data frame containing the p values and q-values from the BEAM test, with one row per gene.
}
\description{
Identify genes with branch-dependent expression.
Branches in single-cell trajectories are generated by cell fate decisions 
in development and also arise when analyzing genetic, chemical, or environmental
perturbations. Branch expression analysis modeling is a statistical approach
for finding genes that are regulated in a manner that depends on the branch. 
Consider a progenitor cell that generates two distinct cell types. A single-cell
trajectory that includes progenitor cells and both differentiated cell types
will capture the "decision" as a branch point, with progenitors upstream of the branch
and the differentiated cells positioned along distinct branches. These branches
will be characterized by distinct gene expression programs. BEAM aims to find
all genes that differ between the branches. Such "branch-dependent" genes
can help identify the mechanism by which the fate decision is made.  
\code{BEAM()} Takes a CellDataSet and either a specified branch point, or a pair of 
trajectory outcomes (as States). If a branch point is provided, the function 
returns a dataframe of test results for dependence on that branch. If a pair
of outcomes is provided, it returns test results for the branch that unifies
those outcomes into a common path to the trajectory's root state.
\code{BEAM()} compares two models with a likelihood ratio test for branch-dependent
expression. The full model is the product of smooth Pseudotime and the Branch a cell is assigned to.
The reduced model just includes Pseudotime. You can modify these to include 
arbitrary additional effects in the full or both models.
}
