% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceTrack-class.R
\docType{class}
\name{SequenceTrack-class}
\alias{SequenceTrack-class}
\alias{initialize,SequenceTrack-method}
\alias{SequenceTrack}
\alias{RNASequenceTrack}
\alias{SequenceDNAStringSetTrack-class}
\alias{initialize,SequenceDNAStringSetTrack-method}
\alias{SequenceRNAStringSetTrack-class}
\alias{initialize,SequenceRNAStringSetTrack-method}
\alias{SequenceBSgenomeTrack-class}
\alias{initialize,SequenceBSgenomeTrack-method}
\alias{ReferenceSequenceTrack-class}
\alias{initialize,ReferenceSequenceTrack-method}
\alias{seqnames,SequenceTrack-method}
\alias{seqnames,SequenceBSgenomeTrack-method}
\alias{seqlevels,SequenceTrack-method}
\alias{seqlevels,SequenceBSgenomeTrack-method}
\alias{start,SequenceTrack-method}
\alias{end,SequenceTrack-method}
\alias{width,SequenceTrack-method}
\alias{length,SequenceTrack-method}
\alias{chromosome,SequenceTrack-method}
\alias{chromosome<-,SequenceTrack-method}
\alias{genome,SequenceTrack-method}
\alias{consolidateTrack,SequenceTrack-method}
\alias{drawGD,SequenceTrack-method}
\alias{show,SequenceBSgenomeTrack-method}
\alias{show,SequenceDNAStringSetTrack-method}
\alias{show,SequenceRNAStringSetTrack-method}
\alias{show,ReferenceSequenceTrack-method}
\title{SequenceTrack class and methods}
\usage{
\S4method{initialize}{SequenceTrack}(.Object, chromosome, genome, ...)

SequenceTrack(
  sequence,
  chromosome,
  genome,
  name = "SequenceTrack",
  importFunction,
  stream = FALSE,
  ...
)

RNASequenceTrack(
  sequence,
  chromosome,
  genome,
  name = "SequenceTrack",
  importFunction,
  stream = FALSE,
  ...
)

\S4method{initialize}{SequenceDNAStringSetTrack}(.Object, sequence, ...)

\S4method{initialize}{SequenceRNAStringSetTrack}(.Object, sequence, ...)

\S4method{initialize}{SequenceBSgenomeTrack}(.Object, sequence = NULL, ...)

\S4method{initialize}{ReferenceSequenceTrack}(.Object, stream, reference, ...)

\S4method{seqnames}{SequenceTrack}(x)

\S4method{seqnames}{SequenceBSgenomeTrack}(x)

\S4method{seqlevels}{SequenceTrack}(x)

\S4method{seqlevels}{SequenceBSgenomeTrack}(x)

\S4method{start}{SequenceTrack}(x)

\S4method{end}{SequenceTrack}(x)

\S4method{width}{SequenceTrack}(x)

\S4method{length}{SequenceTrack}(x)

\S4method{chromosome}{SequenceTrack}(GdObject)

\S4method{chromosome}{SequenceTrack}(GdObject) <- value

\S4method{genome}{SequenceTrack}(x)

\S4method{consolidateTrack}{SequenceTrack}(GdObject, chromosome, ...)

\S4method{drawGD}{SequenceTrack}(GdObject, minBase, maxBase, prepare = FALSE, ...)

\S4method{show}{SequenceBSgenomeTrack}(object)

\S4method{show}{SequenceDNAStringSetTrack}(object)

\S4method{show}{SequenceRNAStringSetTrack}(object)

\S4method{show}{ReferenceSequenceTrack}(object)
}
\arguments{
\item{.Object}{.Object}

\item{chromosome}{the currently active chromosome which may have to be set
for a \code{RangeTrack} or a \code{SequenceTrack} object
parameters}

\item{genome}{The genome on which the track's ranges are defined. Usually
this is a valid UCSC genome identifier, however this is not being formally
checked at this point. For a \code{SequenceBSgenomeTrack} object, the genome
information is extracted from the input \code{BSgenome} package. For a
\code{DNAStringSet} it has too be provided or the constructor will fall back
to the default value of \code{NA}.}

\item{\dots}{Additional items which will all be interpreted as further
display parameters. See \code{\link{settings}} and the "Display Parameters"
section below for details.}

\item{sequence}{A meta argument to handle the different input types, making the construction
of a \code{SequenceTrack} as flexible as possible.

The different input options for \code{sequence} are:

\describe{

\item{An object of class \code{\linkS4class{DNAStringSet}}.}{ The individual
\code{\linkS4class{DNAString}}s are considered to be the different
chromosome sequences.}

\item{An object of class \code{\linkS4class{BSgenome}}.}{ The \code{Gviz}
package tries to follow the \code{BSgenome} philosophy in that the
respective chromosome sequences are only realized once they are first
accessed.}

\item{A \code{character} scalar:}{ in this case the value of the
\code{sequence} argument is considered to be a file path to an annotation
file on disk. A range of file types are supported by the \code{Gviz} package
as identified by the file extension. See the \code{importFunction}
documentation below for further details.}
}}

\item{name}{Character scalar of the track's name used in the title panel
when plotting.}

\item{importFunction}{A user-defined function to be used to import the
sequence data from a file. This only applies when the \code{sequence}
argument is a character string with the path to the input data file. The
function needs to accept an argument \code{file} containing the file path
and has to return a proper \code{DNAStringSet} object with the sequence
information per chromosome. A set of default import functions is already
implemented in the package for a number of different file types, and one of
these defaults will be picked automatically based on the extension of the
input file name. If the extension can not be mapped to any of the existing
import function, an error is raised asking for a user-defined import
function. Currently the following file types can be imported with the
default functions: \code{fa/fasta} and \code{2bit}.

Both file types support indexing by genomic coordinates, and it makes sense
to only load the part of the file that is needed for plotting. To this end,
the \code{Gviz} package defines the derived \code{ReferenceSequenceTrack}
class, which supports streaming data from the file system. The user
typically does not have to deal with this distinction but may rely on the
constructor function to make the right choice as long as the default import
functions are used. However, once a user-defined import function has been
provided and if this function adds support for indexed files, you will have
to make the constructor aware of this fact by setting the \code{stream}
argument to \code{TRUE}. Please note that in this case the import function
needs to accept a second mandatory argument \code{selection} which is a
\code{GRanges} object containing the dimensions of the plotted genomic
range. As before, the function has to return an appropriate
\code{DNAStringSet} object.}

\item{stream}{A logical flag indicating that the user-provided import
function can deal with indexed files and knows how to process the additional
\code{selection} argument when accessing the data on disk. This causes the
constructor to return a \code{ReferenceSequenceTrack} object which will grab
the necessary data on the fly during each plotting operation.}

\item{reference}{Name of the file (for streatming).}

\item{x}{A valid track object class name, or the object itself, in which
case the class is derived directly from it.}

\item{GdObject}{the input track object}

\item{value}{Value to be set.}

\item{minBase}{Start of the sequence.}

\item{maxBase}{End of the sequence.}

\item{prepare}{\code{logical}}

\item{object}{object}
}
\value{
The return value of the constructor function is a new object of class
\code{SequenceDNAStringSetTrack}, \code{SequenceBSgenomeTrack} ore
\code{ReferenceSequenceTrack}, depending on the constructor arguments.
Typically the user will not have to be troubled with this distinction and
can rely on the constructor to make the right choice.
}
\description{
A track class to represent genomic sequences. The three child classes
\code{SequenceDNAStringSetTrack}, \code{SequenceRNAStringSetTrack} and
\code{SequenceBSgenomeTrack} do most of the work, however in practise they
are of no particular relevance to the user.
}
\section{Functions}{
\itemize{
\item \code{initialize(SequenceTrack)}: Initialize.

\item \code{SequenceTrack()}: Constructor

\item \code{RNASequenceTrack()}: Constructor

\item \code{SequenceDNAStringSetTrack-class}: The \code{DNAStringSet}-based version of the \code{SequenceTrack-class}.

\item \code{initialize(SequenceDNAStringSetTrack)}: Initialize.

\item \code{SequenceRNAStringSetTrack-class}: The \code{RNAStringSet}-based version of the \code{SequenceTrack-class}.

\item \code{initialize(SequenceRNAStringSetTrack)}: Initialize \code{RNAStringSet}-based version of the \code{SequenceTrack-class}.

\item \code{SequenceBSgenomeTrack-class}: The \code{BSgenome}-based version of the \code{SequenceTrack-class}.

\item \code{initialize(SequenceBSgenomeTrack)}: Initialize.

\item \code{ReferenceSequenceTrack-class}: The file-based version of the \code{SequenceTrack-class}.

\item \code{initialize(ReferenceSequenceTrack)}: Initialize.

\item \code{seqnames(SequenceTrack)}: return the names (i.e., the chromosome)
of the sequences contained in the object.

\item \code{seqnames(SequenceBSgenomeTrack)}: return the names (i.e., the chromosome)
of the sequences contained in the object.

\item \code{seqlevels(SequenceTrack)}: return the names (i.e., the chromosome)
of the sequences contained in the object. Only those with length > 0.

\item \code{seqlevels(SequenceBSgenomeTrack)}: return the names (i.e., the chromosome)
of the sequences contained in the object. Only those with length > 0.

\item \code{start(SequenceTrack)}: return the start coordinates of the track
items.

\item \code{end(SequenceTrack)}: return the end coordinates of the track
items.

\item \code{width(SequenceTrack)}: return the with of the track items in
genomic coordinates.

\item \code{length(SequenceTrack)}: return the length of the sequence for
active chromosome.

\item \code{chromosome(SequenceTrack)}: return the chromosome for which the track
is defined.

\item \code{chromosome(SequenceTrack) <- value}: replace the value of the track's chromosome.
This has to be a valid UCSC chromosome identifier or an integer or character
scalar that can be reasonably coerced into one.

\item \code{genome(SequenceTrack)}: Set the track's genome.
Usually this has to be a valid UCSC identifier, however this is not
formally enforced here.

\item \code{consolidateTrack(SequenceTrack)}: Consolidate/
Determine whether there is \code{chromosome} settings or not, and add this information.

\item \code{drawGD(SequenceTrack)}: plot the object to a graphics device.
The return value of this method is the input object, potentially updated
during the plotting operation. Internally, there are two modes in which the
method can be called. Either in 'prepare' mode, in which case no plotting is
done but the object is preprocessed based on the available space, or in
'plotting' mode, in which case the actual graphical output is created.
Since subsetting of the object can be potentially costly, this can be
switched off in case subsetting has already been performed before or
is not necessary.

\item \code{show(SequenceBSgenomeTrack)}: Show method.

\item \code{show(SequenceDNAStringSetTrack)}: Show method.

\item \code{show(SequenceRNAStringSetTrack)}: Show method.

\item \code{show(ReferenceSequenceTrack)}: Show method.

}}
\section{Objects from the class}{


Objects can be created using the constructor function \code{SequenceTrack}.
}

\examples{
## An empty object
SequenceTrack()

## Construct from DNAStringSet
library(Biostrings)
letters <- c("A", "C", "T", "G", "N")
set.seed(999)
seqs <- DNAStringSet(c(chr1 = paste(sample(letters, 100000, TRUE),
    collapse = ""
), chr2 = paste(sample(letters, 200000, TRUE), collapse = "")))
sTrack <- SequenceTrack(seqs, genome = "hg19")
sTrack

## Construct from BSGenome object
if (require(BSgenome.Hsapiens.UCSC.hg19)) {
    sTrack <- SequenceTrack(Hsapiens)
    sTrack
}


## Set active chromosome
chromosome(sTrack)
chromosome(sTrack) <- "chr2"
head(seqnames(sTrack))
\dontshow{
## For some annoying reason the postscript device does not know about
## the sans font
if (!interactive()) {
    font <- ps.options()$family
    displayPars(sTrack) <- list(fontfamily = font, fontfamily.title = font)
}
}

## Plotting
## Sequences
plotTracks(sTrack, from = 199970, to = 200000)
## Boxes
plotTracks(sTrack, from = 199800, to = 200000)
## Line
plotTracks(sTrack, from = 1, to = 200000)
## Force boxes
plotTracks(sTrack, from = 199970, to = 200000, noLetters = TRUE)
## Direction indicator
plotTracks(sTrack, from = 199970, to = 200000, add53 = TRUE)
## Sequence complement
plotTracks(sTrack, from = 199970, to = 200000, add53 = TRUE, complement = TRUE)
## Colors
plotTracks(sTrack, from = 199970, to = 200000, add53 = TRUE, fontcolor = c(
    A = 1,
    C = 1, G = 1, T = 1, N = 1
))

## Track names
names(sTrack)
names(sTrack) <- "foo"

## Accessors
genome(sTrack)
genome(sTrack) <- "mm9"
length(sTrack)

## Sequence extraction
subseq(sTrack, start = 100000, width = 20)
## beyond the stored sequence range
subseq(sTrack, start = length(sTrack), width = 20)
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
