# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActiveState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Instance State."""

    ACTIVE = "active"
    """Instance is active"""
    INACTIVE = "inactive"
    """Instance is inactive"""


class ConfigurationModel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available configuration models."""

    APPLICATION = "Application"
    """Configuration model Application"""
    COMMON = "Common"
    """Configuration model Common"""


class ConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available configuration types."""

    SHARED = "Shared"
    """Configuration type Shared"""
    HIERARCHY = "Hierarchy"
    """Configuration type Hierarchy"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class ErrorActionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Error Action Mode."""

    STOP_ON_ANY_FAILURE = "stopOnAnyFailure"
    """Stop on any failure"""
    STOP_ON_N_FAILURES = "stopOnNFailures"
    """Stop after N cumulative failures"""
    SILENTLY_CONTINUE = "silentlyContinue"
    """Continue silently despite errors"""


class ExtendedLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The supported ExtendedLocation types."""

    EDGE_ZONE = "EdgeZone"
    """Azure Edge Zones location type"""
    CUSTOM_LOCATION = "CustomLocation"
    """Azure Custom Locations type"""


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of a job or job step."""

    NOT_STARTED = "NotStarted"
    """The job or step is not started."""
    IN_PROGRESS = "InProgress"
    """The job or step is in progress."""
    SUCCEEDED = "Succeeded"
    """The job or step succeeded."""
    FAILED = "Failed"
    """The job or step failed."""


class JobType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """JobType for the job. Supports extensibility via string values."""

    DEPLOY = "deploy"
    """A deployment job."""
    STAGING = "staging"
    """A staging job."""
    EXTERNAL_VALIDATION = "externalValidation"
    """A validation job."""


class OrchestratorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available Orchestrator types."""

    TO = "TO"
    """Default type"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    INITIALIZED = "Initialized"
    """Resource Provisioning is initialized"""
    INPROGRESS = "InProgress"
    """Resource Provisioning is in progress"""
    DELETING = "Deleting"
    """Resource Provisioning is deleting"""


class ReconciliationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines a state of the reconciliation policy."""

    INACTIVE = "inactive"
    """Reconciliation is inactive"""
    ACTIVE = "active"
    """Reconciliation is active"""


class ResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource Type State."""

    ACTIVE = "active"
    """Resource is active"""
    INACTIVE = "inactive"
    """Resource is inactive"""


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Solution Instance State."""

    IN_REVIEW = "InReview"
    """Solution Instance is in review"""
    UPGRADE_IN_REVIEW = "UpgradeInReview"
    """Solution Instance upgrade is in review"""
    READY_TO_DEPLOY = "ReadyToDeploy"
    """Solution Instance is ready to deploy"""
    READY_TO_UPGRADE = "ReadyToUpgrade"
    """Solution Instance is ready to upgrade"""
    DEPLOYING = "Deploying"
    """Solution Instance is deploying"""
    DEPLOYED = "Deployed"
    """Solution Instance is deployed"""
    FAILED = "Failed"
    """Solution Instance failed to deploy"""
    UNDEPLOYED = "Undeployed"
    """Solution Instance is undeployed"""
    PENDING_EXTERNAL_VALIDATION = "PendingExternalValidation"
    """Solution Instance is pending external validation"""
    EXTERNAL_VALIDATION_FAILED = "ExternalValidationFailed"
    """Solution Instance failed external validation"""
    STAGING = "Staging"
    """Solution Instance is staging the images"""


class UpdateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Denotes which part of the version number will be updated."""

    MAJOR = "Major"
    """Major version"""
    MINOR = "Minor"
    """Minor version"""
    PATCH = "Patch"
    """Patch version"""


class ValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Solution Instance Validation Status."""

    VALID = "Valid"
    """Solution Instance is valid"""
    INVALID = "Invalid"
    """Solution Instance is invalid"""
