# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ArmTemplateParameter(_serialization.Model):
    """Parameter to pass to ARM template.

    :ivar name: name of the parameter.
    :vartype name: str
    :ivar value: value for the parameter. In Jtoken.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs):
        """
        :keyword name: name of the parameter.
        :paramtype name: str
        :keyword value: value for the parameter. In Jtoken.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class CodeMessageError(_serialization.Model):
    """The error body contract.

    :ivar error: The error details for a failed request.
    :vartype error: ~azure.mgmt.operationsmanagement.models.CodeMessageErrorError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "CodeMessageErrorError"},
    }

    def __init__(self, *, error: Optional["_models.CodeMessageErrorError"] = None, **kwargs):
        """
        :keyword error: The error details for a failed request.
        :paramtype error: ~azure.mgmt.operationsmanagement.models.CodeMessageErrorError
        """
        super().__init__(**kwargs)
        self.error = error


class CodeMessageErrorError(_serialization.Model):
    """The error details for a failed request.

    :ivar code: The error type.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword code: The error type.
        :paramtype code: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ManagementAssociation(_serialization.Model):
    """The container for solution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar properties: Properties for ManagementAssociation object supported by the
     OperationsManagement resource provider.
    :vartype properties: ~azure.mgmt.operationsmanagement.models.ManagementAssociationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ManagementAssociationProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.ManagementAssociationProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword properties: Properties for ManagementAssociation object supported by the
         OperationsManagement resource provider.
        :paramtype properties: ~azure.mgmt.operationsmanagement.models.ManagementAssociationProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.properties = properties


class ManagementAssociationProperties(_serialization.Model):
    """ManagementAssociation properties supported by the OperationsManagement resource provider.

    All required parameters must be populated in order to send to Azure.

    :ivar application_id: The applicationId of the appliance for this association. Required.
    :vartype application_id: str
    """

    _validation = {
        "application_id": {"required": True},
    }

    _attribute_map = {
        "application_id": {"key": "applicationId", "type": "str"},
    }

    def __init__(self, *, application_id: str, **kwargs):
        """
        :keyword application_id: The applicationId of the appliance for this association. Required.
        :paramtype application_id: str
        """
        super().__init__(**kwargs)
        self.application_id = application_id


class ManagementAssociationPropertiesList(_serialization.Model):
    """the list of ManagementAssociation response.

    :ivar value: List of Management Association properties within the subscription.
    :vartype value: list[~azure.mgmt.operationsmanagement.models.ManagementAssociation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagementAssociation]"},
    }

    def __init__(self, *, value: Optional[List["_models.ManagementAssociation"]] = None, **kwargs):
        """
        :keyword value: List of Management Association properties within the subscription.
        :paramtype value: list[~azure.mgmt.operationsmanagement.models.ManagementAssociation]
        """
        super().__init__(**kwargs)
        self.value = value


class ManagementConfiguration(_serialization.Model):
    """The container for solution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar properties: Properties for ManagementConfiguration object supported by the
     OperationsManagement resource provider.
    :vartype properties: ~azure.mgmt.operationsmanagement.models.ManagementConfigurationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ManagementConfigurationProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.ManagementConfigurationProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword properties: Properties for ManagementConfiguration object supported by the
         OperationsManagement resource provider.
        :paramtype properties:
         ~azure.mgmt.operationsmanagement.models.ManagementConfigurationProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.properties = properties


class ManagementConfigurationProperties(_serialization.Model):
    """ManagementConfiguration properties supported by the OperationsManagement resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar application_id: The applicationId of the appliance for this Management.
    :vartype application_id: str
    :ivar parent_resource_type: The type of the parent resource. Required.
    :vartype parent_resource_type: str
    :ivar parameters: Parameters to run the ARM template. Required.
    :vartype parameters: list[~azure.mgmt.operationsmanagement.models.ArmTemplateParameter]
    :ivar provisioning_state: The provisioning state for the ManagementConfiguration.
    :vartype provisioning_state: str
    :ivar template: The Json object containing the ARM template to deploy. Required.
    :vartype template: JSON
    """

    _validation = {
        "parent_resource_type": {"required": True},
        "parameters": {"required": True},
        "provisioning_state": {"readonly": True},
        "template": {"required": True},
    }

    _attribute_map = {
        "application_id": {"key": "applicationId", "type": "str"},
        "parent_resource_type": {"key": "parentResourceType", "type": "str"},
        "parameters": {"key": "parameters", "type": "[ArmTemplateParameter]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "template": {"key": "template", "type": "object"},
    }

    def __init__(
        self,
        *,
        parent_resource_type: str,
        parameters: List["_models.ArmTemplateParameter"],
        template: JSON,
        application_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword application_id: The applicationId of the appliance for this Management.
        :paramtype application_id: str
        :keyword parent_resource_type: The type of the parent resource. Required.
        :paramtype parent_resource_type: str
        :keyword parameters: Parameters to run the ARM template. Required.
        :paramtype parameters: list[~azure.mgmt.operationsmanagement.models.ArmTemplateParameter]
        :keyword template: The Json object containing the ARM template to deploy. Required.
        :paramtype template: JSON
        """
        super().__init__(**kwargs)
        self.application_id = application_id
        self.parent_resource_type = parent_resource_type
        self.parameters = parameters
        self.provisioning_state = None
        self.template = template


class ManagementConfigurationPropertiesList(_serialization.Model):
    """the list of ManagementConfiguration response.

    :ivar value: List of Management Configuration properties within the subscription.
    :vartype value: list[~azure.mgmt.operationsmanagement.models.ManagementConfiguration]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagementConfiguration]"},
    }

    def __init__(self, *, value: Optional[List["_models.ManagementConfiguration"]] = None, **kwargs):
        """
        :keyword value: List of Management Configuration properties within the subscription.
        :paramtype value: list[~azure.mgmt.operationsmanagement.models.ManagementConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value


class Operation(_serialization.Model):
    """Supported operation of OperationsManagement resource provider.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.operationsmanagement.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.operationsmanagement.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft OperationsManagement.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft OperationsManagement.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(_serialization.Model):
    """Result of the request to list solution operations.

    :ivar value: List of solution operations supported by the OperationsManagement resource
     provider.
    :vartype value: list[~azure.mgmt.operationsmanagement.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs):
        """
        :keyword value: List of solution operations supported by the OperationsManagement resource
         provider.
        :paramtype value: list[~azure.mgmt.operationsmanagement.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class Solution(_serialization.Model):
    """The container for solution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: Plan for solution object supported by the OperationsManagement resource provider.
    :vartype plan: ~azure.mgmt.operationsmanagement.models.SolutionPlan
    :ivar properties: Properties for solution object supported by the OperationsManagement resource
     provider.
    :vartype properties: ~azure.mgmt.operationsmanagement.models.SolutionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "SolutionPlan"},
        "properties": {"key": "properties", "type": "SolutionProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.SolutionPlan"] = None,
        properties: Optional["_models.SolutionProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Plan for solution object supported by the OperationsManagement resource
         provider.
        :paramtype plan: ~azure.mgmt.operationsmanagement.models.SolutionPlan
        :keyword properties: Properties for solution object supported by the OperationsManagement
         resource provider.
        :paramtype properties: ~azure.mgmt.operationsmanagement.models.SolutionProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.plan = plan
        self.properties = properties


class SolutionPatch(_serialization.Model):
    """The properties of a Solution that can be patched.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class SolutionPlan(_serialization.Model):
    """Plan for solution object supported by the OperationsManagement resource provider.

    :ivar name: name of the solution to be created. For Microsoft published solution it should be
     in the format of solutionType(workspaceName). SolutionType part is case sensitive. For third
     party solution, it can be anything.
    :vartype name: str
    :ivar publisher: Publisher name. For gallery solution, it is Microsoft.
    :vartype publisher: str
    :ivar promotion_code: promotionCode, Not really used now, can you left as empty.
    :vartype promotion_code: str
    :ivar product: name of the solution to enabled/add. For Microsoft published gallery solution it
     should be in the format of OMSGallery/:code:`<solutionType>`. This is case sensitive.
    :vartype product: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        promotion_code: Optional[str] = None,
        product: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: name of the solution to be created. For Microsoft published solution it should
         be in the format of solutionType(workspaceName). SolutionType part is case sensitive. For third
         party solution, it can be anything.
        :paramtype name: str
        :keyword publisher: Publisher name. For gallery solution, it is Microsoft.
        :paramtype publisher: str
        :keyword promotion_code: promotionCode, Not really used now, can you left as empty.
        :paramtype promotion_code: str
        :keyword product: name of the solution to enabled/add. For Microsoft published gallery solution
         it should be in the format of OMSGallery/:code:`<solutionType>`. This is case sensitive.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.promotion_code = promotion_code
        self.product = product


class SolutionProperties(_serialization.Model):
    """Solution properties supported by the OperationsManagement resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar workspace_resource_id: The azure resourceId for the workspace where the solution will be
     deployed/enabled. Required.
    :vartype workspace_resource_id: str
    :ivar provisioning_state: The provisioning state for the solution.
    :vartype provisioning_state: str
    :ivar contained_resources: The azure resources that will be contained within the solutions.
     They will be locked and gets deleted automatically when the solution is deleted.
    :vartype contained_resources: list[str]
    :ivar referenced_resources: The resources that will be referenced from this solution. Deleting
     any of those solution out of band will break the solution.
    :vartype referenced_resources: list[str]
    """

    _validation = {
        "workspace_resource_id": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "workspace_resource_id": {"key": "workspaceResourceId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "contained_resources": {"key": "containedResources", "type": "[str]"},
        "referenced_resources": {"key": "referencedResources", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        workspace_resource_id: str,
        contained_resources: Optional[List[str]] = None,
        referenced_resources: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword workspace_resource_id: The azure resourceId for the workspace where the solution will
         be deployed/enabled. Required.
        :paramtype workspace_resource_id: str
        :keyword contained_resources: The azure resources that will be contained within the solutions.
         They will be locked and gets deleted automatically when the solution is deleted.
        :paramtype contained_resources: list[str]
        :keyword referenced_resources: The resources that will be referenced from this solution.
         Deleting any of those solution out of band will break the solution.
        :paramtype referenced_resources: list[str]
        """
        super().__init__(**kwargs)
        self.workspace_resource_id = workspace_resource_id
        self.provisioning_state = None
        self.contained_resources = contained_resources
        self.referenced_resources = referenced_resources


class SolutionPropertiesList(_serialization.Model):
    """the list of solution response.

    :ivar value: List of solution properties within the subscription.
    :vartype value: list[~azure.mgmt.operationsmanagement.models.Solution]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Solution]"},
    }

    def __init__(self, *, value: Optional[List["_models.Solution"]] = None, **kwargs):
        """
        :keyword value: List of solution properties within the subscription.
        :paramtype value: list[~azure.mgmt.operationsmanagement.models.Solution]
        """
        super().__init__(**kwargs)
        self.value = value
