# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActiveDirectoryAuth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ActiveDirectoryAuth."""

    ENABLED = "enabled"
    DISABLED = "disabled"


class ConfigurationDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data type of the configuration."""

    BOOLEAN = "Boolean"
    NUMERIC = "Numeric"
    INTEGER = "Integer"
    ENUMERATION = "Enumeration"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class OperationOrigin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation."""

    NOT_SPECIFIED = "NotSpecified"
    USER = "user"
    SYSTEM = "system"


class PasswordAuth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PasswordAuth."""

    ENABLED = "enabled"
    DISABLED = "disabled"


class PrincipalType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PrincipalType."""

    USER = "user"
    SERVICE_PRINCIPAL = "servicePrincipal"
    GROUP = "group"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"


class RoleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RoleType."""

    USER = "user"
    ADMIN = "admin"


class ServerRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role of a server."""

    COORDINATOR = "Coordinator"
    WORKER = "Worker"
