# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistry import ContainerRegistryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryManagementPipelineRunsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipeline_runs_list(self, resource_group):
        response = self.client.pipeline_runs.list(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipeline_runs_get(self, resource_group):
        response = self.client.pipeline_runs.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            pipeline_run_name="str",
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipeline_runs_begin_create(self, resource_group):
        response = self.client.pipeline_runs.begin_create(
            resource_group_name=resource_group.name,
            registry_name="str",
            pipeline_run_name="str",
            pipeline_run_create_parameters={
                "forceUpdateTag": "str",
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "request": {
                    "artifacts": ["str"],
                    "catalogDigest": "str",
                    "pipelineResourceId": "str",
                    "source": {"name": "str", "type": "AzureStorageBlob"},
                    "target": {"name": "str", "type": "AzureStorageBlob"},
                },
                "response": {
                    "catalogDigest": "str",
                    "finishTime": "2020-02-20 00:00:00",
                    "importedArtifacts": ["str"],
                    "pipelineRunErrorMessage": "str",
                    "progress": {"percentage": "str"},
                    "source": {"keyVaultUri": "str", "type": "AzureStorageBlobContainer", "uri": "str"},
                    "startTime": "2020-02-20 00:00:00",
                    "status": "str",
                    "target": {"keyVaultUri": "str", "type": "str", "uri": "str"},
                    "trigger": {"sourceTrigger": {"timestamp": "2020-02-20 00:00:00"}},
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipeline_runs_begin_delete(self, resource_group):
        response = self.client.pipeline_runs.begin_delete(
            resource_group_name=resource_group.name,
            registry_name="str",
            pipeline_run_name="str",
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
