---
page_type: sample
languages:
  - python
products:
  - azure
  - azure-confidentialledger
urlFragment: azure-confidentialledger-certificate-samples
---

# Azure Confidential Ledger Certificate client library for Python Samples

These are code samples that show common scenario operations with the Azure Confidential Ledger Certificate client library.
The async versions of the samples (the python sample files appended with `_async`) show asynchronous operations.

## Prerequisites

- Python 3.6 or later is required to use this package
- You need an [Azure subscription][azure_sub], and a [Azure Confidential Ledger service instance][confidential_ledger_docs] to use this package.

## Setup

1. Install the Azure Confidential Ledger Certificate client library for Python with [pip](https://pypi.org/project/pip/):

```bash
pip install azure-confidentialledger-certificate
```

2. Clone or download this sample repository
3. Open the sample folder in Visual Studio Code or your IDE of choice.

## Running the samples

1. Open a terminal window and `cd` to the directory that the samples are saved in.
2. Set the environment variables specified in the sample file you wish to run.
3. Follow the usage described in the file.

## Next Steps

Take a look at our [API Documentation][reference_docs] for more information about the APIs that are available in the clients.

<!-- LINKS -->

[azure_sub]: https://azure.microsoft.com/free/
[confidential_ledger_docs]: https://aka.ms/confidentialledger-servicedocs
[reference_docs]: https://aka.ms/azsdk/python/confidentialledger/ref-docs
