# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.applicationinsights import ApplicationInsightsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationInsightsManagementExportConfigurationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationInsightsManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_export_configurations_list(self, resource_group):
        response = self.client.export_configurations.list(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_export_configurations_create(self, resource_group):
        response = self.client.export_configurations.create(
            resource_group_name=resource_group.name,
            resource_name="str",
            export_properties={
                "DestinationAccountId": "str",
                "DestinationAddress": "str",
                "DestinationStorageLocationId": "str",
                "DestinationStorageSubscriptionId": "str",
                "DestinationType": "str",
                "IsEnabled": "str",
                "NotificationQueueEnabled": "str",
                "NotificationQueueUri": "str",
                "RecordTypes": "str",
            },
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_export_configurations_delete(self, resource_group):
        response = self.client.export_configurations.delete(
            resource_group_name=resource_group.name,
            resource_name="str",
            export_id="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_export_configurations_get(self, resource_group):
        response = self.client.export_configurations.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            export_id="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_export_configurations_update(self, resource_group):
        response = self.client.export_configurations.update(
            resource_group_name=resource_group.name,
            resource_name="str",
            export_id="str",
            export_properties={
                "DestinationAccountId": "str",
                "DestinationAddress": "str",
                "DestinationStorageLocationId": "str",
                "DestinationStorageSubscriptionId": "str",
                "DestinationType": "str",
                "IsEnabled": "str",
                "NotificationQueueEnabled": "str",
                "NotificationQueueUri": "str",
                "RecordTypes": "str",
            },
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...
