# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementSubscriptionOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_list(self, resource_group):
        response = self.client.subscription.list(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_get_entity_tag(self, resource_group):
        response = self.client.subscription.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_get(self, resource_group):
        response = self.client.subscription.get(
            resource_group_name=resource_group.name,
            service_name="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_create_or_update(self, resource_group):
        response = self.client.subscription.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            sid="str",
            parameters={
                "allowTracing": bool,
                "displayName": "str",
                "ownerId": "str",
                "primaryKey": "str",
                "scope": "str",
                "secondaryKey": "str",
                "state": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_update(self, resource_group):
        response = self.client.subscription.update(
            resource_group_name=resource_group.name,
            service_name="str",
            sid="str",
            if_match="str",
            parameters={
                "allowTracing": bool,
                "displayName": "str",
                "expirationDate": "2020-02-20 00:00:00",
                "ownerId": "str",
                "primaryKey": "str",
                "scope": "str",
                "secondaryKey": "str",
                "state": "str",
                "stateComment": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_delete(self, resource_group):
        response = self.client.subscription.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            sid="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_regenerate_primary_key(self, resource_group):
        response = self.client.subscription.regenerate_primary_key(
            resource_group_name=resource_group.name,
            service_name="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_regenerate_secondary_key(self, resource_group):
        response = self.client.subscription.regenerate_secondary_key(
            resource_group_name=resource_group.name,
            service_name="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_subscription_list_secrets(self, resource_group):
        response = self.client.subscription.list_secrets(
            resource_group_name=resource_group.name,
            service_name="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
