# == Class: vmms::worker
#
# Installs & configure theVMMS worker
#
# === Parameters
# [*package_ensure*]
#    (Optional) Ensure state for package.
#    Defaults to present
#
# [*enabled*]
#   (optional) Should the service be enabled.
#   Defaults to 'true'.
#
# [*manage_service*]
#   (optional) Whether the service should be managed by Puppet.
#   Defaults to 'true'.
#
# [*coordination_url*]
#   Defaults to $facts['os_service_default'].
#
# [*mistral_use_keystone_auth*]
#   Defaults to $facts['os_service_default'].
#
# [*my_hostname*]
#   Defaults to $facts['os_service_default'].
#
# [*parallel_jobs*]
#   Defaults to $facts['os_service_default'].
#
# [*check_interval*]
#   Defaults to $facts['os_service_default'].
#
# [*migration_start_time*]
#   Defaults to $facts['os_service_default'].
#
# [*migration_end_time*]
#   Defaults to $facts['os_service_default'].
#
# [*mistral_workflow_name*]
#   Defaults to $facts['os_service_default'].
#
class vmms::worker (
  $package_ensure                       = present,
  Boolean $manage_service               = true,
  Boolean $enabled                      = true,
  $coordination_url                     = $facts['os_service_default'],
  $mistral_use_keystone_auth            = $facts['os_service_default'],
  $my_hostname                          = $facts['os_service_default'],
  $parallel_jobs                        = $facts['os_service_default'],
  $check_interval                       = $facts['os_service_default'],
  String $migration_start_time          = $facts['os_service_default'],
  String $migration_end_time            = $facts['os_service_default'],
  $mistral_workflow_name                = $facts['os_service_default'],
) {

  include vmms::deps
  include vmms::params

  package { 'vmms-worker':
    ensure => $package_ensure,
    name   => $::vmms::params::worker_package_name,
    tag    => ['openstack', 'vmms-package'],
  }

  if $manage_service {
    if $enabled {
      $service_ensure = 'running'
    } else {
      $service_ensure = 'stopped'
    }

    service { 'vmms-worker':
      ensure     => $service_ensure,
      name       => $::vmms::params::worker_service_name,
      enable     => $enabled,
      hasstatus  => true,
      hasrestart => true,
      tag        => 'vmms-service',
    }
  }

  vmms_config {
    'worker/coordination_url':          value => $coordination_url;
    'worker/mistral_use_keystone_auth': value => $mistral_use_keystone_auth;
    'worker/my_hostname':               value => $my_hostname;
    'worker/parallel_jobs':             value => $parallel_jobs;
    'worker/check_interval':            value => $check_interval;
    'worker/migration_start_time':      value => $migration_start_time;
    'worker/migration_end_time':        value => $migration_end_time;
    'worker/mistral_workflow_name':     value => $mistral_workflow_name;
  }
}
