! (C) Copyright 2013 ECMWF.
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation nor
! does it submit to any jurisdiction.

! This File contains Unit Tests for testing the
! C++ / Fortran Interfaces to the Mesh Datastructure
! @author Willem Deconinck

#include "fckit/fctest.h"

! -----------------------------------------------------------------------------

TESTSUITE(fctest_unstructuredgrid)

! -----------------------------------------------------------------------------

TESTSUITE_INIT
  use atlas_module
  call atlas_library%initialise()
END_TESTSUITE_INIT

! -----------------------------------------------------------------------------

TESTSUITE_FINALIZE
  use atlas_module
  call atlas_library%finalise()
END_TESTSUITE_FINALIZE

! ----------------------------------------------------------------------------

TEST( test_unstructuredgrid )
  use, intrinsic :: iso_c_binding
  use atlas_module
  implicit none
  type(atlas_UnstructuredGrid) :: grid
  type(atlas_Mesh) :: mesh
  type(atlas_Output) :: gmsh
  type(atlas_MeshGenerator) :: meshgenerator

  real(c_double) :: xy(2,173)
  xy(:,1) = [180,0]
  xy(:,2) = [90,0]
  xy(:,3) = [-90,0]
  xy(:,4) = [0,90]
  xy(:,5) = [0,-90]
  xy(:,6) = [0,0]
  xy(:,7) = [18,0]
  xy(:,8) = [36,0]
  xy(:,9) = [54,0]
  xy(:,10) = [72,0]
  xy(:,11) = [108,0]
  xy(:,12) = [126,0]
  xy(:,13) = [144,0]
  xy(:,14) = [162,0]
  xy(:,15) = [-162,0]
  xy(:,16) = [-144,0]
  xy(:,17) = [-126,0]
  xy(:,18) = [-108,0]
  xy(:,19) = [-72,0]
  xy(:,20) = [-54,0]
  xy(:,21) = [-36,0]
  xy(:,22) = [-18,0]
  xy(:,23) = [0,18]
  xy(:,24) = [0,36]
  xy(:,25) = [0,54]
  xy(:,26) = [0,72]
  xy(:,27) = [180,72]
  xy(:,28) = [180,54]
  xy(:,29) = [180,36]
  xy(:,30) = [180,18]
  xy(:,31) = [180,-18]
  xy(:,32) = [180,-36]
  xy(:,33) = [180,-54]
  xy(:,34) = [180,-72]
  xy(:,35) = [0,-72]
  xy(:,36) = [0,-54]
  xy(:,37) = [0,-36]
  xy(:,38) = [0,-18]
  xy(:,39) = [90,18]
  xy(:,40) = [90,36]
  xy(:,41) = [90,54]
  xy(:,42) = [90,72]
  xy(:,43) = [-90,72]
  xy(:,44) = [-90,54]
  xy(:,45) = [-90,36]
  xy(:,46) = [-90,18]
  xy(:,47) = [-90,-18]
  xy(:,48) = [-90,-36]
  xy(:,49) = [-90,-54]
  xy(:,50) = [-90,-72]
  xy(:,51) = [90,-72]
  xy(:,52) = [90,-54]
  xy(:,53) = [90,-36]
  xy(:,54) = [90,-18]
  xy(:,55) = [123.974,-58.6741]
  xy(:,56) = [154.087,-16.9547]
  xy(:,57) = [154.212,-58.8675]
  xy(:,58) = [114.377,-41.9617]
  xy(:,59) = [125.567,-23.5133]
  xy(:,60) = [137.627,-40.8524]
  xy(:,61) = [106.162,-24.5874]
  xy(:,62) = [158.508,-38.55]
  xy(:,63) = [137.826,-72.8109]
  xy(:,64) = [142.103,-26.799]
  xy(:,65) = [138.256,-13.8871]
  xy(:,66) = [168.39,-24.3266]
  xy(:,67) = [168.954,-12.0094]
  xy(:,68) = [117.333,-12.35]
  xy(:,69) = [102.254,-11.1537]
  xy(:,70) = [120.307,59.7167]
  xy(:,71) = [107.196,26.0167]
  xy(:,72) = [144.768,28.3721]
  xy(:,73) = [150.891,60.0343]
  xy(:,74) = [164.566,25.5053]
  xy(:,75) = [116.851,14.0295]
  xy(:,76) = [124.84,28.3978]
  xy(:,77) = [157.901,42.042]
  xy(:,78) = [111.41,43.1056]
  xy(:,79) = [134.333,44.6677]
  xy(:,80) = [103.277,11.707]
  xy(:,81) = [135.358,73.2119]
  xy(:,82) = [135.349,14.2311]
  xy(:,83) = [153.48,13.386]
  xy(:,84) = [168.071,11.5344]
  xy(:,85) = [-162.99,26.3775]
  xy(:,86) = [-147.519,56.1313]
  xy(:,87) = [-122.579,27.4824]
  xy(:,88) = [-117.909,59.2376]
  xy(:,89) = [-104.052,27.3616]
  xy(:,90) = [-153.107,14.9717]
  xy(:,91) = [-110.833,41.7436]
  xy(:,92) = [-144.847,32.8534]
  xy(:,93) = [-161.546,42.1031]
  xy(:,94) = [-129.866,44.5201]
  xy(:,95) = [-133.883,72.4163]
  xy(:,96) = [-166.729,11.8907]
  xy(:,97) = [-135.755,15.2529]
  xy(:,98) = [-106.063,14.4869]
  xy(:,99) = [-119.452,11.7037]
  xy(:,100) = [-146.026,-58.6741]
  xy(:,101) = [-115.913,-16.9547]
  xy(:,102) = [-115.788,-58.8675]
  xy(:,103) = [-155.623,-41.9617]
  xy(:,104) = [-144.433,-23.5133]
  xy(:,105) = [-132.373,-40.8524]
  xy(:,106) = [-163.838,-24.5874]
  xy(:,107) = [-111.492,-38.55]
  xy(:,108) = [-132.174,-72.8109]
  xy(:,109) = [-127.897,-26.799]
  xy(:,110) = [-131.744,-13.8871]
  xy(:,111) = [-101.61,-24.3266]
  xy(:,112) = [-101.046,-12.0094]
  xy(:,113) = [-152.667,-12.35]
  xy(:,114) = [-167.746,-11.1537]
  xy(:,115) = [-14.0127,-27.2963]
  xy(:,116) = [-59.193,-57.0815]
  xy(:,117) = [-56.465,-19.5751]
  xy(:,118) = [-27.056,-59.3077]
  xy(:,119) = [-57.124,-35.9752]
  xy(:,120) = [-33.4636,-28.3914]
  xy(:,121) = [-74.8037,-46.8602]
  xy(:,122) = [-40.089,-45.1376]
  xy(:,123) = [-74.8149,-28.3136]
  xy(:,124) = [-21.3072,-42.2177]
  xy(:,125) = [-44.0778,-72.6353]
  xy(:,126) = [-19.6969,-12.8527]
  xy(:,127) = [-40.1318,-12.1601]
  xy(:,128) = [-72.691,-11.4129]
  xy(:,129) = [-56.0261,58.6741]
  xy(:,130) = [-25.9127,16.9547]
  xy(:,131) = [-25.7876,58.8675]
  xy(:,132) = [-65.6229,41.9617]
  xy(:,133) = [-54.4335,23.5133]
  xy(:,134) = [-42.373,40.8524]
  xy(:,135) = [-73.838,24.5874]
  xy(:,136) = [-21.4917,38.55]
  xy(:,137) = [-42.1744,72.8109]
  xy(:,138) = [-37.8974,26.799]
  xy(:,139) = [-41.7437,13.8871]
  xy(:,140) = [-11.6095,24.3266]
  xy(:,141) = [-11.0459,12.0094]
  xy(:,142) = [-62.667,12.35]
  xy(:,143) = [-77.7456,11.1537]
  xy(:,144) = [30.3071,59.7167]
  xy(:,145) = [17.1956,26.0167]
  xy(:,146) = [54.7676,28.3721]
  xy(:,147) = [60.8915,60.0343]
  xy(:,148) = [74.5657,25.5053]
  xy(:,149) = [26.8506,14.0295]
  xy(:,150) = [34.8398,28.3978]
  xy(:,151) = [67.9014,42.042]
  xy(:,152) = [21.41,43.1056]
  xy(:,153) = [44.3335,44.6677]
  xy(:,154) = [13.2772,11.707]
  xy(:,155) = [45.3579,73.2119]
  xy(:,156) = [45.3492,14.2311]
  xy(:,157) = [63.4799,13.386]
  xy(:,158) = [78.0714,11.5344]
  xy(:,159) = [17.01,-26.3775]
  xy(:,160) = [32.4806,-56.1313]
  xy(:,161) = [57.4213,-27.4824]
  xy(:,162) = [62.0912,-59.2376]
  xy(:,163) = [75.9483,-27.3616]
  xy(:,164) = [26.893,-14.9717]
  xy(:,165) = [69.1672,-41.7436]
  xy(:,166) = [35.1527,-32.8534]
  xy(:,167) = [18.4543,-42.1031]
  xy(:,168) = [50.1344,-44.5201]
  xy(:,169) = [46.1172,-72.4163]
  xy(:,170) = [13.2711,-11.8907]
  xy(:,171) = [44.2448,-15.2529]
  xy(:,172) = [73.9368,-14.4869]
  xy(:,173) = [60.5478,-11.7037]

  grid = atlas_UnstructuredGrid(xy)

  FCTEST_CHECK_EQUAL( grid%owners(), 1 )

  meshgenerator = atlas_MeshGenerator("delaunay")
  mesh = meshgenerator%generate(grid)
  FCTEST_CHECK_EQUAL( mesh%owners(), 1 )

  FCTEST_CHECK_EQUAL( grid%owners(), 2 )

  gmsh = atlas_output_Gmsh("atlas_fctest_unstructuredgrid.msh",coordinates="xyz")
  call gmsh%write(mesh)


  call mesh%final()
  FCTEST_CHECK_EQUAL( grid%owners(), 1 )
  call gmsh%final()
  call grid%final()
  call meshgenerator%final()
END_TEST

! -----------------------------------------------------------------------------

END_TESTSUITE

