#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:vincent.vole@example.com"
IMPOSTER="mailto:oliver.otter@example.com"
SENDER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER"
echo 'no' > "$PREFS/$USER/participating"

mkdir -p "$PREFS/$SENDER"
echo 'yes' > "$PREFS/$SENDER/participating"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   ! grep -q 'METHOD:REPLY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Show the request to the outgoing handler first.

"$OUTGOING_SCRIPT" < "$TEMPLATES/event-request-person.txt" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "object" "event6@example.com" \
>  out0O.tmp

   grep -q "event6@example.com" "out0O.tmp" \
&& echo "Success" \
|| echo "Failed"

# Send a request to the recipient.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   ! grep -q 'METHOD:REPLY' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2f.tmp

   ! grep -q "event6@example.com" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out2s.tmp

   ! grep -q "event6@example.com" "out2s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Make sure that the recipient ignored it.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" < "$TEMPLATES/event-request-person-object.txt" 2>> $ERROR \
| tee out3.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Now see if an imposter can invite themself to the event.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$IMPOSTER" < "$TEMPLATES/event-request-person-imposter-object.txt" 2>> $ERROR \
| tee out4.tmp \
| "$PERSON_SCRIPT" $ARGS 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "object" "event6@example.com" \
>  out5O.tmp

   ! grep -q "otter" "out5O.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$IMPOSTER" \
>  out5s.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out5s.tmp" \
&& echo "Success" \
|| echo "Failed"
