# Governance Policy

This document provides the governance policy for F3D (the "Project"). [Every person](./MAINTAINERS_AND_CONTRIBUTORS.md) responsible for its maintenance (the "Maintainers") agrees to this policy and to abide by all Project policies, including the [code of conduct](../../CODE_OF_CONDUCT.md) by adding their name to the [MAINTAINERS_AND_CONTRIBUTORS.md](./MAINTAINERS_AND_CONTRIBUTORS.md) file.

## 1. Roles

This Project includes the following roles.

### 1.1. Maintainers

Maintainers are responsible for organizing activities around developing, maintaining, and updating the Project. Maintainers are responsible of upholding the [Code of Conduct](../../CODE_OF_CONDUCT.md). Maintainers are also responsible for determining consensus for technical or community matters. The Project may add or remove Maintainers by affirmative vote of 2/3 of all Maintainers. Maintainers are de-facto moderators. Maintainers are part of the f3d-app github organization with a "owner" role and listed in the [dedicated](./MAINTAINERS_AND_CONTRIBUTORS.md) file.

Maintainers is an important role and as such, will be evaluated by the community yearly and exit interview may be conducted in case of a Maintainer leaving the role.

Any Returning Contributor interested to become a Maintainer should just reach out to existing Maintainers for consideration.

### 1.1. Moderators

Moderators are responsible of upholding the [Code of Conduct](../../CODE_OF_CONDUCT.md). Moderators are responsible for determining consensus for community matters. The Project may add or remove Maintainers by affirmative vote of 2/3 of all Maintainers.

Anyone interested to become a moderators should just reach out to existing Maintainers for consideration.

### 1.2. Returning Contributors

Returning Contributors are those who have made multiple contributions to the Project and want to be acknowledged as such. Returning Contributors are also very much welcome to share their ideas and feedbacks about the development and maintenance of F3D. Returning contributors may be asked by others about their contributions, provide reviews on code they are familiar with, provide technical insight during discussions and take part in any related activities they wish to.

Returning Contributors can also work on ["bounty" issues](../../CONTRIBUTING.md#bounties) in order to receive donations.
To become a Returning Contributor, one need to have merged at least two pull requests into the F3D repositories. Returning Contributors are part of the f3d-app github organization with a "member" role and are listed in the [dedicated](./MAINTAINERS_AND_CONTRIBUTORS.md) file.

Usually Maintainers will reach out to potential Returning Contributors but in case it was missed, one should reach out to Maintainers for consideration.

Maintainers may decide to list a returning contributor as inactive after a year without contributions, in that case they will be removed from the f3d-app github organization until active again.

### 1.3. Contributors

Contributors are those who have made or want to make contributions to the Project.

### 1.4. Mentees

Mentees are contributors that are enrolled in the mentoring program of F3D. It is open to anyone willing to learn more about open source contribution to F3D
and be helped by Maintainers and Contributors on [discord](https://discord.f3d.app).

### 1.5. Sponsor

Sponsor are users that are currently sponsoring the project. They are acknowledged as such in each release and on [discord](https://discord.f3d.app). Sponsoring can be done either one-time or monthly. One-time sponsor will only be considered sponsor until the next release. See the detail on our [sponsor page](https://github.com/sponsors/f3d-app).

### 1.6 Industry sponsor

Industry sponsor are company that are currently sponsoring the project. They are acknowledged as such in each release and in the [README.md](../../README.md) of the project with an appropriate logo. Potential industry sponsor should reach out to maintainers.

## 2. Decisions

### 2.1 Consensus-Based Decision Making

The Project makes decisions through the consensus of the Maintainers. While explicit agreement of all Maintainers is preferred, it is not required for consensus. Rather, the Maintainers will determine consensus based on their good faith consideration of several factors, including the dominant view of the Contributors and the nature of support and objections. The Maintainers will document evidence of consensus in accordance with these requirements using issues comments.

### 2.2. Appeal Process

Decisions may be appealed by opening an issue and that appeal will be considered by the Maintainers in good faith, who will respond in writing within a reasonable time.

## 3. How We Work

### 3.1. Openness

Participation is open to anyone who is directly and materially affected by the activity in question. There shall be no undue financial barriers to participation.

### 3.2. Balance

The development process should balance the interests of Contributors and other stakeholders. Contributors from diverse interest categories shall be sought with the objective of achieving balance.

### 3.3. Coordination and Harmonization

Good faith efforts shall be made to resolve potential conflicts or incompatibility between releases in the Project.

### 3.4. Consideration of Views and Objections

Prompt consideration shall be given to the written views and objections of all Contributors.

### 3.5. Written procedures

This governance document and other materials documenting the Project development process shall be available to any interested person.

## 4. No Confidentiality

Information disclosed in connection with any Project activity, including but not limited to meetings, contributions, and submissions, is not confidential, regardless of any markings or statements to the contrary.

## 5. Amendments

Amendments to this governance policy may be made by affirmative vote of 2/3 of all Maintainers.

---

Modified from of MVG-0.1-beta GOVERNANCE.md. Licensed under the [CC-BY 4.0 License](https://creativecommons.org/licenses/by-sa/4.0/).
