/**
 * This file is part of the Detox package.
 *
 * Copyright (c) Doug Harple <detox.dharple@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 */

#include "table.h"
#include "builtin_table.h"

/**
 * Generated from safe.tbl
 */

static table_row_t builtin_safe_rows[55] = {
    { .key  = 0x0001, .data = "_" },
    { .key  = 0x0002, .data = "_" },
    { .key  = 0x0003, .data = "_" },
    { .key  = 0x0004, .data = "_" },
    { .key  = 0x0005, .data = "_" },
    { .key  = 0x0006, .data = "_" },
    { .key  = 0x0007, .data = "_" },
    { .key  = 0x0008, .data = "_" },
    { .key  = 0x0009, .data = "_" },
    { .key  = 0x000a, .data = "_" },
    { .key  = 0x000b, .data = "_" },
    { .key  = 0x000c, .data = "_" },
    { .key  = 0x000d, .data = "_" },
    { .key  = 0x000e, .data = "_" },
    { .key  = 0x000f, .data = "_" },
    { .key  = 0x0010, .data = "_" },
    { .key  = 0x0011, .data = "_" },
    { .key  = 0x0012, .data = "_" },
    { .key  = 0x0013, .data = "_" },
    { .key  = 0x0014, .data = "_" },
    { .key  = 0x0015, .data = "_" },
    { .key  = 0x0016, .data = "_" },
    { .key  = 0x0017, .data = "_" },
    { .key  = 0x0018, .data = "_" },
    { .key  = 0x0019, .data = "_" },
    { .key  = 0x001a, .data = "_" },
    { .key  = 0x001b, .data = "_" },
    { .key  = 0x001c, .data = "_" },
    { .key  = 0x001d, .data = "_" },
    { .key  = 0x001e, .data = "_" },
    { .key  = 0x001f, .data = "_" },
    { .key  = 0x0020, .data = "_" },
    { .key  = 0x0021, .data = "_" },
    { .key  = 0x0022, .data = "_" },
    { .key  = 0x0024, .data = "_" },
    { .key  = 0x0026, .data = "_and_" },
    { .key  = 0x0027, .data = "_" },
    { .key  = 0x0028, .data = "-" },
    { .key  = 0x0029, .data = "-" },
    { .key  = 0x002a, .data = "_" },
    { .key  = 0x002f, .data = "_" },
    { .key  = 0x003a, .data = "_" },
    { .key  = 0x003b, .data = "_" },
    { .key  = 0x003c, .data = "_" },
    { .key  = 0x003e, .data = "_" },
    { .key  = 0x003f, .data = "_" },
    { .key  = 0x0040, .data = "_" },
    { .key  = 0x005b, .data = "-" },
    { .key  = 0x005c, .data = "_" },
    { .key  = 0x005d, .data = "-" },
    { .key  = 0x0060, .data = "_" },
    { .key  = 0x007b, .data = "-" },
    { .key  = 0x007c, .data = "_" },
    { .key  = 0x007d, .data = "-" },
    { .key  = 0x007f, .data = "_" },
};

static table_t builtin_safe_table = {
    .length              = 55,
    .used                = 55,
    .max_data_length     = 5,
    .max_key             = 0x007f,
    .hits                = 0,
    .misses              = 0,
    .seeks               = 0,
    .overwrites          = 0,
    .use_hash            = 0,
    .builtin             = 1,
    .rows                = builtin_safe_rows,
    .default_translation = NULL,
};

table_t *load_builtin_safe_table(void)
{
    return table_resize(&builtin_safe_table, 256, 1);
}

/**
 * Generated from iso8859_1.tbl
 */

static table_row_t builtin_iso8859_1_rows[96] = {
    { .key  = 0x00a0, .data = " " },
    { .key  = 0x00a1, .data = "\u00A1" },
    { .key  = 0x00a2, .data = "\u00A2" },
    { .key  = 0x00a3, .data = "\u00A3" },
    { .key  = 0x00a4, .data = "\u00A4" },
    { .key  = 0x00a5, .data = "\u00A5" },
    { .key  = 0x00a6, .data = "\u00A6" },
    { .key  = 0x00a7, .data = "\u00A7" },
    { .key  = 0x00a8, .data = "\u00A8" },
    { .key  = 0x00a9, .data = "\u00A9" },
    { .key  = 0x00aa, .data = "\u00AA" },
    { .key  = 0x00ab, .data = "\u00AB" },
    { .key  = 0x00ac, .data = "\u00AC" },
    { .key  = 0x00ad, .data = "-" },
    { .key  = 0x00ae, .data = "\u00AE" },
    { .key  = 0x00af, .data = "\u00AF" },
    { .key  = 0x00b0, .data = "\u00B0" },
    { .key  = 0x00b1, .data = "\u00B1" },
    { .key  = 0x00b2, .data = "\u00B2" },
    { .key  = 0x00b3, .data = "\u00B3" },
    { .key  = 0x00b4, .data = "\u00B4" },
    { .key  = 0x00b5, .data = "\u00B5" },
    { .key  = 0x00b6, .data = "\u00B6" },
    { .key  = 0x00b7, .data = "\u00B7" },
    { .key  = 0x00b8, .data = "\u00B8" },
    { .key  = 0x00b9, .data = "\u00B9" },
    { .key  = 0x00ba, .data = "\u00BA" },
    { .key  = 0x00bb, .data = "\u00BB" },
    { .key  = 0x00bc, .data = "\u00BC" },
    { .key  = 0x00bd, .data = "\u00BD" },
    { .key  = 0x00be, .data = "\u00BE" },
    { .key  = 0x00bf, .data = "\u00BF" },
    { .key  = 0x00c0, .data = "\u00C0" },
    { .key  = 0x00c1, .data = "\u00C1" },
    { .key  = 0x00c2, .data = "\u00C2" },
    { .key  = 0x00c3, .data = "\u00C3" },
    { .key  = 0x00c4, .data = "\u00C4" },
    { .key  = 0x00c5, .data = "\u00C5" },
    { .key  = 0x00c6, .data = "\u00C6" },
    { .key  = 0x00c7, .data = "\u00C7" },
    { .key  = 0x00c8, .data = "\u00C8" },
    { .key  = 0x00c9, .data = "\u00C9" },
    { .key  = 0x00ca, .data = "\u00CA" },
    { .key  = 0x00cb, .data = "\u00CB" },
    { .key  = 0x00cc, .data = "\u00CC" },
    { .key  = 0x00cd, .data = "\u00CD" },
    { .key  = 0x00ce, .data = "\u00CE" },
    { .key  = 0x00cf, .data = "\u00CF" },
    { .key  = 0x00d0, .data = "\u00D0" },
    { .key  = 0x00d1, .data = "\u00D1" },
    { .key  = 0x00d2, .data = "\u00D2" },
    { .key  = 0x00d3, .data = "\u00D3" },
    { .key  = 0x00d4, .data = "\u00D4" },
    { .key  = 0x00d5, .data = "\u00D5" },
    { .key  = 0x00d6, .data = "\u00D6" },
    { .key  = 0x00d7, .data = "\u00D7" },
    { .key  = 0x00d8, .data = "\u00D8" },
    { .key  = 0x00d9, .data = "\u00D9" },
    { .key  = 0x00da, .data = "\u00DA" },
    { .key  = 0x00db, .data = "\u00DB" },
    { .key  = 0x00dc, .data = "\u00DC" },
    { .key  = 0x00dd, .data = "\u00DD" },
    { .key  = 0x00de, .data = "\u00DE" },
    { .key  = 0x00df, .data = "\u00DF" },
    { .key  = 0x00e0, .data = "\u00E0" },
    { .key  = 0x00e1, .data = "\u00E1" },
    { .key  = 0x00e2, .data = "\u00E2" },
    { .key  = 0x00e3, .data = "\u00E3" },
    { .key  = 0x00e4, .data = "\u00E4" },
    { .key  = 0x00e5, .data = "\u00E5" },
    { .key  = 0x00e6, .data = "\u00E6" },
    { .key  = 0x00e7, .data = "\u00E7" },
    { .key  = 0x00e8, .data = "\u00E8" },
    { .key  = 0x00e9, .data = "\u00E9" },
    { .key  = 0x00ea, .data = "\u00EA" },
    { .key  = 0x00eb, .data = "\u00EB" },
    { .key  = 0x00ec, .data = "\u00EC" },
    { .key  = 0x00ed, .data = "\u00ED" },
    { .key  = 0x00ee, .data = "\u00EE" },
    { .key  = 0x00ef, .data = "\u00EF" },
    { .key  = 0x00f0, .data = "\u00F0" },
    { .key  = 0x00f1, .data = "\u00F1" },
    { .key  = 0x00f2, .data = "\u00F2" },
    { .key  = 0x00f3, .data = "\u00F3" },
    { .key  = 0x00f4, .data = "\u00F4" },
    { .key  = 0x00f5, .data = "\u00F5" },
    { .key  = 0x00f6, .data = "\u00F6" },
    { .key  = 0x00f7, .data = "\u00F7" },
    { .key  = 0x00f8, .data = "\u00F8" },
    { .key  = 0x00f9, .data = "\u00F9" },
    { .key  = 0x00fa, .data = "\u00FA" },
    { .key  = 0x00fb, .data = "\u00FB" },
    { .key  = 0x00fc, .data = "\u00FC" },
    { .key  = 0x00fd, .data = "\u00FD" },
    { .key  = 0x00fe, .data = "\u00FE" },
    { .key  = 0x00ff, .data = "\u00FF" },
};

static table_t builtin_iso8859_1_table = {
    .length              = 96,
    .used                = 96,
    .max_data_length     = 6,
    .max_key             = 0x00ff,
    .hits                = 0,
    .misses              = 0,
    .seeks               = 0,
    .overwrites          = 0,
    .use_hash            = 0,
    .builtin             = 1,
    .rows                = builtin_iso8859_1_rows,
    .default_translation = "_",
};

table_t *load_builtin_iso8859_1_table(void)
{
    return table_resize(&builtin_iso8859_1_table, 256, 1);
}

/**
 * Generated from unicode.tbl
 */

static table_row_t builtin_unicode_rows[163] = {
    { .key  = 0x0001, .data = "_" },
    { .key  = 0x0002, .data = "_" },
    { .key  = 0x0003, .data = "_" },
    { .key  = 0x0004, .data = "_" },
    { .key  = 0x0005, .data = "_" },
    { .key  = 0x0006, .data = "_" },
    { .key  = 0x0007, .data = "_" },
    { .key  = 0x0008, .data = "_" },
    { .key  = 0x0009, .data = "_" },
    { .key  = 0x000a, .data = "_" },
    { .key  = 0x000b, .data = "_" },
    { .key  = 0x000c, .data = "_" },
    { .key  = 0x000d, .data = "_" },
    { .key  = 0x000e, .data = "_" },
    { .key  = 0x000f, .data = "_" },
    { .key  = 0x0010, .data = "_" },
    { .key  = 0x0011, .data = "_" },
    { .key  = 0x0012, .data = "_" },
    { .key  = 0x0013, .data = "_" },
    { .key  = 0x0014, .data = "_" },
    { .key  = 0x0015, .data = "_" },
    { .key  = 0x0016, .data = "_" },
    { .key  = 0x0017, .data = "_" },
    { .key  = 0x0018, .data = "_" },
    { .key  = 0x0019, .data = "_" },
    { .key  = 0x001a, .data = "_" },
    { .key  = 0x001b, .data = "_" },
    { .key  = 0x001c, .data = "_" },
    { .key  = 0x001d, .data = "_" },
    { .key  = 0x001e, .data = "_" },
    { .key  = 0x001f, .data = "_" },
    { .key  = 0x0020, .data = " " },
    { .key  = 0x0021, .data = "!" },
    { .key  = 0x0022, .data = "\"" },
    { .key  = 0x0023, .data = "#" },
    { .key  = 0x0024, .data = "$" },
    { .key  = 0x0025, .data = "%" },
    { .key  = 0x0026, .data = "&" },
    { .key  = 0x0027, .data = "'" },
    { .key  = 0x0028, .data = "(" },
    { .key  = 0x0029, .data = ")" },
    { .key  = 0x002a, .data = "*" },
    { .key  = 0x002b, .data = "+" },
    { .key  = 0x002c, .data = "," },
    { .key  = 0x002d, .data = "-" },
    { .key  = 0x002e, .data = "." },
    { .key  = 0x002f, .data = "/" },
    { .key  = 0x0030, .data = "0" },
    { .key  = 0x0031, .data = "1" },
    { .key  = 0x0032, .data = "2" },
    { .key  = 0x0033, .data = "3" },
    { .key  = 0x0034, .data = "4" },
    { .key  = 0x0035, .data = "5" },
    { .key  = 0x0036, .data = "6" },
    { .key  = 0x0037, .data = "7" },
    { .key  = 0x0038, .data = "8" },
    { .key  = 0x0039, .data = "9" },
    { .key  = 0x003a, .data = ":" },
    { .key  = 0x003b, .data = ";" },
    { .key  = 0x003c, .data = "<" },
    { .key  = 0x003d, .data = "=" },
    { .key  = 0x003e, .data = ">" },
    { .key  = 0x003f, .data = "?" },
    { .key  = 0x0040, .data = "@" },
    { .key  = 0x0041, .data = "A" },
    { .key  = 0x0042, .data = "B" },
    { .key  = 0x0043, .data = "C" },
    { .key  = 0x0044, .data = "D" },
    { .key  = 0x0045, .data = "E" },
    { .key  = 0x0046, .data = "F" },
    { .key  = 0x0047, .data = "G" },
    { .key  = 0x0048, .data = "H" },
    { .key  = 0x0049, .data = "I" },
    { .key  = 0x004a, .data = "J" },
    { .key  = 0x004b, .data = "K" },
    { .key  = 0x004c, .data = "L" },
    { .key  = 0x004d, .data = "M" },
    { .key  = 0x004e, .data = "N" },
    { .key  = 0x004f, .data = "O" },
    { .key  = 0x0050, .data = "P" },
    { .key  = 0x0051, .data = "Q" },
    { .key  = 0x0052, .data = "R" },
    { .key  = 0x0053, .data = "S" },
    { .key  = 0x0054, .data = "T" },
    { .key  = 0x0055, .data = "U" },
    { .key  = 0x0056, .data = "V" },
    { .key  = 0x0057, .data = "W" },
    { .key  = 0x0058, .data = "X" },
    { .key  = 0x0059, .data = "Y" },
    { .key  = 0x005a, .data = "Z" },
    { .key  = 0x005b, .data = "[" },
    { .key  = 0x005c, .data = "\\" },
    { .key  = 0x005d, .data = "]" },
    { .key  = 0x005e, .data = "^" },
    { .key  = 0x005f, .data = "_" },
    { .key  = 0x0060, .data = "`" },
    { .key  = 0x0061, .data = "a" },
    { .key  = 0x0062, .data = "b" },
    { .key  = 0x0063, .data = "c" },
    { .key  = 0x0064, .data = "d" },
    { .key  = 0x0065, .data = "e" },
    { .key  = 0x0066, .data = "f" },
    { .key  = 0x0067, .data = "g" },
    { .key  = 0x0068, .data = "h" },
    { .key  = 0x0069, .data = "i" },
    { .key  = 0x006a, .data = "j" },
    { .key  = 0x006b, .data = "k" },
    { .key  = 0x006c, .data = "l" },
    { .key  = 0x006d, .data = "m" },
    { .key  = 0x006e, .data = "n" },
    { .key  = 0x006f, .data = "o" },
    { .key  = 0x0070, .data = "p" },
    { .key  = 0x0071, .data = "q" },
    { .key  = 0x0072, .data = "r" },
    { .key  = 0x0073, .data = "s" },
    { .key  = 0x0074, .data = "t" },
    { .key  = 0x0075, .data = "u" },
    { .key  = 0x0076, .data = "v" },
    { .key  = 0x0077, .data = "w" },
    { .key  = 0x0078, .data = "x" },
    { .key  = 0x0079, .data = "y" },
    { .key  = 0x007a, .data = "z" },
    { .key  = 0x007b, .data = "{" },
    { .key  = 0x007c, .data = "|" },
    { .key  = 0x007d, .data = "}" },
    { .key  = 0x007e, .data = "~" },
    { .key  = 0x007f, .data = "_" },
    { .key  = 0x00a0, .data = " " },
    { .key  = 0x00ad, .data = "-" },
    { .key  = 0x2000, .data = " " },
    { .key  = 0x2001, .data = " " },
    { .key  = 0x2002, .data = " " },
    { .key  = 0x2003, .data = " " },
    { .key  = 0x2004, .data = " " },
    { .key  = 0x2005, .data = " " },
    { .key  = 0x2006, .data = " " },
    { .key  = 0x2007, .data = " " },
    { .key  = 0x2008, .data = " " },
    { .key  = 0x2009, .data = " " },
    { .key  = 0x200a, .data = " " },
    { .key  = 0x200b, .data = "" },
    { .key  = 0x200c, .data = "" },
    { .key  = 0x200d, .data = "" },
    { .key  = 0x200e, .data = "" },
    { .key  = 0x200f, .data = "" },
    { .key  = 0x2010, .data = "-" },
    { .key  = 0x2011, .data = "-" },
    { .key  = 0x2012, .data = "-" },
    { .key  = 0x2013, .data = "-" },
    { .key  = 0x2014, .data = "-" },
    { .key  = 0x2015, .data = "-" },
    { .key  = 0x2017, .data = "_" },
    { .key  = 0x2028, .data = " " },
    { .key  = 0x2029, .data = " " },
    { .key  = 0x202a, .data = " " },
    { .key  = 0x202b, .data = " " },
    { .key  = 0x202c, .data = " " },
    { .key  = 0x202d, .data = " " },
    { .key  = 0x202e, .data = " " },
    { .key  = 0x202f, .data = " " },
    { .key  = 0x2044, .data = "_" },
    { .key  = 0x205f, .data = " " },
    { .key  = 0x2060, .data = "" },
};

static table_t builtin_unicode_table = {
    .length              = 163,
    .used                = 163,
    .max_data_length     = 1,
    .max_key             = 0x2060,
    .hits                = 0,
    .misses              = 0,
    .seeks               = 0,
    .overwrites          = 0,
    .use_hash            = 0,
    .builtin             = 1,
    .rows                = builtin_unicode_rows,
    .default_translation = NULL,
};

table_t *load_builtin_unicode_table(void)
{
    return table_resize(&builtin_unicode_table, 256, 1);
}

/**
 * Generated from cp1252.tbl
 */

static table_row_t builtin_cp1252_rows[32] = {
    { .key  = 0x0080, .data = "\u20AC" },
    { .key  = 0x0081, .data = "-" },
    { .key  = 0x0082, .data = "\u201A" },
    { .key  = 0x0083, .data = "\u0192" },
    { .key  = 0x0084, .data = "\u201E" },
    { .key  = 0x0085, .data = "\u2026" },
    { .key  = 0x0086, .data = "\u2020" },
    { .key  = 0x0087, .data = "\u2021" },
    { .key  = 0x0088, .data = "\u02C6" },
    { .key  = 0x0089, .data = "\u2030" },
    { .key  = 0x008a, .data = "\u0160" },
    { .key  = 0x008b, .data = "\u2039" },
    { .key  = 0x008c, .data = "\u0152" },
    { .key  = 0x008d, .data = "-" },
    { .key  = 0x008e, .data = "\u017D" },
    { .key  = 0x008f, .data = "-" },
    { .key  = 0x0090, .data = "-" },
    { .key  = 0x0091, .data = "\u2018" },
    { .key  = 0x0092, .data = "\u2019" },
    { .key  = 0x0093, .data = "\u201C" },
    { .key  = 0x0094, .data = "\u201D" },
    { .key  = 0x0095, .data = "\u2022" },
    { .key  = 0x0096, .data = "\u2013" },
    { .key  = 0x0097, .data = "\u2014" },
    { .key  = 0x0098, .data = "\u02DC" },
    { .key  = 0x0099, .data = "\u2122" },
    { .key  = 0x009a, .data = "\u0161" },
    { .key  = 0x009b, .data = "\u203A" },
    { .key  = 0x009c, .data = "\u0153" },
    { .key  = 0x009d, .data = "-" },
    { .key  = 0x009e, .data = "\u017E" },
    { .key  = 0x009f, .data = "\u0178" },
};

static table_t builtin_cp1252_table = {
    .length              = 32,
    .used                = 32,
    .max_data_length     = 6,
    .max_key             = 0x009f,
    .hits                = 0,
    .misses              = 0,
    .seeks               = 0,
    .overwrites          = 0,
    .use_hash            = 0,
    .builtin             = 1,
    .rows                = builtin_cp1252_rows,
    .default_translation = NULL,
};

table_t *load_builtin_cp1252_table(void)
{
    return table_resize(&builtin_cp1252_table, 256, 1);
}
