require "spec_helper"
require 'spec_mock_server'
require 'rack/test'
require 'debci/home'

describe Debci::Home do
  include WebAppHelper

  class Home < Debci::Home
    set :raise_errors, true
    set :show_exceptions, false
  end

  def app
    mock_server('/', Home)
  end

  it 'renders the home page with no data' do
    fake_login("someone")
    get '/'
    expect(last_response.status).to eq(200)
    expect(last_response.body).to match("(no data yet)")
  end

  it 'renders the home page with packages' do
    Debci::Package.create!(name: "foobar")
    fake_login("someone")
    get '/'
    expect(last_response.status).to eq(200)
    expect(last_response.body).to match('"/packages/f"')
  end

  it 'does not allow browsing packages without a login' do
    Debci::Package.create!(name: "foobar")
    get '/'
    expect(last_response.status).to eq(200)
    expect(last_response.body).to_not match('"/packages/f"')
  end

  it 'does not provide a session cookie without a login' do
    get '/'
    expect(last_response.headers).to_not have_key('set-cookie')
  end
end
