# Dmisc.perl                                 
#
# 1998/01/06 S.Takehiro  
# 2001/06/19 ODAKA Masatsugu
#
#  Global variables
#      $label_rx
#      $labels_rx
#
#  Substituting do_labels, extract_labels
#

package main;

    #   only some non-alphanumerics are allowed in labels by default
    $label_rx = "";

    $labels_rx = "$EOL\\\\(label|Deqlab|Dfiglab|Dtablab|Dseclab|Dchaplab|Dentry)\\s*$O(\\d+)$C([\\s\\S]*)$O\\2$C$EOL";

sub do_labels {
    local($context,$new_context) = @_;
    local($label);
    local($lab);
    $* = 1;                     # Multiline matching ON
    $context =~ s/\s*$labels_rx/do {
	    if ( $1 eq "Deqlab" ) { $lab = join('',"eq:",$3); }
	elsif ( $1 eq "Dfiglab" ) { $lab = join('',"fig:",$3); }
	elsif ( $1 eq "Dtablab" ) { $lab = join('',"tab:",$3); }
	elsif ( $1 eq "Dseclab" ) { $lab = join('',"sec:",$3); }
	elsif ( $1 eq "Dchaplab" ) { $lab = join('',"chap:",$3); }
	else { $lab = $3; }
	if ( $1 eq "Dentry" ) { do_cmd_index($lab); }
        $label = &do_labels_helper($lab);
        $new_context = &anchor_label($label,$CURRENT_FILE,$new_context);""}/geo;
    $* = 0;                     # Multiline matching OFF
    $new_context;
}

sub extract_labels {
    local($_) = @_;
    local($label,$anchors);
    local($lab);
    $* = 1;                     # Multiline matching ON
    while (s/\s*$labels_rx//o) {
	if ( $1 eq "Deqlab" ) { $lab = join('',"eq:",$3); }
	elsif ( $1 eq "Dfiglab" ) { $lab = join('',"fig:",$3); }
	elsif ( $1 eq "Dtablab" ) { $lab = join('',"tab:",$3); }
	elsif ( $1 eq "Dseclab" ) { $lab = join('',"sec:",$3); }
	elsif ( $1 eq "Dchaplab" ) { $lab = join('',"chap:",$3); }
	else { $lab = $3; }
        $label = &do_labels_helper($lab);
        $anchors .= &anchor_label($label,$CURRENT_FILE,'');
    };
    $* = 0;                     # Multiline matching OFF
    ($_, $anchors);
}

sub do_cmd_Dseclab {
    local($_) = @_;
    local($label,$pair);
    $label = &missing_braces
        unless ((s/$next_pair_pr_rx/$label = $2;''/eo)
            || (s/$next_pair_rx/$label = $2;''/eo));
    $pair=join('',"<#",$1,"#>");
    $label = join('',$pair,"sec:",$label,$pair);
    do_cmd_label(join('',$label,$_));
}

sub do_cmd_Dentry {
    local($_) = @_;
    local($label,$pair);
    $label = &missing_braces
        unless ((s/$next_pair_pr_rx/$label = $2;''/eo)
            || (s/$next_pair_rx/$label = $2;''/eo));
    $pair=join('',"<#",$1,"#>");
    $label = join('',$pair,$label,$pair);
    do_cmd_index($label);
    do_cmd_label(join('',$label,$_));
}

sub do_cmd_Deqref {
    local($_) = @_;
    local($label,$pair);
    $label = &missing_braces
        unless ((s/$next_pair_pr_rx/$label = $2;''/eo)
            || (s/$next_pair_rx/$label = $2;''/eo));
    $pair=join('',"<#",$1,"#>");
    $label = join('',$pair,"eq:",$label,$pair);
    join('',"(",&do_cmd_ref($label),")",$_);
}

sub do_cmd_Dfigref {
    local($_) = @_;
    local($label,$pair);
    $label = &missing_braces
        unless ((s/$next_pair_pr_rx/$label = $2;''/eo)
            || (s/$next_pair_rx/$label = $2;''/eo));
    $pair=join('',"<#",$1,"#>");
    $label = join('',$pair,"fig:",$label,$pair);
    if ( $DonJ == 1 ){ 
      join('',"",&do_cmd_ref($label),$_); }
    else { 
      join('',"Fig.",&do_cmd_ref($label),$_);}
}

sub do_cmd_DFigref {
    local($_) = @_;
    local($label,$pair);
    $label = &missing_braces
        unless ((s/$next_pair_pr_rx/$label = $2;''/eo)
            || (s/$next_pair_rx/$label = $2;''/eo));
    $pair=join('',"<#",$1,"#>");
    $label = join('',$pair,"fig:",$label,$pair);
    if ( $DonJ == 1 ){ 
      join('',"",&do_cmd_ref($label),$_); }
    else { 
      join('',"Figure ",&do_cmd_ref($label),$_);}
}

sub do_cmd_Dtabref {
    local($_) = @_;
    local($label,$pair);
    $label = &missing_braces
        unless ((s/$next_pair_pr_rx/$label = $2;''/eo)
            || (s/$next_pair_rx/$label = $2;''/eo));
    $pair=join('',"<#",$1,"#>");
    $label = join('',$pair,"tab:",$label,$pair);
    if ( $DonJ == 1 ){ 
      join('',"ɽ",&do_cmd_ref($label),$_); }
    else { 
      join('',"Table ",&do_cmd_ref($label),$_);}
}

sub do_cmd_Dsecref {
    local($_) = @_;
    local($label,$pair);
    $label = &missing_braces
        unless ((s/$next_pair_pr_rx/$label = $2;''/eo)
            || (s/$next_pair_rx/$label = $2;''/eo));
    $pair=join('',"<#",$1,"#>");
    $label = join('',$pair,"sec:",$label,$pair);
    join('',"",&do_cmd_ref($label),"",$_);
}

sub do_cmd_Dchapref {
    local($_) = @_;
    local($label,$pair);
    $label = &missing_braces
        unless ((s/$next_pair_pr_rx/$label = $2;''/eo)
            || (s/$next_pair_rx/$label = $2;''/eo));
    $pair=join('',"<#",$1,"#>");
    $label = join('',$pair,"chap:",$label,$pair);
    join('',"",&do_cmd_ref($label),"",$_);
}

sub do_env_Dreference {
    local($_) = @_;
    if ( $DonJ ==1 ) { join('',"<H1>ʸ</H1>\n",do_env_description($_)); }
    else { join('',"<H1>References</H1>\n",do_env_description($_)); }
}

sub do_env_Dnitemize {
    do_env_itemize(@_);
}

sub do_env_Dlist {
    do_env_description(@_);
}

sub do_cmd_Dtoday {
    local(@lt) = localtime;
    local($d,$m,$y) = @lt[3,4,5];
    local($today) = sprintf("%d/%d/%d", $y, $m+1, $d);
    join('',$today,$_[0]);
}

sub do_cmd_Dsidenote {
    do_cmd_footnote(@_);
}


&process_commands_in_tex (<<_RAW_ARG_CMDS_);
_RAW_ARG_CMDS_

&process_commands_inline_in_tex (<<_RAW_ARG_INLINE_CMDS_);
_RAW_ARG_INLINE_CMDS_

&process_commands_nowrap_in_tex (<<_RAW_ARG_NOWRAP_CMDS_);
_RAW_ARG_NOWRAP_CMDS_

&process_commands_wrap_deferred (<<_RAW_ARG_WRAP_CMDS_);
_RAW_ARG_WRAP_CMDS_


&ignore_commands( <<_IGNORED_CMDS_);
Dparskip
Dnoparskip
Dparindent
Dnoparindent
_IGNORED_CMDS_

1;	# Must be last line
