.TH DGGSVP l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
DGGSVP - compute orthogonal matrices U, V and Q such that  N-K-L K L U'*A*Q = K ( 0 A12 A13 ) if M-K-L >= 0
.SH SYNOPSIS
.TP 19
SUBROUTINE DGGSVP(
JOBU, JOBV, JOBQ, M, P, N, A, LDA, B, LDB,
TOLA, TOLB, K, L, U, LDU, V, LDV, Q, LDQ,
IWORK, TAU, WORK, INFO )
.TP 19
.ti +4
CHARACTER
JOBQ, JOBU, JOBV
.TP 19
.ti +4
INTEGER
INFO, K, L, LDA, LDB, LDQ, LDU, LDV, M, N, P
.TP 19
.ti +4
DOUBLE
PRECISION TOLA, TOLB
.TP 19
.ti +4
INTEGER
IWORK( * )
.TP 19
.ti +4
DOUBLE
PRECISION A( LDA, * ), B( LDB, * ), Q( LDQ, * ),
TAU( * ), U( LDU, * ), V( LDV, * ), WORK( * )
.SH PURPOSE
DGGSVP computes orthogonal matrices U, V and Q such that N-K-L K L U'*A*Q = K ( 0 A12 A13 ) if M-K-L >= 0;               L ( 0     0   A23 )
.br
          M-K-L ( 0     0    0  )
.br

                 N-K-L  K    L
.br
        =     K ( 0    A12  A13 )  if M-K-L < 0;
.br
            M-K ( 0     0   A23 )
.br

               N-K-L  K    L
.br
 V'*B*Q =   L ( 0     0   B13 )
.br
          P-L ( 0     0    0  )
.br

where the K-by-K matrix A12 and L-by-L matrix B13 are nonsingular
upper triangular; A23 is L-by-L upper triangular if M-K-L >= 0,
otherwise A23 is (M-K)-by-L upper trapezoidal.  K+L = the effective
numerical rank of the (M+P)-by-N matrix (A',B')'.  Z' denotes the
transpose of Z.
.br

This decomposition is the preprocessing step for computing the
Generalized Singular Value Decomposition (GSVD), see subroutine
DGGSVD.
.br

.SH ARGUMENTS
.TP 8
JOBU    (input) CHARACTER*1
= 'U':  Orthogonal matrix U is computed;
.br
= 'N':  U is not computed.
.TP 8
JOBV    (input) CHARACTER*1
.br
= 'V':  Orthogonal matrix V is computed;
.br
= 'N':  V is not computed.
.TP 8
JOBQ    (input) CHARACTER*1
.br
= 'Q':  Orthogonal matrix Q is computed;
.br
= 'N':  Q is not computed.
.TP 8
M       (input) INTEGER
The number of rows of the matrix A.  M >= 0.
.TP 8
P       (input) INTEGER
The number of rows of the matrix B.  P >= 0.
.TP 8
N       (input) INTEGER
The number of columns of the matrices A and B.  N >= 0.
.TP 8
A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
On entry, the M-by-N matrix A.
On exit, A contains the triangular (or trapezoidal) matrix
described in the Purpose section.
.TP 8
LDA     (input) INTEGER
The leading dimension of the array A. LDA >= max(1,M).
.TP 8
B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
On entry, the P-by-N matrix B.
On exit, B contains the triangular matrix described in
the Purpose section.
.TP 8
LDB     (input) INTEGER
The leading dimension of the array B. LDB >= max(1,P).
.TP 8
TOLA    (input) DOUBLE PRECISION
TOLB    (input) DOUBLE PRECISION
TOLA and TOLB are the thresholds to determine the effective
numerical rank of matrix B and a subblock of A. Generally,
they are set to
TOLA = MAX(M,N)*norm(A)*MAZHEPS,
TOLB = MAX(P,N)*norm(B)*MAZHEPS.
The size of TOLA and TOLB may affect the size of backward
errors of the decomposition.
.TP 8
K       (output) INTEGER
L       (output) INTEGER
On exit, K and L specify the dimension of the subblocks
described in Purpose.
K + L = effective numerical rank of (A',B')'.
.TP 8
U       (output) DOUBLE PRECISION array, dimension (LDU,M)
If JOBU = 'U', U contains the orthogonal matrix U.
If JOBU = 'N', U is not referenced.
.TP 8
LDU     (input) INTEGER
The leading dimension of the array U. LDU >= max(1,M) if
JOBU = 'U'; LDU >= 1 otherwise.
.TP 8
V       (output) DOUBLE PRECISION array, dimension (LDV,M)
If JOBV = 'V', V contains the orthogonal matrix V.
If JOBV = 'N', V is not referenced.
.TP 8
LDV     (input) INTEGER
The leading dimension of the array V. LDV >= max(1,P) if
JOBV = 'V'; LDV >= 1 otherwise.
.TP 8
Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
If JOBQ = 'Q', Q contains the orthogonal matrix Q.
If JOBQ = 'N', Q is not referenced.
.TP 8
LDQ     (input) INTEGER
The leading dimension of the array Q. LDQ >= max(1,N) if
JOBQ = 'Q'; LDQ >= 1 otherwise.
.TP 8
IWORK   (workspace) INTEGER array, dimension (N)
.TP 8
TAU     (workspace) DOUBLE PRECISION array, dimension (N)
.TP 8
WORK    (workspace) DOUBLE PRECISION array, dimension (max(3*N,M,P))
.TP 8
INFO    (output) INTEGER
= 0:  successful exit
.br
< 0:  if INFO = -i, the i-th argument had an illegal value.
.SH FURTHER DETAILS
The subroutine uses LAPACK subroutine DGEQPF for the QR factorization
with column pivoting to detect the effective numerical rank of the
a matrix. It may be replaced by a better rank determination strategy.

