--- src/dggesx.f	Thu Dec  5 19:51:35 2002
+++ debian/updates/src/dggesx.f	Wed Dec  4 15:23:42 2002
@@ -7,6 +7,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Do WS calculations if LWORK = -1 (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVSL, JOBVSR, SENSE, SORT
@@ -185,6 +186,10 @@
 *          If SENSE = 'E', 'V', or 'B',
 *          LWORK >= MAX( 8*(N+1)+16, 2*SDIM*(N-SDIM) ).
 *
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
+*
 *  IWORK   (workspace) INTEGER array, dimension (LIWORK)
 *          Not referenced if SENSE = 'N'.
 *
@@ -227,6 +232,8 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       DOUBLE PRECISION   ZERO, ONE
       PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
 *     ..
@@ -330,7 +337,7 @@
 *       following subroutine, as returned by ILAENV.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. LWORK.GE.1 ) THEN
+      IF( INFO.EQ.0 ) THEN
          MINWRK = 8*( N+1 ) + 16
          MAXWRK = 7*( N+1 ) + N*ILAENV( 1, 'DGEQRF', ' ', N, 1, N, 0 ) +
      $            16
@@ -338,7 +345,15 @@
             MAXWRK = MAX( MAXWRK, 8*( N+1 )+N*
      $               ILAENV( 1, 'DORGQR', ' ', N, 1, N, -1 )+16 )
          END IF
+*
+*        Estimate the workspace needed by DTGSEN.
+*
+         IF( WANTST ) THEN
+            MAXWRK = MAX( MAXWRK, 2*N+( N*N+1 ) / 2 )
+         END IF
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -22
       END IF
       IF( .NOT.WANTSN ) THEN
          LIWMIN = 1
@@ -346,21 +361,19 @@
          LIWMIN = N + 6
       END IF
       IWORK( 1 ) = LIWMIN
-*
-      IF( INFO.EQ.0 .AND. LWORK.LT.MINWRK ) THEN
-         INFO = -22
-      ELSE IF( INFO.EQ.0 .AND. IJOB.GE.1 ) THEN
+      IF( INFO.EQ.0 .AND. IJOB.GE.1 ) THEN
          IF( LIWORK.LT.LIWMIN )
      $      INFO = -24
       END IF
 *
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'DGGESX', -INFO )
          RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV )
+     $   RETURN
       IF( N.EQ.0 ) THEN
          SDIM = 0
          RETURN
