#!/bin/sh

set -e

case `echo "testing\c"; echo 1,2,3`,`echo -n testing; echo 1,2,3` in
  *c*,-n*) ECHO_N= ECHO_C='
' ECHO_T='      ' ;;
  *c*,*  ) ECHO_N=-n ECHO_C= ECHO_T= ;;
  *)       ECHO_N= ECHO_C='\c' ECHO_T= ;;
esac

${MAKE:-make} histauto
NCDUMP=${NCDUMP:-ncdump}
MKDIR=${MKDIR:-mkdir}
XDIR=xhistauto

if ! $NCDUMP ncdump_check.nc > /dev/null 2>&1  ;then
    echo ""
    echo "   Error: $NCDUMP: command not found."
    echo ""
    exit 1
fi

test -d $XDIR || $MKDIR $XDIR

files="test01-u.nc test01-v.nc test02-u.nc test02-v.nc test03-u.nc test04-u.nc test04-v.nc test04-ww.nc"
for f in $files ; do
    origfiles="$origfiles `echo $f | sed 's/\.nc/.orig.nc/'`"
done

if [ ! "$CROSS_COMPILING" = "yes" ] && [ ! "$CROSS_COMPILING" = "maybe" ] ; then
    for f in $files ; do
	test ! -f $XDIR/$f || rm -f $XDIR/$f
    done

    ./histauto 2> xdifs.log
else
    if [ ! -f $XDIR/test01-u.nc ] ; then
	echo ""
	echo "   WARNING: Cross compile mode will be used."
	echo "            After submitting ./histauto, execute $0 again."
	echo ""
        exit 1
    fi
fi

##### some definitions #####

history_to_unknown='s/:history = ".*>/:history = "unknown unknown>/'
#date_to_unknown='s/[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]T[0-9][0-9]:[0-9][0-9]:[0-9][0-9][+-][0-9][0-9]:[0-9][0-9]/unknown/'
delete_orig='s/\.orig//' 


##### change directory #####

cd $XDIR

##### make CDL file from Original data by ncdump #####
for f in $origfiles
do
   $NCDUMP $f | sed -e "$history_to_unknown" -e $delete_orig > ${f}.cdl
done

##### Make CDL file from generated data by ncdump #####

for f in $files
do
    $NCDUMP $f | sed "$history_to_unknown" > ${f}.cdl
done

##### test ######

for f in $files
do
   echo $ECHO_N "testing ${f} ..." $ECHO_C
   of=`echo $f | sed 's/\.nc$/.orig.nc/'`
   diff ${f}.cdl ${of}.cdl
   echo "okay"
done

f=test04-u3.nc
echo $ECHO_N "testing ${f} ..." $ECHO_C
if [ -f "${f}" ]; then
    echo
    echo "  Error: ${f} must be not found."
else
    echo "okay"
fi

rm -f ../xdifs.log *.cdl $files

exit 0
