=begin TOPLINK
#[((<English|URL:gthist_first.htm.en>)) |
#((<Japanese|URL:gthist_first.htm>))]
[((<Gt4f90io Reference Manual|URL:../index.htm>)) |
((<Gt4f90io Tutorial|URL:index.htm>))]
=end TOPLINK

=begin JA

= ǡϤΤκ¤

# *   (morikawa),  (odakker),   (momoko)
#   * $Id: gthist_first.rd,v 1.2 2006/06/03 17:50:49 morikawa Exp $

=end JA

=begin JA

gt4_history ⥸塼, ͥǥη̤ gtool4 ǽϤ뤿
Υ󥿡եǤ. ˻ʬηֳִ̤֤ǽϤ뤳
ǰƬˤƤޤ. Υ⥸塼Ѥ, Fortran90 ǽ񤫤줿ץ
 ׻̤ gtool4 ǡǽϤ뤳Ȥñ˼¸Ǥ
.

ʲǤϴñʥץ, gt4_history ⥸塼λȤ
ޤ.


((<Υץ|URL:diff_orig.f90>))
 1 ǮƳ򤯤ΤǤ. Ϸ̤ write 
ʸǹԤƤǤ. Ф gt4_history ŬѤΤʲ
ΥץǤ. ֻ(顼Ǥʤϥܡ) gt4_history 
طƤսǤ.

=end JA

=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
! Sample program for gt4_history/gt4f90io
! 
! Solving diffusion equation 
!     du/dt = d^2 u/dx^2
! for giving values of u at x=0 and 1. 
!
program diffusion
  <b><font color="red">
  use gt4_history                                          ! ⥸塼
  </font></b>
  integer, parameter              :: nx=30                   ! åɿ
  integer, parameter              :: nt=200                  ! ֥ƥå׿
  integer, parameter              :: ndisp=10                ! ϴֳ
  double precision, parameter     :: dx=1.0/(nx-1)           ! åɴֳ
  double precision, parameter     :: dt=0.0005               ! ֳִ
  double precision, dimension(nx) :: x=(/(dx*(i-1),i=1,nx)/) ! ɸѿ
  double precision, dimension(nx) :: temp                    ! 
  double precision, parameter     :: kappa=1.0               ! ǮȻ

  tinit = 0.0                                                ! 

  temp = exp(-((x-0.5)/0.1)**2)                              ! 
  <b><font color="red">
  call HistoryCreate( &amp;                                      ! ҥȥ꡼
       file='diffusion.nc', title='Diffusion equation', &amp;
       source='Sample program of gt4_history/gt4f90io', &amp;
       institution='GFD_Dennou Club davis project',     &amp;
       dims=(/'x','t'/), dimsizes=(/nx,0/),             &amp;
       longnames=(/'X-coordinate','time        '/),     &amp;
       units=(/'m','s'/),                               &amp;
       origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                                     ! ѿ

  call HistoryAddVariable( &amp;                                 ! ѿ
       varname='temp', dims=(/'x','t'/), &amp; 
       longname='temperature', units='K', xtype='double')

  call HistoryPut('t',real(tinit))                           ! 
  call HistoryPut('temp',temp)                               ! ѿ

  </font></b>
  do it=1,nt
     temp(2:nx-1) = temp(2:nx-1) &amp;                           ! ʬ
          +kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

     if ( mod(nt,ndisp) .eq. 0 ) then
        <b><font color="red">
        call HistoryPut('t',real(it*dt))                     ! 
        call HistoryPut('temp',temp)                         ! ѿ
        </font></b>
     endif
  enddo

  <b><font color="red">call HistoryClose</font></b>
  stop
end program diffusion
</pre>
=end HTML

=begin JA

Υץ ((<diffusion_1.f90|URL:diffusion_1.f90>))
Ȥ̾¸, ºݤ˥ѥ뤷Ƽ¹ԤƤߤޤ礦.

gtool4 󥹥ȡ뤵Ƥˤ

    $ gt4frt diffusion_1.f90

ȤƼ¹ԥե a.out 뤳ȤǤޤ. , 

    $ a.out

ȼ¹Ԥ, diffusion_1.nc Ȥ gtool4 ǡΥե뤬
ޤ. NetCDF Υޥ ncdump ѤȤ򸫤Ƥߤޤ礦.

    $ ncdump diffusion_1.nc | more

Ȥ, ѿͤǤʤ͡ʾղäƤͻҤ򸫤뤳Ȥ
Ǥޤ.

, ((<Ǿ Ruby ץ|URL:http://www.gfd-dennou.org/library/ruby>))
ʤ ((<GAVE|URL:http://www.gfd-dennou.org/library/ruby/products/gave/>))
 ((<GPhys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys>))
ǹԤʤȤǤޤ. 

ˡʤɾܤȤϤΥڡ򻲾ȤƲ.

=end JA


=begin HTML
<hr /> <small>
  $Id: gthist_first.rd,v 1.2 2006/06/03 17:50:49 morikawa Exp $
</small>
=end HTML
