!== dcdatetimeeval.f90 - dc_date_types#DC_DATETIME ѿäؤѴ
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dcdatetimeeval.f90,v 1.2 2005/12/26 11:34:38 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20060618 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե󶡤³ dc_date ⥸塼ˤ󶡤ޤ
!

subroutine DCDateTimeEval(time, mon, day, sec) !:nodoc:
  !
  ! dc_date_types#DC_DATETIME ѿ time 
  ! ѿǤ  mon   day  ټ¿Ǥ
  !  sec Ѵ֤
  !
  ! dc_date#DateTime ε
  !
  !--
  ! Υ֥롼ˡ (1 ǯ 1 ϲä) ΤäƤޤ
  ! Ǥ⤷ȡdc_data_types ѿѤ٤⤷ޤ
  !++
  use dc_types, only: DP
  use dc_date_types, only: DC_DATETIME, &
    & caltype, cyclic_mdays, CAL_NOLEAP, CAL_JULIAN, CAL_CYCLIC
  implicit none
  type(DC_DATETIME), intent(in):: time
  integer, intent(out):: mon, day
  real(DP), intent(out):: sec
  integer:: year, month
  integer, parameter:: four_years = 365 * 4 + 1
  integer, parameter:: four_century = 365 * 400 + 97
continue
  sec = time%sec
  if (caltype == CAL_CYCLIC) then
    day = modulo(dble(time%day - 1), cyclic_mdays) + 1
    mon = (time%day - 1) / cyclic_mdays
    return
  endif
  if (caltype == CAL_NOLEAP) then
    day = modulo(time%day - 91, 365)
    year = (time%day - 91 - day) / 365
  else
    if (caltype == CAL_JULIAN .or. time%day < 640196) then
      day = modulo(time%day - 92, four_years)
      year = (time%day - 92 - day) / four_years * 4
    else
      day = modulo(time%day - 94, four_century)
      year = (time%day - 94 - day) / four_century * 400
      if (day == four_century - 1) then
        year = year + 300
        day = 36525
      else
        year = year + day / 36524 * 100
        day = modulo(day, 36524)
      endif
      year = year + day / four_years * 4
      day = modulo(day, four_years)
    endif
    if (day == four_years - 1) then
      year = year + 3
      day = 365
    else
      year = year + day / 365
      day = modulo(day, 365)
    endif
  endif
  day = day * 10 + 922
  month = day / 306
  mon = mod(month - 1, 12) + 1
  year = year + (month - mon) / 12
  day = mod(day, 306) / 10  + 1
end subroutine DCDateTimeEval
