! Sample program for gt4_history/gt4f90io          2001/02/27 S.Takehiro
!                                                  2003/08/21 M.Odaka
! 
! Solving diffusion equation 
!     du/dt = kappa d^2 u/dx^2
! for giving values of u at x=0 and 1. 
!
program diffusion

  use gt4_history                                          ! ⥸塼

  integer, parameter              :: nx=30                   ! åɿ
  integer, parameter              :: nt=200                  ! ֥ƥå׿
  integer, parameter              :: ndisp=10                ! ϴֳ
  double precision, parameter     :: dx=1.0/(nx-1)           ! åɴֳ
  double precision, parameter     :: dt=0.0005               ! ֳִ
  double precision, dimension(nx) :: x=(/(dx*(i-1),i=1,nx)/) ! ɸѿ
  double precision, dimension(nx) :: temp                    ! 
  double precision, parameter     :: kappa=1.0               ! ǮȻ

  tinit = 0.0                                                ! 

  temp = exp(-((x-0.5)/0.1)**2)                              ! 

  call HistoryCreate( &                                      ! ҥȥ꡼
       file='diffusion_1.nc', title='Diffusion equation', &
       source='Sample program of gt4_history/gt4f90io', &
       institution='GFD_Dennou Club davis project',     &
       dims=(/'x','t'/), dimsizes=(/nx,0/),             &
       longnames=(/'X-coordinate','time        '/),     &
       units=(/'m','s'/),                               &
       origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                                     ! ѿ

  call HistoryAddVariable( &                                 ! ѿ
       varname='temp', dims=(/'x','t'/), & 
       longname='temperature', units='K', xtype='double')

  call HistoryPut('t',real(tinit))                           ! 
  call HistoryPut('temp',temp)                               ! ѿ

  do it=1,nt
     temp(2:nx-1) = temp(2:nx-1) &                           ! ʬ
          +kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt
       
     if ( mod(nt,ndisp) .eq. 0 ) then
        call HistoryPut('t',real(it*dt))                     ! 
        call HistoryPut('temp',temp)                         ! ѿ
     endif
  enddo

  call HistoryClose
  stop
end program diffusion
