=begin JA

= CPU ֤η¬

# *  (odakker2),  (morikawa)
#   * $Id: dc_clock.rd,v 1.7 2008-02-11 17:18:32 morikawa Exp $

=end JA

=begin EN

= CPU time counting

# *  (odakker2),  (morikawa)
#   * $Id: dc_clock.rd,v 1.7 2008-02-11 17:18:32 morikawa Exp $

=end EN


=begin JA

#ץνפ CPU ֤¬ˤ, UNIX time ޥɤ
#Ѥ, ѤΥץեѤˡޤ. , time 
#ޥɤϥץ¹Ԥץηв֤¬뤿, ץ
#θ̤νפ CPU ֤¬뤳ȤϤǤޤ. 
#ץեϥץѤƤ륵֥롼ñ̤Ǥ CPU 
#ַ¬ǽǤ, ŬץѤ¾Ūʾ, ѥ
#ˤäƤϤ⤽ץե餬ѰդƤʤ礬ޤ.

gt4f90io ˤ CPU ֤¬륵֥롼󶡤⥸塼 
((<dc_clock|URL:../code_reference/classes/dc_clock.html>)) Ѱդ
Ƥޤ. ѤȥץǤդνפ CPU ֤
¬뤳ȤǽȤʤޤ.

Ȥ, 
((<"Fortran 90/95 ѥ⥸塼: (1) ̷ѥ᥿"|URL:dc_types.htm>)) 
Ѥ((<ץץ|URL:diffusion_3.f90>))
CPU ֤η¬äץ򼨤ޤ (ɤ((<|URL:diffusion_5.f90>))). 
ֻ(顼Ǥʤϥܡ) dc_clock ˴طƤսǤ.

=end JA
=begin EN

((<Dc_clock|URL:../code_reference/classes/dc_clock.html>)) module of 
gt4f90io provides subroutines for CPU time counting. 
By using dc_clock module, CPU time it takes to execute arbitrary part
of user's program can be estimated.

For example, a sample program using the dc_clock module
(((<diffusion_5.f90|URL:diffusion_5.f90>))) is shown here, which are
modified from ((<diffusion_3.f90|URL:diffusion_3.f90>)) in ((<"
Fortran 90/95 general-purpose modules: (1) Type parameter
specification"|URL:dc_types.htm.en>)).  Statements with colored font
(or bold font) are associated with the dc_clock module.

=end EN


=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
!= Sample program for gt4_history/gt4f90io
!
! * 2007/06/25 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_5

  use gt4_history                                   ! Access module (⥸塼)
  use dc_types, only : DP                           ! Access module (⥸塼)
  <b><font color="red">use dc_clock, only : CLOCK, DCClockCreate, &amp;
    &amp; DCClockClose, DCClockStart, DCClockStop, &amp;
    &amp; DCClockResult, DCClockPredict, &amp;
    &amp; operator(+)                             ! Access module (⥸塼)</font></b>

  integer, parameter     :: nx=30                   ! Grid number (åɿ)
  integer, parameter     :: nt=200                  ! Time step number (֥ƥå׿)
  integer, parameter     :: ndisp=10                ! Output interval (ϴֳ)
  real(DP), parameter    :: dx=1.0/(nx-1)           ! Grid interval (åɴֳ)
  real(DP), parameter    :: dt=0.0005               ! Time step (ֳִ)
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! X coordinate (ɸѿ)
  real(DP), dimension(nx):: temp                    ! Temperature ()
  real(DP), parameter    :: kappa=1.0               ! Diffusion coefficient (ǮȻ)
  <b><font color="red">type(CLOCK)            :: clock_init, clock_loop  ! Variables for CPU time counting 
                                                    ! CPU ַ¬ѿ</font></b>

  <b><font color="red">call DCClockCreate( &amp;           ! Initialize ()
    &amp; clk = clock_init, &amp;         ! (out)
    &amp; name = 'initialization' )   ! (in)
  call DCClockCreate( &amp;           ! Initialize ()
    &amp; clk = clock_loop, &amp;         ! (out)
    &amp; name = 'time-integration' ) ! (in)</font></b>

  <b><font color="red">call DCClockStart( clk = clock_init ) ! (inout)   ! Start CPU time counting 
                                                    ! (CPU ַ¬)</font></b>

  tinit = 0.0                                       ! Set initial time 
                                                    ! ()

  temp = exp(-((x-0.5)/0.1)**2)                     ! Set initial value 
                                                    ! ()

  call HistoryCreate( &amp;                             ! Create output file 
    &amp; file='diffusion_5.nc', &amp;                      ! (ҥȥ꡼) 
    &amp; title='Diffusion equation',                        &amp;
    &amp; source='Sample program of gt4_history/gt4f90io',   &amp;
    &amp; institution='GFD_Dennou Club davis project',       &amp;
    &amp; dims=(/'x','t'/), dimsizes=(/nx,0/),               &amp;
    &amp; longnames=(/'X-coordinate','time        '/),       &amp;
    &amp; units=(/'m','s'/),                                 &amp;
    &amp; origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! Output 'x' (ѿ)

  call HistoryAddVariable( &amp;                        ! Set output variable
    &amp; varname='temp', dims=(/'x','t'/), &amp;           ! (ѿ)
    &amp; longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! Output 'temp' (ѿ)

  <b><font color="red">call DCClockStop( clk = clock_init ) ! (inout)    ! Stop CPU time counting 
                                                    ! (CPU ַ¬λ)</font></b>

  do it=1,nt
    <b><font color="red">call DCClockStart ( clk = clock_loop ) ! (inout) ! Start CPU time counting 
                                                     ! (CPU ַ¬)</font></b>

    temp(2:nx-1) = temp(2:nx-1) &amp;                   ! Time integration (ʬ)
      &amp; + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod(it,ndisp) == 0 ) then
      call HistoryPut('temp',temp)                  ! Output 'temp' (ѿ)
    endif

    <b><font color="red">call DCClockStop( clk = clock_loop ) ! (inout)  ! Stop CPU time counting 
                                                    ! (CPU ַ¬λ)

    call DCClockPredict( &amp;               ! Estimate remaining time (Ĥ֤ͽ¬)
      &amp; clk = clock_init + clock_loop, &amp; ! (in)
      &amp; progress = real(it)/real(nt) )   ! (in) </font></b>
  end do

  call HistoryClose

  <b><font color="red">call DCClockResult( &amp;                    ! Display total CPU time ( CPU ֤ɽ)
    &amp; clks = (/clock_init, clock_loop/), &amp; ! (in)
    &amp; total_auto = .true. )                ! (in)
  call DCClockClose( clk = clock_init )    ! (inout)       ! Finalize ()
  call DCClockClose( clk = clock_loop )    ! (inout)       ! Finalize ()</font></b>

  stop
end program diffusion_5
</pre>
=end HTML

=begin JA

ΥץǤ, CPU ֤η¬ʬ롼ʬ
ʬ롼ʬȤʬƹԤ, Ǹ˹ͤƤޤ. 
ʬ롼ʬǤϰʲΤ褦ʥåϤޤ.

=end JA
=begin EN

In this program, CPU time for initialization part and time integration
part are counted and summation of then is estimated at the end of
program.  At the time integration loop, following messages are dumped.

=end EN

=begin
  
  ########## PREDICTION OF CALCULATION ###########
  Start Date             2007-06-26T13:53:18+09:00
  Current Date           2007-06-26T13:53:19+09:00
  Progress     52.50%  [*************            ]
  Remaining CPU TIME      0.000000E+00
  Completion Date        2007-06-26T13:53:19+09:00

=end 

=begin JA

ƥץཪλˤϰʲΤ褦ʥåϤޤ.

=end JA
=begin EN

When the program is terminated, following messages are dumped.

=end EN

=begin
  
  ############## CPU TIME SUMMARY ################
  initialization         0.129980E-01
  time-integration       0.179959E-01
  ------------------------------------------------
         TOTAL TIME =    0.309939E-01
 
=end

=begin JA

ʲǤ dc_clock ⥸塼 ֥롼󤬹ԤäƤ뤳Ȥޤޤ.
ܤ
((<ե󥹥ޥ˥奢|URL:../code_reference/classes/dc_clock.html>)) 򻲾ȤƤ.

: use dc_clock

  ⥸塼λѤޤ. Fortran90 ᥤץƬˤ
  ޤ礦. Ǥ only ʸѤ
  ɬפʥǡȥ֥롼򻲾Ȥޤ. ʤ¤ CLOCK ѿ
  ûԤˤ, dc_clock 줿û黻 ((*+*))  use 
  ɬפ뤳ȤդƤ.


: tupe(CLOCK)

  ¤ CLOCK ѿʸǤ. ¬줿 CPU ֤Ϲ¤ CLOCK ѿ
  ˳Ǽޤ. 


: DCClockCreate(clk, name)

  ¤ CLOCK ѿޤ. ưΰ̣ϰʲ̤Ǥ.
  
  * ((*clk*)) Ͻ빽¤ CLOCK ѿꤹǤ.

  * ((*name*)) Ϸ¬ƤꤹǤ. 


: DCClockStart(clk, [err])

  ¬򳫻Ϥޤ. ¬줿 CPU ֤ 1 Ϳ ((:clk:)) 
  ˳Ǽޤ.


: DCClockStop(clk, [err])

  ¬λޤ. ¬줿 CPU ֤ Close ֥롼
  ι¤ CLOCK ѿλѤλޤ save ޤ. 
  Ʊ¤ CLOCK ѿˤƺٷ¬Ԥ, ȤȳǼ
  ͤ˲û줿ͤǼޤ.

: DCClockPredict ( clk, progress, [unit], [err] )
  
  в CPU ֤Ƚλץʬ̤Ȥ, Ĥ CPU 
  ֤ͽۤԤޤ. ưΰ̣ϰʲ̤Ǥ.

  * ((*clk*)) Ϸв CPU ֤Ǽ¤ CLOCK ѿꤹǤ.

  * ((*progress*)) ϤΥ֥롼 call 줿
    λץʬ̤γꤹǤ.
    ϻ 0, λ 1 Ȥ, 0  1 ޤǤμ¿ͤͿޤ. 
    Ǥϥ롼ѿ֥ƥå׿ѤƤޤ.

  * ((*unit*)) ϽֹꤹǤ. ꤷʤ
    ֤ȤɸϤ򤵤ޤ.

  * ((*err*))  1  ((*clks*)) ƤʤƤ
    ³Ԥ˻ꤹǤ. 


: DCClockResults( clks, [unit] [total_auto], [clk_total], [total_name], [err] )

  CPU ֤ιפɽޤ. 

  * ((*clks*)) Ϲ¤ CLOCK ѿꤹǤ.

  * ((*unit*)) ϽֹꤹǤ. ꤷʤ
    ֤ȤɸϤ򤵤ޤ.

  * ((*total_auto*)) ϹͤνϤ̵ͭꤹǤ. 
    .true. Ϳ ((*clks*)) ˻ꤷ¤ CLOCK ѿιͤϤޤ.
    Υץ ((*clk_total*)) ꤵƤ ((*clk_total*))
    ͤͥ褵ޤ.


  * ((*clk_total*)) Ϲפ빽¤ CLOCK ѿꤷޤ.

  * ((*total_name*)) ϹͤϤݤˤΥåƬɽʸꤷޤ.

  * ((*err*))  1  ((*clks*)) ƤʤƤ
    ³Ԥ˻ꤹǤ. 


: DCClockClose( clk )

  Ϳ¤ CLOCK ѿ ((*clk*))λѤλޤ.

=end JA
=begin EN

Summary of dc_clock module and its subroutines used in the sample
program are as follows. In detail, please see ((<gt4f90io reference
manual|URL:../code_reference/classes/dc_clock.html>)).


: use dc_clock

  Access dc_message module. This statement is located at the beginning
  of main program. In this case, ONLY option is used.
  If addition of CLOCK derived type variables, is necessary, 
  defined operator ((*+*)) must be accessed.


: tupe(CLOCK)

  Definition of CLOCK derived data type variable.
  Counted CPU time is stored this variables


: DCClockCreate(clk, name)

  Initialize CLOCK derived data type variable.
  Descriptions of each argument are as follows.
  
  * ((*clk*)) specifies initialized CLOCK derived data type variable.

  * ((*name*)) specifies label. 


: DCClockStart(clk, [err])

  Start CPU time counting. 
  Counted CPU time is stored 1'st argument ((:clk:)).


: DCClockStop(clk, [err])

  Stop CPU time counting. 
  Value of ((:clk:)) is saved unless subroutine ((*Close*)) is called.
  If CPU time counting is started again with same CLOCK derived data 
  type variable, new counted CPU time is added to saved value.


: DCClockPredict ( clk, progress, [unit], [err] )

  Estimate remaining CPU time by using elapsed CPU time and 
  ratio of already executed part of program to remaining part. 
  volume of program. Descriptions of each argument are as follows.

  * ((*clk*)) specifies CLOCK derived data type variable where elapsed
    CPU time is stored.

  * ((*progress*)) specifies ratio of already executed part of program to 
    remaining part where the subroutine is called.
    ((*progress*)) should be given as float value between 0 and 1,
    0 means at the start point of program and 1 means at the end of program.
    In this case, ((*progress*)) is given by using loop variable and
    total time step number. 

  * ((*unit*)) specifies unit number for output.
    Its default value is standard out.

  * ((*err*)) is argument to execute if the 1'st argument 
    ((*clks*)) is not initialized.


: DCClockResults( clks, [unit] [total_auto], [clk_total], [total_name], [err] )

  Display total CPU time. Descriptions of each argument are as follows.

  * ((*clks*)) specifies allay of CLOCK derived data type variable 
    for estimation total CPU time.

  * ((*unit*)) specifies unit number for output.
    Its default value is standard out.

  * ((*total_auto*)) is logical argument whether total CPU time is displayed 
    or not. 
    If ((*total_auto*)) is ".true.",  total value of 
    CLOCK derived data type variable specified as ((*clks*)) argument
    is dis-plied.
    If optional argument ((*clk_total*)) is specified, 
    the value of ((*clk_total*)) is given priority.

  * ((*clk_total*)) specifies CLOCK derived data type variable 
    for estimation total CPU time.

  * ((*total_name*)) specifies dump message when total CPU time is displayed.

  * ((*err*)) is argument to execute if the 1'st argument 
    ((*clks*)) is not initialized.



: DCClockClose( clk )

  Finalize CLOCK derived data type variable specified as 1'st argument.


=end EN



=begin HTML
<hr /> <small>
  $Id: dc_clock.rd,v 1.7 2008-02-11 17:18:32 morikawa Exp $
</small>
=end HTML
