#
# tmpk02.rb
#

require "numru/dcl"

include NumRu
include Math

nx = 101
ny = 101
thres = 1

dx = 6.2832/(nx - 1).to_f
dy = 6.2832/(ny - 1).to_f
dyt = 360.0/(ny - 1).to_f
arrow_thres = 1.0

skip = (ARGV[0] || (puts ' SKIP NUM (I)  ? ;'; gets)).to_i

x = NArray.sfloat(nx).indgen*dx
y = (NArray.sfloat(ny).indgen - ny/2)*dy
yt = (NArray.sfloat(ny).indgen - ny/2)*dyt
xt = NArray.sfloat(ny).fill(x[nx-1])

u = NArray.sfloat(nx,ny)
v = NArray.sfloat(nx,ny)

ny.times do |j|
  nx.times do |i|
    u[i,j] = -cos(y[j])
    v[i,j] =  cos(x[i])
  end
end

iws = (ARGV[1] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::grswnd(x[0], x[nx-1], yt[0], yt[ny-1])
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grssim(0.5*0.6/x[nx-1], 0.0, 0.0)
DCL::grstrn(5)
DCL::grstrf
DCL::uzrset('UYUSER', 0.0)
DCL::uxpaxs('U', 1)
DCL::uzrset('UYUSER', -180.0)
DCL::uxpaxs('U', 1)

DCL::tmiset('SKIPINTV', skip)
DCL::tmlset('PERIODY', true)
DCL::tmlset('NODRSHRT', true)
DCL::tmstla(x, yt, u, v)

DCL::uulin(xt, yt)

DCL::grcls

