!----------------------------------------------------------------------
!     Copyright (c) 2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wt_zonal_module ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2012/07/08  ݹ   wt_module_polvelbc_grid_test.f90 
!                             ¤
!      2012/08/26  ݹ   wt_module_torvelbc_grid_test.f90 ¤
!
program wt_zonal_module_torvelbc_grid

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wt_zonal_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ri=0.5, ro=1.5      ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_Toroidal
  real(8), dimension(nm+1,0:lm)            :: wt_Toroidal
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_Toroidal_sol
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_dToroidaldz
  real(8), dimension(0:im-1,1:jm)          :: xy_Zero=0.0D0

  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -10

  call MessageNotify('M','wt_zonal_module_torvelbc_grid_test', &
       'wt_zonal_module wt_LaplaPol2polGrid_wt subroutine tests')

  call wt_initial(im,jm,km,nm,lm,ri,ro)

  !----- wt_TorBoundariesGrid (FF) ------

  ! P_10
  xyz_Toroidal_sol = sin(xyz_Lat) * xyz_Rad * (xyz_Rad-ri)**2 * (xyz_Rad-ro)**2 
  ! P_1_1
  !xyz_Toroidal_sol = cos(xyz_Lat)*cos(xyz_Lon)* sin( pi*(xyz_Rad-ri)/(ro-ri) )
  !xyz_Toroidal_sol = 2*sin(xyz_Lat)**2 * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  
  wt_Toroidal = wt_xyz(xyz_Toroidal_sol)
  call wt_TorBoundariesGrid(wt_Toroidal,cond='FF',new=.true.) 
  xyz_Toroidal = xyz_wt(wt_Toroidal)
  xyz_dToroidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Toroidal/xyz_Rad)))

  call AssertEqual(&
    message='wt_TorBoundariesGrid (FF)',                          &
    answer =xyz_Toroidal_sol(:,:,1:km-1),                         &
    check = xyz_Toroidal(:,:,1:km-1),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesGrid (FF, Top)',                     &
    answer =xy_Zero,                                              &
    check = xyz_dToroidaldz(:,:,0),                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesGrid (FF, Bottom)',                  &
    answer =xy_Zero,                                              &
    check = xyz_dToroidaldz(:,:,km),                              &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_Toroidal2PolGrid (RF) ------

  ! P_10
  xyz_Toroidal_sol = sin(xyz_Lat) * xyz_Rad*(xyz_Rad-ri)**2*(xyz_Rad-ro)
  
  wt_Toroidal = wt_xyz(xyz_Toroidal_sol)
  call wt_TorBoundariesGrid(wt_Toroidal,cond='RF',new=.true.) 
  xyz_Toroidal = xyz_wt(wt_Toroidal)
  xyz_dToroidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Toroidal/xyz_Rad)))

  call AssertEqual(&
    message='wt_TorBoundariesGrid (RF)',                          &
    answer =xyz_Toroidal_sol(:,:,1:km-1),                         &
    check = xyz_Toroidal(:,:,1:km-1),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesGrid (RF, Top)',                     &
    answer =xy_Zero,                                              &
    check = xyz_Toroidal(:,:,0),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesGrid (RF, Bottom)',                  &
    answer =xy_Zero,                                              &
    check = xyz_dToroidaldz(:,:,km),                              &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_Toroidal2PolGrid (FR) ------

  ! P_10
  xyz_Toroidal_sol = sin(xyz_Lat) * xyz_Rad*(xyz_Rad-ri)*(xyz_Rad-ro)**2

  wt_Toroidal = wt_xyz(xyz_Toroidal_sol)
  call wt_TorBoundariesGrid(wt_Toroidal,cond='FR',new=.true.) 
  xyz_Toroidal = xyz_wt(wt_Toroidal)
  xyz_dToroidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Toroidal/xyz_Rad)))

  call AssertEqual(&
    message='wt_TorBoundariesGrid (FR)',                          &
    answer =xyz_Toroidal_sol(:,:,1:km-1),                         &
    check = xyz_Toroidal(:,:,1:km-1),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesGrid (FR, Top)',                     &
    answer =xy_Zero,                                              &
    check = xyz_dToroidaldz(:,:,0),                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesGrid (FR, Bottom)',                  &
    answer =xy_Zero,                                              &
    check = xyz_Toroidal(:,:,km),                                 &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_Toroidal2PolGrid (RR) ------

  ! P_10
  xyz_Toroidal_sol = sin(xyz_Lat) * (xyz_Rad-ri)*(xyz_Rad-ro)

  wt_Toroidal = wt_xyz(xyz_Toroidal_sol)
  call wt_TorBoundariesGrid(wt_Toroidal,cond='RR',new=.true.) 
  xyz_Toroidal = xyz_wt(wt_Toroidal)
  xyz_dToroidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Toroidal/xyz_Rad)))

  call AssertEqual(&
    message='wt_TorBoundariesGrid (RR)',                          &
    answer =xyz_Toroidal_sol(:,:,1:km-1),                         &
    check = xyz_Toroidal(:,:,1:km-1),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesGrid (RR, Top)',                     &
    answer =xy_Zero,                                              &
    check = xyz_Toroidal(:,:,0),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_TorBoundariesGrid (RR, Bottom)',                  &
    answer =xy_Zero,                                              &
    check = xyz_Toroidal(:,:,km),                                 &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','wt_zonal_module_torvelbc_grid_test', &
       'wt_zonal_module wt_TorBoundariesGrid subroutine tests suceeded!')

end program wt_zonal_module_torvelbc_grid
