#
# tmpk03.rb
#

require "numru/dcl"

include NumRu
include Math

nx = 101
ny = 101
thres = 1

dx = 6.2832/(nx - 1).to_f
dy = 1.57079/(ny - 1).to_f
dxt = 360.0/(ny - 1).to_f
dyt = 90.0/(ny - 1).to_f
arrow_thres = 1.0

skip = (ARGV[0] || (puts ' SKIP NUM (I)  ? ;'; gets)).to_i

x = NArray.sfloat(nx).indgen*dx
y = (NArray.sfloat(ny).indgen - ny/2)*dy
xt = NArray.sfloat(nx).indgen*dxt
yt = (NArray.sfloat(ny).indgen - ny/2)*dyt

puts("Y, YT #{y[0]}  #{y[ny-1]}  #{yt[0]}  #{yt[ny-1]}")

u = NArray.sfloat(nx,ny)
v = NArray.sfloat(nx,ny)

ny.times do |j|
  nx.times do |i|
    u[i,j] = -cos(y[j])
    v[i,j] =  cos(x[i])
  end
end

iws = (ARGV[1] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::grswnd(xt[0], xt[nx-1], yt[0], yt[ny-1])
DCL::grsvpt(0.05, 0.95, 0.1, 0.9)
DCL::sgstrn(10)
DCL::umpfit
DCL::grstrf

DCL::umpmap('coast_world')
DCL::umpglb

DCL::tmlset('PERIODX', true)
DCL::tmiset('SKIPINTV', skip)
DCL::tmstls(xt, yt, u, v)

DCL::grcls
