# test.pl - ʸɤƤΥå
# $Id: test.pl,v 1.5 1999/07/02 10:49:35 toyoda Exp $
# Copyright (c) TOYODA Eizi, 1998.  All rights reserved.
# see COPYING.TXT for terms of license.

# :
#	ƥإåƤ %HEADER ˳ǼƤ롣

sub testCard {
	local(*HEADER) = @_;

	if (!$HEADER{'cardtype:'}) {
		&die("cardtype: not given.");
	} elsif ($HEADER{'cardtype:'} eq 'article') {
		&testCardAuthor;
		&testCardTitle;
		&testCardJournal;
		&testCardYear;
		&testCardPages(0);
	} elsif ($HEADER{'cardtype:'} eq 'book') {
		&testCardAuthorOrEditor;
		&testCardTitle;
		&testCardPublisher;
		&testCardYear;
		&testCardChapter;
		&testCardPages(1);
	} elsif ($HEADER{'cardtype:'} eq 'inbook') {
		&testCardAuthorOrEditor;
		&testCardTitle;
		&testCardPublisher;
		&testCardYear;
	} else {
		&die("unknown CardType: $HEADER{'cardtype:'}.");
	}
}

sub testCardChapter {
	&die("chapter: required.") if ($required && !$HEADER{'chapter:'});
}

sub testCardPublisher {
	&die("publisher: required.") if ($required && !$HEADER{'publisher:'});
}

sub testCardPages {
	local($required) = @_;
	&die("pages: required.") if (!$required && !$HEADER{'pages:'});
	&warn("pages: has no number. Are you sure?")
		if ($HEADER{'pages:'} !~ /[0-9]/);
}

sub testCardAuthorOrEditor {
	local($fail) = 1;
	if ($HEADER{'author:'}) {
		&testCardAuthor;
		$fail = 0;
	}
	if ($HEADER{'editor:'}) {
		&testCardEditor;
		$fail = 0;
	}
}

sub testCardEditor {
	&die("editor: required.") unless $HEADER{'editor:'};
}

sub testCardAuthor {
	&die("author: required.") unless $HEADER{'author:'};
	&warn("author: should begin in uppercase letter.")
		if ($HEADER{'author:'} =~ /^[a-z]/);
	&warn("author: should begin in A-Za-z. ($HEADER{'author:'})")
		unless ($HEADER{'author:'} =~ /^[A-Za-z]/);
}

sub testCardJournal {
	&die("journal: required.") if (!$HEADER{'journal:'});
}

sub testCardTitle {
	&die("title: required.") if (!$HEADER{'title:'});
	#  ASCII Ƥ褤⤦äȼ嵤
	# ե٥åȤ1ʸߤʤȷٹ𤹤
	&warn("title: has no letter. Are you sure?")
		if ($HEADER{'title:'} !~ /[A-Za-z]/);
}

sub testCardYear {
	$HEADER{'year:'} =~ s/\s+//g;
	if ($HEADER{'year:'} =~ /([^0-9x]+)/) {
		local($bad) = $1;
		$HEADER{'year:'} =~ tr/0-9/x/c;
		&warn("year: has bad character '$bad' --- converted to 'x'.");
	}
	&die("year: required.") if ($HEADER{'year:'} !~ /[0-9x]/);
}
