# misc. file io concerned subroutines
# $Id: fio.pl,v 1.4 1999/05/18 12:47:51 toyoda Exp $
# Copyright (c) TOYODA Eizi, 1998.  All rights reserved.
# see COPYING.TXT for terms of license.

	# create file to write. make directory if necessary.
sub creat {
	local($fnam) = @_;
	local($parent) = $fnam;
	&CheckUmask;
	&mkdir($parent) if ($parent =~ s/\/[^\/]+$//);
	open($fnam, ">$fnam") || &die("creat $fnam");
	$fnam;
}

sub CheckUmask {
	return unless ((umask) & 0660);
	local($umask) = (umask) & ~0660;
	&warn(sprintf("warning: umask set to %04lo\n", $umask));
	umask $umask;
}

sub mkdir {
	local($dnam) = @_;
	return if (-d $dnam);
	local($parent) = $dnam;
	if ($parent =~ s/\/[^\/]+$//) {
		&mkdir($parent);
	} else {
		return;
	}
	mkdir($dnam, 0777) || &die("mkdir $dnam");
}

