% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{width}
\alias{width}
\title{Set columns width}
\usage{
width(x, j = NULL, width, unit = "in")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{width}{width in inches}

\item{unit}{unit for width, one of "in", "cm", "mm".}
}
\description{
Defines the widths of one or more columns in the
table. This function will have no effect if you have
used \code{set_table_properties(layout = "autofit")}.

\code{\link[=set_table_properties]{set_table_properties()}} can provide an alternative to fixed-width layouts
that is supported with HTML and Word output that can be set
with \code{set_table_properties(layout = "autofit")}.
}
\details{
Heights are not used when flextable is been rendered into HTML.
}
\examples{

ft <- flextable(head(iris))
ft <- width(ft, width = 1.5)
ft
}
\seealso{
Other functions for flextable size management: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()}
}
\concept{functions for flextable size management}
