% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_laplace.R
\name{dist_laplace}
\alias{dist_laplace}
\title{The Laplace distribution}
\usage{
dist_laplace(mu, sigma)
}
\arguments{
\item{mu}{The location parameter (mean) of the Laplace distribution.}

\item{sigma}{The positive scale parameter of the Laplace distribution.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Laplace distribution, also known as the double exponential distribution,
is a continuous probability distribution that is symmetric around its location
parameter.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_laplace.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_laplace.html}

In the following, let \eqn{X} be a Laplace random variable with location
parameter \code{mu} = \eqn{\mu} and scale parameter \code{sigma} = \eqn{\sigma}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}: \eqn{\mu}

\strong{Variance}: \eqn{2\sigma^2}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{1}{2\sigma} \exp\left(-\frac{|x - \mu|}{\sigma}\right)
  }{
    f(x) = 1 / (2 * sigma) * exp(-|x - mu| / sigma)
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(x) = \begin{cases}
      \frac{1}{2} \exp\left(\frac{x - \mu}{\sigma}\right) & \text{if } x < \mu \\
      1 - \frac{1}{2} \exp\left(-\frac{x - \mu}{\sigma}\right) & \text{if } x \geq \mu
    \end{cases}
  }{
    F(x) = 1/2 * exp((x - mu) / sigma) if x < mu,
           1 - 1/2 * exp(-(x - mu) / sigma) if x >= mu
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \frac{\exp(\mu t)}{1 - \sigma^2 t^2} \text{ for } |t| < \frac{1}{\sigma}
  }{
    E(e^(tX)) = exp(mu * t) / (1 - sigma^2 * t^2) for |t| < 1/sigma
  }
}
\examples{
dist <- dist_laplace(mu = c(0, 2, -1), sigma = c(1, 2, 0.5))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 0)
density(dist, 0, log = TRUE)

cdf(dist, 1)

quantile(dist, 0.7)

}
\seealso{
\link[extraDistr:Laplace]{extraDistr::Laplace}
}
