# SPDX-License-Identifier: GPL-2.0-or-later

"""
trace-DIR.rs
"""

__author__     = "Tanish Desai <tanishdesai37@gmail.com>"
__copyright__  = "Copyright 2025, Tanish Desai <tanishdesai37@gmail.com>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@redhat.com"


from tracetool import out


def generate(events, backend, group):
    out('// SPDX-License-Identifier: GPL-2.0-or-later',
        '// This file is @generated by tracetool, do not edit.',
        '',
        '#[allow(unused_imports)]',
        'use std::ffi::c_char;',
        '#[allow(unused_imports)]',
        'use util::bindings;',
        '',
        '#[inline(always)]',
        'fn trace_event_state_is_enabled(dstate: u16) -> bool {',
        '    (unsafe { trace_events_enabled_count }) != 0 && dstate != 0',
        '}',
        '',
        'extern "C" {',
        '    static mut trace_events_enabled_count: u32;',
        '}',)

    out('extern "C" {')

    for e in events:
        out('    static mut %s: u16;' % e.api(e.QEMU_DSTATE))
    out('}')

    backend.generate_begin(events, group)

    for e in events:
        out('',
            '#[inline(always)]',
            '#[allow(dead_code)]',
            'pub fn %(api)s(%(args)s)',
            '{',
            api=e.api(e.QEMU_TRACE),
            args=e.args.rust_decl())

        if "disable" not in e.properties:
            backend.generate(e, group, check_trace_event_get_state=False)
            if backend.check_trace_event_get_state:
                event_id = 'TRACE_' + e.name.upper()
                out('    if trace_event_state_is_enabled(unsafe { _%(event_id)s_DSTATE}) {',
                    event_id = event_id,
                    api=e.api())
                backend.generate(e, group, check_trace_event_get_state=True)
                out('    }')
        out('}')

    backend.generate_end(events, group)
