# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_mapper import PolyDataMapper


class OpenGLPolyDataMapper(PolyDataMapper):
    r"""
    OpenGLPolyDataMapper - poly_data_mapper using open_gl to render.
    
    Superclass: PolyDataMapper
    
    poly_data_mapper that uses a open_gl to do the actual rendering.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLPolyDataMapper, obj, update, **traits)
    
    pause_shift_scale = tvtk_base.false_bool_trait(desc=\
        r"""
        Pause per-render updates to VBO shift+scale parameters.
        
        For large datasets, re-uploading the VBO during user interaction
        can cause stutters in the framerate. Interactors can use this
        method to force update_camera_shift_scale to return immediately
        (without changes) while users are zooming/rotating/etc. and then
        re-enable shift-scale just before a still render.
        
        This setting has no effect unless the shift-scale method is set
        to NEAR_PLANE_SHIFT_SCALE or FOCAL_POINT_SHIFT_SCALE.
        
        Changing this setting does **not** mark the mapper as modified as
        that would force a VBO upload – defeating its own purpose.
        """
    )

    def _pause_shift_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPauseShiftScale,
                        self.pause_shift_scale_)

    cell_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _cell_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellIdArrayName,
                        self.cell_id_array_name)

    composite_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Generally, this class can render the composite id when iterating
        over composite datasets. However in some cases (as in AMR), the
        rendered structure may not correspond to the input data, in which
        case we need to provide a cell array that can be used to render
        in the composite id in selection passes. Set to NULL (default) to
        not override the composite id color set by CompositePainter if
        any. The array *MUST* be a cell array and of type
        UnsignedIntArray.
        """
    )

    def _composite_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompositeIdArrayName,
                        self.composite_id_array_name)

    fragment_shader_code = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _fragment_shader_code_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFragmentShaderCode,
                        self.fragment_shader_code)

    geometry_shader_code = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _geometry_shader_code_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGeometryShaderCode,
                        self.geometry_shader_code)

    point_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        By default, this class uses the dataset's point and cell ids
        during rendering. However, one can override those by specifying
        cell and point data arrays to use instead. Currently, only
        IdType array is supported. Set to NULL string (default) to use
        the point ids instead.
        """
    )

    def _point_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointIdArrayName,
                        self.point_id_array_name)

    populate_selection_settings = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _populate_selection_settings_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPopulateSelectionSettings,
                        self.populate_selection_settings)

    process_id_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        If this class should override the process id using a data-array,
        set this variable to the name of the array to use. It must be a
        point-array.
        """
    )

    def _process_id_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProcessIdArrayName,
                        self.process_id_array_name)

    vbo_shift_scale_method = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        A convenience method for enabling/disabling
        the VBO's shift+scale transform.
        """
    )

    def _vbo_shift_scale_method_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVBOShiftScaleMethod,
                        self.vbo_shift_scale_method)

    vertex_shader_code = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Allow the program to set the shader codes used directly instead
        of using the built in templates. Be aware, if set, this template
        will be used for all cases, primitive types, picking etc.
        
        @deprecated Replaced By ShaderProperty::Get*ShaderCode as of
        VTK 9.0.
        """
    )

    def _vertex_shader_code_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexShaderCode,
                        self.vertex_shader_code)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input as a DataSet.  This method is overridden in the
        specialized mapper classes to return more specific data types.
        """
    )

    def _get_vb_os(self):
        return wrap_vtk(self._vtk_obj.GetVBOs())
    vb_os = traits.Property(_get_vb_os, desc=\
        r"""
        Return the mapper's vertex buffer objects.
        """
    )

    def add_shader_replacement(self, *args):
        """
        add_shader_replacement(self, shaderType:Shader.Type,
            originalValue:str, replaceFirst:bool, replacementValue:str,
            replaceAll:bool) -> None
        C++: void add_shader_replacement(Shader::Type shaderType,
            const std::string &originalValue, bool replaceFirst,
            const std::string &replacementValue, bool replaceAll)
        This function enables you to apply your own substitutions to the
        shader creation process. The shader code in this class is created
        by applying a bunch of string replacements to a shader template.
        Using this function you can apply your own string replacements to
        add features you desire.
        
        @deprecated Replaced By
        ShaderProperty::{Add,Clear,ClearAll}ShaderReplacements as of
        VTK 9.0.
        """
        ret = self._wrap_call(self._vtk_obj.AddShaderReplacement, *args)
        return ret

    def clear_all_shader_replacements(self):
        """
        clear_all_shader_replacements(self, shaderType:Shader.Type)
            -> None
        C++: void clear_all_shader_replacements(Shader::Type shaderType)
        clear_all_shader_replacements(self) -> None
        C++: void clear_all_shader_replacements()"""
        ret = self._vtk_obj.ClearAllShaderReplacements()
        return ret
        

    def clear_shader_replacement(self, *args):
        """
        clear_shader_replacement(self, shaderType:Shader.Type,
            originalValue:str, replaceFirst:bool) -> None
        C++: void clear_shader_replacement(Shader::Type shaderType,
            const std::string &originalValue, bool replaceFirst)"""
        ret = self._wrap_call(self._vtk_obj.ClearShaderReplacement, *args)
        return ret

    def render_piece_draw(self, *args):
        """
        render_piece_draw(self, ren:Renderer, act:Actor) -> None
        C++: virtual void render_piece_draw(Renderer *ren, Actor *act)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RenderPieceDraw, *my_args)
        return ret

    def render_piece_finish(self, *args):
        """
        render_piece_finish(self, ren:Renderer, act:Actor) -> None
        C++: virtual void render_piece_finish(Renderer *ren,
            Actor *act)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RenderPieceFinish, *my_args)
        return ret

    def render_piece_start(self, *args):
        """
        render_piece_start(self, ren:Renderer, act:Actor) -> None
        C++: virtual void render_piece_start(Renderer *ren,
            Actor *act)
        Implemented by sub classes. Actual rendering is done here.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RenderPieceStart, *my_args)
        return ret

    _updateable_traits_ = \
    (('pause_shift_scale', 'GetPauseShiftScale'), ('seamless_u',
    'GetSeamlessU'), ('seamless_v', 'GetSeamlessV'),
    ('interpolate_scalars_before_mapping',
    'GetInterpolateScalarsBeforeMapping'), ('scalar_visibility',
    'GetScalarVisibility'), ('static', 'GetStatic'),
    ('use_lookup_table_scalar_range', 'GetUseLookupTableScalarRange'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('color_mode',
    'GetColorMode'), ('resolve_coincident_topology',
    'GetResolveCoincidentTopology'), ('scalar_mode', 'GetScalarMode'),
    ('cell_id_array_name', 'GetCellIdArrayName'),
    ('composite_id_array_name', 'GetCompositeIdArrayName'),
    ('fragment_shader_code', 'GetFragmentShaderCode'),
    ('geometry_shader_code', 'GetGeometryShaderCode'),
    ('point_id_array_name', 'GetPointIdArrayName'),
    ('populate_selection_settings', 'GetPopulateSelectionSettings'),
    ('process_id_array_name', 'GetProcessIdArrayName'),
    ('vbo_shift_scale_method', 'GetVBOShiftScaleMethod'),
    ('vertex_shader_code', 'GetVertexShaderCode'), ('ghost_level',
    'GetGhostLevel'), ('number_of_pieces', 'GetNumberOfPieces'),
    ('number_of_sub_pieces', 'GetNumberOfSubPieces'), ('piece',
    'GetPiece'), ('array_access_mode', 'GetArrayAccessMode'),
    ('array_component', 'GetArrayComponent'), ('array_id', 'GetArrayId'),
    ('array_name', 'GetArrayName'), ('field_data_tuple_id',
    'GetFieldDataTupleId'), ('render_time', 'GetRenderTime'),
    ('resolve_coincident_topology_polygon_offset_faces',
    'GetResolveCoincidentTopologyPolygonOffsetFaces'),
    ('resolve_coincident_topology_z_shift',
    'GetResolveCoincidentTopologyZShift'), ('scalar_range',
    'GetScalarRange'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'interpolate_scalars_before_mapping', 'pause_shift_scale',
    'release_data_flag', 'scalar_visibility', 'seamless_u', 'seamless_v',
    'static', 'use_lookup_table_scalar_range', 'color_mode',
    'resolve_coincident_topology', 'scalar_mode', 'array_access_mode',
    'array_component', 'array_id', 'array_name', 'cell_id_array_name',
    'composite_id_array_name', 'field_data_tuple_id',
    'fragment_shader_code', 'geometry_shader_code', 'ghost_level',
    'number_of_pieces', 'number_of_sub_pieces', 'piece',
    'point_id_array_name', 'populate_selection_settings',
    'process_id_array_name', 'progress_text', 'render_time',
    'resolve_coincident_topology_polygon_offset_faces',
    'resolve_coincident_topology_z_shift', 'scalar_range',
    'vbo_shift_scale_method', 'vertex_shader_code'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLPolyDataMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLPolyDataMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['interpolate_scalars_before_mapping', 'pause_shift_scale',
            'scalar_visibility', 'seamless_u', 'seamless_v', 'static',
            'use_lookup_table_scalar_range'], ['color_mode',
            'resolve_coincident_topology', 'scalar_mode'], ['array_access_mode',
            'array_component', 'array_id', 'array_name', 'cell_id_array_name',
            'composite_id_array_name', 'field_data_tuple_id',
            'fragment_shader_code', 'geometry_shader_code', 'ghost_level',
            'number_of_pieces', 'number_of_sub_pieces', 'piece',
            'point_id_array_name', 'populate_selection_settings',
            'process_id_array_name', 'render_time',
            'resolve_coincident_topology_polygon_offset_faces',
            'resolve_coincident_topology_z_shift', 'scalar_range',
            'vbo_shift_scale_method', 'vertex_shader_code']),
            title='Edit OpenGLPolyDataMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLPolyDataMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

