# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.frame_buffer_object_base import FrameBufferObjectBase


class OpenGLFramebufferObject(FrameBufferObjectBase):
    r"""
    OpenGLFramebufferObject - Internal class which encapsulates open_gl
    framebuffer_object
    
    Superclass: FrameBufferObjectBase
    
    Before delving into this class it is best to have some background in
    some open_gl terms. open_gl has a notion of a currently bound
    Framebuffers for drawing and reading. It can be the default
    framebuffer such as created with a standard window/context or it can
    be a user created Framebuffer objects. When draw and read commands
    are invoked, they apply to the current draw and/or read frambuffers.
    
    A framebuffer consists of color buffers and an optional depth buffer.
    The framebuffer_object does not hold the memory for these buffers, it
    just keeps track of what buffers are attached to it. The buffers
    themselves hold the storage for the pixels/depths.
    
    In the context of this discussion a buffer can be either a
    TextureObject (both 2D or a slice of a 3D texture) or a
    Renderbuffer. In some cases a renderbuffer may be faster or more
    lightweight but you cannot pass a renderbuffer into a shader for
    sampling in a later pass like you can a texture.
    
    You attach these buffers to the Framebuffer using methods such as
    add_color_attachment or add_depth_attachment In normal usage a buffer is
    Attached to a framebuffer_object and then some or all of the attached
    buffers are activated for drawing or reading.
    
    When you have a framebuffer bound along with some buffers attached to
    it you can then activate specific buffers for drawing or reading. So
    you have draw and read framebuffer objects (bindings) and then for
    the currently bound framebuffer_objects you have active draw and read
    buffers.
    
    A single framebuffer_object can be bound to both Draw and Read. You
    cannot assign and activate a texture_object for drawing on the FO and
    at the same time pass it in as a Texture to the shader program. That
    type of operation is very common and must be done in two steps.
    - Render to the FO with the Texture attached as an active buffer
    - deactivate the texture obj and then render with the texture obj as
      a texture passed into the shader
    
    Typical use cases: The simplest example{.cpp}
    fbo->set_context(renWin);
    fbo->save_current_bindings_and_buffers();
    fbo->populate_framebuffer(width, height);
    
    ...
    
    fbo->restore_previous_bindings_and_buffers();
    
    If you wish to use a texture you created
    
    {.cpp}
    fbo->set_context(renWin);
    fbo->save_current_bindings_and_buffers();
    fbo->Bind();
    fbo->add_color_attachment(0, TextureObj);
    fbo->add_depth_attachment(); // auto create depth buffer
    fbo->activate_buffer(0);
    
    ...
    
    fbo->restore_previous_bindings_and_buffers();
    
    If you will be using a FO repeatedly then it is best to create it
    attach the buffers and then use as needed for example
    
    Typical use case:{.cpp}
    // setup the FBO once
    fbo->set_context(renWin);
    fbo->save_current_bindings_and_buffers();
    fbo->add_color_attachment(0, TextureObj);
    fbo->add_depth_attachment(); // auto create depth buffer
    fbo->restore_previous_bindings_and_buffers();
    
    // use it many times fbo->save_current_bindings_and_buffers();
    fbo->Bind(); fbo->activate_buffer(0); ... // render here etc
    fbo->restore_previous_bindings_and_buffers();
    
    If you with to only bind the framebuffer for drawing or reading there
    are mode specific versions of some methods that only apply to the
    mode specified Draw/Read/Both. The mode argument uses open_gl
    constants so this class provides convenience methods to return them
    named get_draw_mode() get_read_mode() and get_both_mode() so that your code
    does not need to be polluted with open_gl headers/constants.
    
    This class replaces both FrameBufferObject and
    FrameBufferObject2 and contins methods from both of them. Most
    methods from FO2 should work with this class. Just rename FBO2 to FBO
    and make sure to Save and Restore the bindings and buffers. If you
    have been using the old FO class, which had comments in the header
    saying not to use it. Then you are in for a bit more of a conversion
    but generally it should still be easy. Use the code samples above (or
    any of the classes in open_gl2 that currently use FBOs) to guide you.
    They have all been converted to this class. Where previously a
    depth_buffer was automatically created for you, you now need to do it
    explicitly using add_depth_attachment().
    
    Note the capitalization of framebuffer_object
    
    @sa
    TextureObject, RenderbufferObject
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLFramebufferObject, obj, update, **traits)
    
    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, desc=\
        r"""
        
        """
    )

    def get_active_draw_buffer(self, *args):
        """
        get_active_draw_buffer(self, id:int) -> int
        C++: unsigned int get_active_draw_buffer(unsigned int id)"""
        ret = self._wrap_call(self._vtk_obj.GetActiveDrawBuffer, *args)
        return ret

    def _get_active_read_buffer(self):
        return self._vtk_obj.GetActiveReadBuffer()
    active_read_buffer = traits.Property(_get_active_read_buffer, desc=\
        r"""
        
        """
    )

    def _get_both_mode(self):
        return self._vtk_obj.GetBothMode()
    both_mode = traits.Property(_get_both_mode, desc=\
        r"""
        
        """
    )

    def get_color_attachment_as_texture_object(self, *args):
        """
        get_color_attachment_as_texture_object(self, num:int)
            -> TextureObject
        C++: TextureObject *get_color_attachment_as_texture_object(
            unsigned int num)
        Return the texture object bound to the passed attachment number.
        In the case that a renderbuffer is used, this will return
        nullptr.
        """
        ret = self._wrap_call(self._vtk_obj.GetColorAttachmentAsTextureObject, *args)
        return wrap_vtk(ret)

    def _get_depth_attachment_as_texture_object(self):
        return wrap_vtk(self._vtk_obj.GetDepthAttachmentAsTextureObject())
    depth_attachment_as_texture_object = traits.Property(_get_depth_attachment_as_texture_object, desc=\
        r"""
        
        """
    )

    def _get_draw_mode(self):
        return self._vtk_obj.GetDrawMode()
    draw_mode = traits.Property(_get_draw_mode, desc=\
        r"""
        
        """
    )

    def _get_fbo_index(self):
        return self._vtk_obj.GetFBOIndex()
    fbo_index = traits.Property(_get_fbo_index, desc=\
        r"""
        
        """
    )

    def _get_maximum_number_of_active_targets(self):
        return self._vtk_obj.GetMaximumNumberOfActiveTargets()
    maximum_number_of_active_targets = traits.Property(_get_maximum_number_of_active_targets, desc=\
        r"""
        Returns the maximum number of targets that can be rendered to at
        one time. This limits the active targets set by
        set_active_targets(). The return value is valid only if get_context
        is non-null.
        """
    )

    def _get_maximum_number_of_render_targets(self):
        return self._vtk_obj.GetMaximumNumberOfRenderTargets()
    maximum_number_of_render_targets = traits.Property(_get_maximum_number_of_render_targets, desc=\
        r"""
        Returns the maximum number of render targets available. This
        limits the available attachment points for set_color_attachment().
        The return value is valid only if get_context is non-null.
        """
    )

    def _get_multi_samples(self):
        return self._vtk_obj.GetMultiSamples()
    multi_samples = traits.Property(_get_multi_samples, desc=\
        r"""
        
        """
    )

    def _get_number_of_color_attachments(self):
        return self._vtk_obj.GetNumberOfColorAttachments()
    number_of_color_attachments = traits.Property(_get_number_of_color_attachments, desc=\
        r"""
        Return the number of color attachments for the given mode
        """
    )

    def _get_read_mode(self):
        return self._vtk_obj.GetReadMode()
    read_mode = traits.Property(_get_read_mode, desc=\
        r"""
        
        """
    )

    def activate_buffer(self, *args):
        """
        activate_buffer(self, id:int) -> None
        C++: void activate_buffer(unsigned int id)"""
        ret = self._wrap_call(self._vtk_obj.ActivateBuffer, *args)
        return ret

    def activate_draw_buffer(self, *args):
        """
        activate_draw_buffer(self, id:int) -> None
        C++: void activate_draw_buffer(unsigned int id)"""
        ret = self._wrap_call(self._vtk_obj.ActivateDrawBuffer, *args)
        return ret

    def activate_draw_buffers(self, *args):
        """
        activate_draw_buffers(self, n:int) -> None
        C++: void activate_draw_buffers(unsigned int n)
        activate_draw_buffers(self, ids:[int, ...], n:int) -> None
        C++: void activate_draw_buffers(unsigned int *ids, int n)"""
        ret = self._wrap_call(self._vtk_obj.ActivateDrawBuffers, *args)
        return ret

    def activate_read_buffer(self, *args):
        """
        activate_read_buffer(self, id:int) -> None
        C++: void activate_read_buffer(unsigned int id)"""
        ret = self._wrap_call(self._vtk_obj.ActivateReadBuffer, *args)
        return ret

    def add_color_attachment(self, *args):
        """
        add_color_attachment(self, attId:int, tex:TextureObject,
            zslice:int=0, format:int=0, mipmapLevel:int=0) -> None
        C++: void add_color_attachment(unsigned int attId,
            TextureObject *tex, unsigned int zslice=0,
            unsigned int format=0, unsigned int mipmapLevel=0)
        add_color_attachment(self, attId:int, tex:Renderbuffer) -> None
        C++: void add_color_attachment(unsigned int attId,
            Renderbuffer *tex)
        Directly assign/remove a texture to color attachments.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddColorAttachment, *my_args)
        return ret

    def add_depth_attachment(self, *args):
        """
        add_depth_attachment(self) -> None
        C++: void add_depth_attachment()
        add_depth_attachment(self, tex:TextureObject) -> None
        C++: void add_depth_attachment(TextureObject *tex)
        add_depth_attachment(self, tex:Renderbuffer) -> None
        C++: void add_depth_attachment(Renderbuffer *tex)
        Directly assign/remove a texture/renderbuffer to depth
        attachments.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddDepthAttachment, *my_args)
        return ret

    def bind(self, *args):
        """
        bind(self) -> None
        C++: void bind()
        bind(self, mode:int) -> None
        C++: void bind(unsigned int mode)
        Make the draw frame buffer active.
        """
        ret = self._wrap_call(self._vtk_obj.Bind, *args)
        return ret

    def blit(self, *args):
        """
        blit(srcExt:(int, int, int, int), destExt:(int, int, int, int),
            bits:int, mapping:int) -> int
        C++: static int blit(const int srcExt[4], const int destExt[4],
            unsigned int bits, unsigned int mapping)
        Copy from the currently bound READ FBO to the currently bound
        DRAW FBO. The method is static so that one doesn't need to
        ccreate an instance when transferring between attachments in the
        default FBO.
        """
        ret = self._wrap_call(self._vtk_obj.Blit, *args)
        return ret

    def check_frame_buffer_status(self, *args):
        """
        check_frame_buffer_status(self, mode:int) -> int
        C++: int check_frame_buffer_status(unsigned int mode)
        Validate the current FBO configuration (attachments, formats,
        etc) prints detected errors to ErrorMacro.
        """
        ret = self._wrap_call(self._vtk_obj.CheckFrameBufferStatus, *args)
        return ret

    def deactivate_draw_buffers(self):
        """
        deactivate_draw_buffers(self) -> None
        C++: void deactivate_draw_buffers()"""
        ret = self._vtk_obj.DeactivateDrawBuffers()
        return ret
        

    def deactivate_read_buffer(self):
        """
        deactivate_read_buffer(self) -> None
        C++: void deactivate_read_buffer()"""
        ret = self._vtk_obj.DeactivateReadBuffer()
        return ret
        

    def download(self, *args):
        """
        download(self, extent:[int, int, int, int], Type:int,
            nComps:int, oglType:int, oglFormat:int)
            -> PixelBufferObject
        C++: PixelBufferObject *download(int extent[4], int Type,
            int nComps, int oglType, int oglFormat)
        download(extent:[int, int, int, int], Type:int, nComps:int,
            oglType:int, oglFormat:int, pbo:PixelBufferObject) -> None
        C++: static void download(int extent[4], int Type, int nComps,
            int oglType, int oglFormat, PixelBufferObject *pbo)
        Download data from the read buffer of the current FBO. These are
        low level methods. In the static variant a PBO must be passed in
        since we don't have access to a context. The static method is
        provided so that one may download from the default FBO.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Download, *my_args)
        return wrap_vtk(ret)

    def download_color1(self, *args):
        """
        download_color1(self, extent:[int, int, int, int], Type:int,
            channel:int) -> PixelBufferObject
        C++: PixelBufferObject *download_color1(int extent[4],
            int Type, int channel)
        Download data from the read color attachment of the currently
        bound FBO into the returned PBO. The PBO must be free'd when you
        are finished with it. The number of components in the PBO is the
        same as in the name of the specific download function. When
        downloading a single color channel, the channel must be
        identified by index, 1->red, 2->green, 3-> blue.
        """
        ret = self._wrap_call(self._vtk_obj.DownloadColor1, *args)
        return wrap_vtk(ret)

    def download_color3(self, *args):
        """
        download_color3(self, extent:[int, int, int, int], Type:int)
            -> PixelBufferObject
        C++: PixelBufferObject *download_color3(int extent[4],
            int Type)"""
        ret = self._wrap_call(self._vtk_obj.DownloadColor3, *args)
        return wrap_vtk(ret)

    def download_color4(self, *args):
        """
        download_color4(self, extent:[int, int, int, int], Type:int)
            -> PixelBufferObject
        C++: PixelBufferObject *download_color4(int extent[4],
            int Type)"""
        ret = self._wrap_call(self._vtk_obj.DownloadColor4, *args)
        return wrap_vtk(ret)

    def download_depth(self, *args):
        """
        download_depth(self, extent:[int, int, int, int], Type:int)
            -> PixelBufferObject
        C++: PixelBufferObject *download_depth(int extent[4],
            int Type)
        Download data from the depth attachment of the currently bound
        FBO. The returned PBO must be Delete'd by the caller. The
        returned PBO has one component.
        """
        ret = self._wrap_call(self._vtk_obj.DownloadDepth, *args)
        return wrap_vtk(ret)

    def initialize_viewport(self, *args):
        """
        initialize_viewport(self, width:int, height:int) -> None
        C++: void initialize_viewport(int width, int height)
        Set up ortho viewport with scissor, lighting, blend, and depth
        disabled. The method affects the current bound FBO.
        """
        ret = self._wrap_call(self._vtk_obj.InitializeViewport, *args)
        return ret

    def is_supported(self, *args):
        """
        is_supported(__a:OpenGLRenderWindow) -> bool
        C++: static bool is_supported(OpenGLRenderWindow *)
        Returns if the context supports the required extensions.
        Extension will be loaded when the context is set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    def populate_framebuffer(self, *args):
        """
        populate_framebuffer(self, width:int, height:int) -> bool
        C++: bool populate_framebuffer(int width, int height)
        populate_framebuffer(self, width:int, height:int, useTextures:bool,
             numberOfColorAttachments:int, colorDataType:int,
            wantDepthAttachment:bool, depthBitplanes:int,
            multisamples:int, wantStencilAttachment:bool=False) -> bool
        C++: bool populate_framebuffer(int width, int height,
            bool useTextures, int numberOfColorAttachments,
            int colorDataType, bool wantDepthAttachment,
            int depthBitplanes, int multisamples,
            bool wantStencilAttachment=false)
        Convenience method to populate a framebuffer with attachments
        created as well. Returns true if a complete valid Framebuffer was
        created
        """
        ret = self._wrap_call(self._vtk_obj.PopulateFramebuffer, *args)
        return ret

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, win:Window) -> None
        C++: virtual void release_graphics_resources(Window *win)
        Deactivate and un_bind
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def remove_color_attachment(self, *args):
        """
        remove_color_attachment(self, index:int) -> None
        C++: void remove_color_attachment(unsigned int index)"""
        ret = self._wrap_call(self._vtk_obj.RemoveColorAttachment, *args)
        return ret

    def remove_color_attachments(self, *args):
        """
        remove_color_attachments(self, num:int) -> None
        C++: void remove_color_attachments(unsigned int num)"""
        ret = self._wrap_call(self._vtk_obj.RemoveColorAttachments, *args)
        return ret

    def remove_depth_attachment(self):
        """
        remove_depth_attachment(self) -> None
        C++: void remove_depth_attachment()"""
        ret = self._vtk_obj.RemoveDepthAttachment()
        return ret
        

    def render_quad(self, *args):
        """
        render_quad(self, minX:int, maxX:int, minY:int, maxY:int,
            program:ShaderProgram, vao:OpenGLVertexArrayObject)
            -> None
        C++: void render_quad(int minX, int maxX, int minY, int maxY,
            ShaderProgram *program, OpenGLVertexArrayObject *vao)
        Renders a quad at the given location with pixel coordinates. This
        method is provided as a convenience, since we often render quads
        in a FBO.
        \\pre positive_minX: minX>=0
        \\pre increasing_x: minX<=maxX
        \\pre valid_maxX: maxX<last_size[0]
        \\pre positive_minY: minY>=0
        \\pre increasing_y: minY<=maxY
        \\pre valid_maxY: maxY<last_size[1]
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'vtkShaderProgram', 'vtkOpenGLVertexArrayObject')])
        ret = self._wrap_call(self._vtk_obj.RenderQuad, *my_args)
        return ret

    def resize(self, *args):
        """
        resize(self, width:int, height:int) -> None
        C++: void resize(int width, int height)
        Resize all FO attachments
        """
        ret = self._wrap_call(self._vtk_obj.Resize, *args)
        return ret

    def restore_previous_bindings_and_buffers(self, *args):
        """
        restore_previous_bindings_and_buffers(self) -> None
        C++: void restore_previous_bindings_and_buffers()
        restore_previous_bindings_and_buffers(self, mode:int) -> None
        C++: void restore_previous_bindings_and_buffers(unsigned int mode)"""
        ret = self._wrap_call(self._vtk_obj.RestorePreviousBindingsAndBuffers, *args)
        return ret

    def save_current_bindings_and_buffers(self, *args):
        """
        save_current_bindings_and_buffers(self) -> None
        C++: void save_current_bindings_and_buffers()
        save_current_bindings_and_buffers(self, mode:int) -> None
        C++: void save_current_bindings_and_buffers(unsigned int mode)
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._wrap_call(self._vtk_obj.SaveCurrentBindingsAndBuffers, *args)
        return ret

    def start(self, *args):
        """
        start(self, width:int, height:int) -> bool
        C++: bool start(int width, int height)
        User must take care that width/height match the dimensions of the
        user defined texture attachments. This method makes the "active
        buffers" the buffers that will get drawn into by subsequent
        drawing calls. Note that this does not clear the render buffers
        i.e. no glClear() calls are made by either of these methods. It's
        up to the caller to clear the buffers if needed.
        """
        ret = self._wrap_call(self._vtk_obj.Start, *args)
        return ret

    def start_non_ortho(self, *args):
        """
        start_non_ortho(self, width:int, height:int) -> bool
        C++: bool start_non_ortho(int width, int height)"""
        ret = self._wrap_call(self._vtk_obj.StartNonOrtho, *args)
        return ret

    def un_bind(self, *args):
        """
        un_bind(self) -> None
        C++: void un_bind()
        un_bind(self, mode:int) -> None
        C++: void un_bind(unsigned int mode)
        Unbind this buffer
        """
        ret = self._wrap_call(self._vtk_obj.UnBind, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLFramebufferObject, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLFramebufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OpenGLFramebufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLFramebufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

