# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.graph_algorithm import GraphAlgorithm


class CollapseVerticesByArray(GraphAlgorithm):
    r"""
    CollapseVerticesByArray - Collapse the graph given a vertex array
    
    Superclass: GraphAlgorithm
    
    CollapseVerticesByArray is a class which collapses the graph using
    a vertex array as the key. So if the graph has vertices sharing
    common traits then this class combines all these vertices into one.
    This class does not perform aggregation on vertex data but allow to
    do so for edge data. Users can choose one or more edge data arrays
    for aggregation using add_aggregate_edge_array function.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCollapseVerticesByArray, obj, update, **traits)
    
    allow_self_loops = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _allow_self_loops_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAllowSelfLoops,
                        self.allow_self_loops_)

    count_edges_collapsed = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _count_edges_collapsed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCountEdgesCollapsed,
                        self.count_edges_collapsed_)

    count_vertices_collapsed = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _count_vertices_collapsed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCountVerticesCollapsed,
                        self.count_vertices_collapsed_)

    edges_collapsed_array = traits.String('EdgesCollapsedCountArray', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _edges_collapsed_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgesCollapsedArray,
                        self.edges_collapsed_array)

    vertex_array = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _vertex_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexArray,
                        self.vertex_array)

    vertices_collapsed_array = traits.String('VerticesCollapsedCountArray', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _vertices_collapsed_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVerticesCollapsedArray,
                        self.vertices_collapsed_array)

    def add_aggregate_edge_array(self, *args):
        """
        add_aggregate_edge_array(self, arrName:str) -> None
        C++: void add_aggregate_edge_array(const char *arrName)
        Add arrays on which aggregation of data is allowed. Default if
        replaced by the last value.
        """
        ret = self._wrap_call(self._vtk_obj.AddAggregateEdgeArray, *args)
        return ret

    def clear_aggregate_edge_array(self):
        """
        clear_aggregate_edge_array(self) -> None
        C++: void clear_aggregate_edge_array()
        Clear the list of arrays on which aggregation was set to allow.
        """
        ret = self._vtk_obj.ClearAggregateEdgeArray()
        return ret
        

    _updateable_traits_ = \
    (('allow_self_loops', 'GetAllowSelfLoops'), ('count_edges_collapsed',
    'GetCountEdgesCollapsed'), ('count_vertices_collapsed',
    'GetCountVerticesCollapsed'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('edges_collapsed_array', 'GetEdgesCollapsedArray'), ('vertex_array',
    'GetVertexArray'), ('vertices_collapsed_array',
    'GetVerticesCollapsedArray'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'allow_self_loops', 'count_edges_collapsed',
    'count_vertices_collapsed', 'debug', 'global_warning_display',
    'release_data_flag', 'edges_collapsed_array', 'progress_text',
    'vertex_array', 'vertices_collapsed_array'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CollapseVerticesByArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CollapseVerticesByArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['allow_self_loops', 'count_edges_collapsed',
            'count_vertices_collapsed'], [], ['edges_collapsed_array',
            'vertex_array', 'vertices_collapsed_array']),
            title='Edit CollapseVerticesByArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CollapseVerticesByArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

