!--
!----------------------------------------------------------------------
!     Copyright (c) 2007 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  au_module
!
!      spml/au_module ⥸塼 1 ͭΰβǤήαư
!      2 ΰΥեȤ줿ӥմؿ T_k(2r^2-1)Ÿ
!      ڥȥͷ׻ Fortran90 ؿ󶡤. 
!      Υ롼Υ˥ӥ----ʻŬ
!      Ƥ,  2 ˺ɸ,  ɸ, ɸθ
!      ð򤷤ʤ饹ڥȥ׻ԤѤ뤳Ȥ
!      ǰƬˤƤ. 
!
!      2 ǡ 1 ˴ؤƱ˥ڥȥ׻¹Ԥ뤿
!      ؿ󶡤Ƥ, 2, 3 ΰǤη׻Υ١󶡤. 
!
!
!  2007/12/27  ݹ  
!      2008/01/10  ݹ  Ƚ
!      2009/01/09  ݹ  au_Initial åդɲ
!      2009/01/29  ʿ ȤRDocѤ˽
!
!++
module au_module
  !
  != au_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: au_module.f90,v 1.4 2009-02-28 21:33:46 uwabami Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/au_module ⥸塼 1 ͭΰβǤήαư
  ! 2 ΰΥեȤ줿ӥմؿ T_k(2r^2/a^2-1)
  ! Ÿ륹ڥȥͷ׻ Fortran90 ؿ󶡤. 
  ! Υ롼Υ˥ӥ----ʻŬ
  ! Ƥ,  2 ˺ɸ,  ɸ, ɸθ
  ! ð򤷤ʤ饹ڥȥ׻ԤѤ뤳Ȥ
  ! ǰƬˤƤ. 
  !
  ! 2 ǡ 1 ˴ؤƱ˥ڥȥ׻¹Ԥ뤿
  ! ؿ󶡤Ƥ, 2, 3 ΰǤη׻Υ١󶡤. 
  !
  ! ŪŸλ
  !
  !         f(r)=f_k r^n T_k(2r^2/a^2-1)
  !
  ! Ǥ. 1 ӥեǡʣ¤ 2 ǡ
  ! ݤˤϽŤߤλؿ n ƥǡǤ. 
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (u_, g_, au_, ag_) , ֤ͤη򼨤Ƥ.
  !   u_  :: ӥեǡ
  !   g_  :: 1 ʻǡ
  !   au_ :: 1 ӥեǡʣ¤ 2 ǡ
  !   ag_ :: 1 ʻǡʣ¤ 2 ǡ.
  !
  !   ʣ¤ 2 ǡ 1 礭 au_Initial 
  !   ꤹŤߤλؿ nd 礭ƱǤʤФʤʤ.
  !
  ! * ؿ̾δ֤ʸ(Dr), δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_e,_au,_g, _ag) , ѿηӥեǡ
  !   ӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !    _u  :: ӥեǡ
  !    _g  :: 1 ʻǡ
  !    _au :: 1 ӥեǡʣ¤ 2 ǡ
  !    _ag :: 1 ʻǡʣ¤ 2 ǡ
  !
  !=== ƥǡμ
  !
  ! * g : 1 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:im). 
  !   * im  R ɸγʻǤ, ֥롼 au_Initial ˤ
  !     餫ꤷƤ.
  !
  ! * u : ӥեǡ.
  !   * ѿμȼ real(8), dimension(0:km). 
  !     km  R κȿǤ, ֥롼 au_Initial ˤ
  !     餫ꤷƤ. ڥȥǡγǼΤˤĤƤ...
  !
  ! * ag : 1 (R)ʻǡ¤ 2 ǡ.
  !   * ѿμȼ real(8), dimension(size(nd),0:im). 
  !      2  R ɽ.
  !
  ! * au : 1 ӥեǡ¤ 2 ǡ.
  !   * ѿμȼ real(8), dimension(size(nd),0:km). 
  !      2 ڥȥɽ.
  !
  ! * g_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * u_ ǻϤޤؿ֤ͤϥӥեǡƱ.
  !
  ! * ag_ ǻϤޤؿ֤ͤ 1 ʻǡ¤ 
  !   2 ǡƱ.
  !
  ! * au_ ǻϤޤؿ֤ͤ 1 ӥեǡ¤
  !   2 ǡƱ.
  !
  ! * ӥեǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡӥѴΤΤȤǤ.
  !
  !
  !== ѿ³
  !
  !====  
  !
  ! au_Initial  :: ӥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! g_R        :: ʻɸ(R)Ǽ 1 
  ! g_R_Weight :: ŤߺɸǼ 1 
  !
  !==== Ѵ
  !
  ! g_u, ag_au :: ӥեǡʻҥǡؤѴ
  ! u_g, au_ag :: ʻҥǡӥեǡؤѴ
  !
  !==== ʬ
  !
  ! g_Dr_u, ag_Dr_au   :: ӥեǡ R ʬѤ
  ! g_Dr2_u, ag_Dr2_au :: ӥեǡ 2  R ʬѤ
  !
  !==== ʬʿ
  !
  ! a_Int_ag, a_Avr_ag :: 1 ʻǡ¤ 2 ʬʿ
  ! Int_g, Avr_g       :: 1 ʻǡʬʿ
  !
  !==== 
  !
  ! au_Boundary_D, au_Boundary_N         :: ǥꥯ,Υޥ¦
  ! au_BoundaryTau_D, au_BoundaryTau_N   :: ǥꥯ,Υޥ¦
  ! au_BoundaryGrid_D, au_BoundaryGrid_N :: ǥꥯ,Υޥ¦
  !
  use dc_message
  use lumatrix
  implicit none
  private
  public g_R, g_R_Weight                        ! ɸѿ
  public au_Initial                             ! 
  public ag_au, au_ag, g_u, u_g                 ! Ѵ
  public ag_Dr_au, g_Dr_u                       ! ʬ
  public ag_Dr2_au, g_Dr2_u                     ! ʬ
  public a_Int_ag, Int_g, a_Avr_ag, Avr_g       ! ʬʿ
  public au_Boundary_D, au_Boundary_N           ! 
  public au_BoundaryTau_D, au_BoundaryTau_N     ! 
  public au_BoundaryGrid_D, au_BoundaryGrid_N   ! 

  interface au_Boundary_D
     !
     ! ¦ǥꥯ췿Ŭ(ˡ). 
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(size(nd),0:km),intent(inout)    :: au_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(nd)), intent(in), optional :: value
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: u_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), intent(in), optional                :: value
     !    !(in) ŬѤ붭
     !
     module procedure au_BoundaryTau_D_1d, au_BoundaryTau_D_2d
  end interface

  interface au_Boundary_N
     !
     ! ¦Υޥ󷿶Ŭ(ˡ).
     ! i=0 ǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(:,0:km),intent(inout)       :: au_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(at_data,1)), intent(in), optional :: value
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), intent(in), optional                 :: value
     !    !(in) ŬѤ붭
     !
     module procedure au_BoundaryTau_N_1d, au_BoundaryTau_N_2d
  end interface

  interface au_BoundaryTau_D
     !
     ! ¦ǥꥯ췿Ŭ(ˡ). 
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(size(nd),0:km),intent(inout)    :: au_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(nd)), intent(in), optional :: value
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: u_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), intent(in), optional                :: value
     !    !(in) ŬѤ붭
     !
     module procedure au_BoundaryTau_D_1d, au_BoundaryTau_D_2d
  end interface

  interface au_BoundaryTau_N
     !
     ! ¦Υޥ󷿶Ŭ(ˡ).
     ! i=0 ǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(size(nd),0:km),intent(inout)    :: au_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(nd)), intent(in), optional :: value
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: t_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), intent(in), optional                 :: value
     !    !(in) ŬѤ붭
     !
     module procedure au_BoundaryTau_N_1d, au_BoundaryTau_N_2d
  end interface

  interface au_BoundaryGrid_D
     !
     ! ¦ǥꥯ췿Ŭ(¶֤Ǥɾ).
     ! ¦(i=0)ǤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(size(nd),0:km),intent(inout)    :: au_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(nd)), intent(in), optional :: value
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: u_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), intent(in), optional                 :: value
     !    !(in) ŬѤ붭
     !
     module procedure au_BoundaryGrid_D_1d, au_BoundaryGrid_D_2d
  end interface

  interface au_BoundaryGrid_N
     !
     ! ¦Υޥ󷿶Ŭ(¶֤Ǥɾ).
     ! i=0 ǸۤͤͿ.
     !
     !  * ŬѤμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  * 1 ӥեǡ¤ 2 ξ
     !
     !    real(8), dimension(size(nd),0:km),intent(inout)    :: au_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), dimension(size(nd)), intent(in), optional :: value
     !    !(in) ŬѤ붭
     !
     !  * 1 ӥեǡξ
     !
     !    real(8), dimension(0:km),intent(inout)       :: u_data
     !    !(inout) ŬѤӥեǡ
     !
     !    real(8), intent(in), optional                :: value
     !    !(in) ŬѤ붭
     !
     module procedure au_BoundaryGrid_N_1d, au_BoundaryGrid_N_2d
  end interface

  real(8), parameter                 :: pi=3.1415926535897932385D0

  integer :: im, km                        ! ʻ, ȿ
  real(8) :: ra                            ! ΰ礭

  integer, allocatable :: nd(:)
  ! r^n λؿ

  real(8), allocatable :: g_R(:)
  ! ʻɸ
  ! Chebyshev-Gauss-Radau ʻ

  real(8), allocatable :: g_R_Weight(:)
  ! ʻŤߺɸ
  ! ƳʻˤʬΤνŤߤǼƤ

  real(8), allocatable :: CF(:,:), CB(:,:)   ! ѴѴѹ

  save :: im, km, ra, CF, CB, g_R, g_R_Weight, nd

contains

! ----  ---- 
  subroutine au_Initial(i_in,k_in,r_in,nd_in)
    !
    ! ӥѴγʻ, ȿ, ΰ礭, Ťߤꤹ.
    ! 
    ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
    ! 򤷤ʤФʤʤ.
    !
    integer,intent(in) :: i_in              !(in) ʻ
    integer,intent(in) :: k_in              !(in) ȿ
    real(8),intent(in) :: r_in              !(in) ¦κɸ(Ⱦ)
    integer,intent(in) :: nd_in(:)          !(in) Ť r^n λؿ

    real(8), allocatable :: c(:), w(:)   ! Ťߴؿ
    real(8) :: t
    integer :: ii,kk

    im=i_in ; km=k_in ; ra = r_in

    if ( km .gt. im ) then
       call MessageNotify('E','au_initial','KM shoud be less equal to IM')
    endif

    if ( allocated(nd) ) deallocate(nd)
    allocate(nd(size(nd_in)))
    nd = nd_in

    if ( allocated(CF) ) deallocate(CF)
    if ( allocated(CB) ) deallocate(CB)
    allocate(CF(0:im,0:im),CB(0:im,0:im))

    if ( allocated(C) ) deallocate(W)
    if ( allocated(W) ) deallocate(W)
    allocate(c(0:im),w(0:im))

    c = 1.0D0 ; c(0) = 2.0D0
    w = 2*pi/(2*im+1) ; w(0) = pi/(2*im+1)

    do ii=0,im
       do kk=0,im
          CF(kk,ii)=2.0D0/(pi*c(kk))*cos(2*pi*ii*kk/(2*im+1))*w(ii)
       enddo
    enddo

    do kk=0,im
       do ii=0,im
          CB(ii,kk)=cos(2*pi*ii*kk/(2*im+1))
       enddo
    enddo

    if ( allocated(g_R) ) deallocate(g_R)
    allocate(g_R(0:im))

    do ii=0,im
       t = 2*pi*ii/(2*im+1)
       g_R(ii) = ra*sqrt((1+cos(t))/2)    ! cos(t) = 2(r/a)^2 - 1
    enddo

    if ( allocated(g_R_Weight) ) deallocate(g_R_Weight)
    allocate(g_R_Weight(0:im))
    do ii=0,im
       g_R_Weight(ii) = 0.0
       do kk=0,km
          g_R_Weight(ii) = g_R_Weight(ii) &
               + 1.0D0/(1.0D0/4.0D0-kk**2) &
               * cos(2*kk*ii*pi/(2*im+1))/c(kk)
       enddo
       g_R_Weight(ii) = ra/(2*pi) * g_R_Weight(ii)* w(ii)
    enddo

    deallocate(c,w)

    call MessageNotify('M','au_initial','au_module (2009/01/09) is initialized')
  end subroutine au_Initial

! ---- Ѵ ---- 
  function ag_au(au_data)
    !
    ! ӥեǡʻҥǡѴ(2 ).
    !
    double precision, dimension(:,:), intent(in)       :: au_data
    !(in) ӥեǡ

    double precision, dimension(size(au_data,1),0:im)  :: ag_au
    !(out) ʻǡ

    double precision, dimension(size(au_data,1),0:im)  :: au_work
    ! 

    integer :: m, mm, i

    mm = size(au_data,1)
    if ( mm /= size(nd) ) then
       call MessageNotify('E','ag_au', &
            '1st dim. of the Chebyshev data should be same as dim. of ND.')
    end if

    if ( size(au_data,2)-1 < km ) then
       call MessageNotify('E','ag_au', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(au_data,2)-1 > km ) then
       call MessageNotify('W','ag_au', &
            'The Chebyshev dimension of input data too large.')
    endif

    au_work = 0.0 ; au_work(:,0:km) = au_data
    do m=1,mm
       do i=0,im
          ag_au(m,i) = sum(CB(i,:)*au_work(m,:))*g_R(i)**nd(m)
       enddo
    enddo

  end function ag_au

  function g_u(u_data)
    !
    ! ӥեǡʻҥǡѴ(1 ).
    !
    double precision, dimension(:), intent(in)  :: u_data
    !(in) ӥեǡ

    double precision, dimension(0:im)           :: g_u
    !(out) ʻǡ

    double precision, dimension(1,size(u_data)) :: u_work
    ! 
    double precision, dimension(1,0:im)         :: g_work
    ! 

    u_work(1,:) = u_data  
    g_work = ag_au(u_work)
    g_u = g_work(1,:)

  end function g_u

! ---- Ѵ ---- 
  function au_ag(ag_data)
    !
    ! ʻҥǡӥեǡѴ(2 ).
    !
    double precision, dimension(:,:), intent(in)      :: ag_data
    !(in) ʻǡ

    double precision, dimension(size(ag_data,1),0:km) :: au_ag
    !(out) ӥեǡ

    double precision, dimension(size(ag_data,1),0:im) :: au_work
    !

    integer :: m, mm, k

    mm = size(ag_data,1)
    if ( mm /= size(nd) ) then
       call MessageNotify('E','ag_au', &
            '1st dim. of the Chebyshev data should be same as dim. of ND.')
    end if

    if ( size(ag_data,2)-1 < im ) then
       call MessageNotify('E','au_ag', &
            'The Grid points of input data too small.')
    elseif ( size(ag_data,2)-1 > im ) then
       call MessageNotify('W','au_ag', &
            'The Grid points of input data too large.')
    endif

    do m=1,mm
       do k=0,im
          au_work(m,k) = sum(CF(k,:)*ag_data(m,:)/g_R**nd(m))
       enddo
    enddo
    au_ag = au_work(:,0:km)

  end function au_ag

  function u_g(g_data)  ! ʻ -> ڥȥ
    !
    ! ʻҥǡӥեǡѴ(1 ).
    !
    double precision, dimension(:), intent(in)     :: g_data
    !(in) ʻǡ

    double precision, dimension(0:km)              :: u_g
    !(out) ӥեǡ

    real(8), dimension(1,size(g_data)) :: ag_work
    real(8), dimension(1,0:km)         :: au_work

    ag_work(1,:) = g_data
    au_work = au_ag(ag_work)
    u_g = au_work(1,:)
    
  end function u_g

! ---- ʬ׻ ---- 
  function au_Dx_au(au_data)
    !
    ! ϥӥեǡ f_k T_k(x) Ф x ʬΥӥշ
    ! g_k T_k(x) = f_k T_k'(x) ׻(2 ).
    !
    real(8), dimension(:,0:), intent(in)     :: au_data
    !(in) ϥӥեǡ

    real(8), dimension(size(au_data,1),0:size(au_data,2)-1) :: au_Dx_au
    !(in) ϥӥեǡ

    integer :: m, k
    integer :: nm, kmax

    nm=size(au_data,1)
    kmax=size(au_data,2)-1
    if ( kmax  < km ) then
       call MessageNotify('W','au_Dx_au', &
            'The Chebyshev dimension of input data too small.')
    elseif ( kmax > km ) then
       call MessageNotify('E','au_Dx_au', &
            'The Chebyshev dimension of input data too large.')
    endif

    do m=1,nm
       au_Dx_au(m,kmax)   = 0. 
       au_Dx_au(m,kmax-1) = 2 * kmax * au_data(m,kmax) 
    enddo

    do k=kmax-2,1,-1
       do m=1,nm
          au_Dx_au(m,k) = au_Dx_au(m,k+2) + 2*(k+1)*au_data(m,k+1)
       enddo
    enddo

    do m=1,nm
       au_Dx_au(m,0) = (au_Dx_au(m,2) + 2*au_data(m,1))/2.0D0
    enddo

  end function au_Dx_au

  function ag_Dr_au(au_data)
    !
    ! ϥӥեǡ R ʬѤ(2 ).
    !
    ! ӥեǡ R ʬȤ, бʻǡ R ʬ
    ! ѤǡΥӥѴΤȤǤ.
    !
    !
    real(8), dimension(:,0:), intent(in)     :: au_data
    !(in) ϥӥեǡ

    real(8), dimension(size(au_data,1),0:im) :: ag_Dr_au
    !(out) ӥեǡ R ʬ

    integer :: nm

    nm=size(au_data,1)

    ag_Dr_au = ag_au(au_Dx_au(au_data)) * 4*spread(g_R,1,nm)/ra**2&
             + spread(nd,2,im+1)/spread(g_R,1,nm) * ag_au(au_data)
  end function ag_Dr_au

  function g_Dr_u(u_data)
    !
    ! ϥӥեǡ R ʬѤ(1 ).
    !
    ! ӥեǡ R ʬȤ, бʻǡ R ʬ
    ! ѤǡΥӥѴΤȤǤ.
    !
    !
    real(8), dimension(:), intent(in)   :: u_data
    !(in) ϥӥեǡ

    real(8), dimension(0:im)            :: g_Dr_u
    !(out) ӥեǡ R ʬ

    real(8), dimension(1,size(u_data))  :: au_work
    ! 

    real(8), dimension(1,0:im)          :: ag_work
    ! 
    
    au_work(1,:) = u_data
    ag_work = ag_Dr_au(au_work)
    g_Dr_u = ag_work(1,:)

  end function g_Dr_u

  function ag_Dr2_au(au_data)
    !
    ! ϥӥեǡ 2  R ʬѤ(2 ).
    !
    ! ӥեǡ 2  R ʬȤ, бʻǡ
    ! 2  R ʬѤǡΥӥѴΤȤǤ.
    !
    !
    real(8), dimension(:,0:), intent(in)     :: au_data
    !(in) ϥӥեǡ

    real(8), dimension(size(au_data,1),0:im) :: ag_Dr2_au
    !(out) ӥեǡ 2  R ʬ

    real(8), dimension(size(au_data,1),0:size(au_data,2)-1)  :: au_g
    real(8), dimension(size(au_data,1),0:size(au_data,2)-1)  :: au_h
    ! 

    integer :: nm

    nm=size(au_data,1)

    au_g = au_Dx_au(au_data)
    au_h = au_Dx_au(au_g)

    ag_Dr2_au = 16*spread(g_R,1,nm)**2/ra**4 * ag_au(au_h)  &
              + 4*spread(2*nd+1,2,im+1)/ra**2 * ag_au(au_g) &
              + spread(nd*(nd-1),2,im+1)/spread(g_R**2,1,nm) * ag_au(au_data)
  end function ag_Dr2_au

  function g_Dr2_u(u_data)
    !
    ! ϥӥեǡ 2  R ʬѤ(1 ).
    !
    ! ӥեǡ 2  R ʬȤ, бʻǡ 
    ! 2  R ʬѤǡΥӥѴΤȤǤ.
    !
    !
    real(8), dimension(:), intent(in)   :: u_data
    !(in) ϥӥեǡ

    real(8), dimension(0:im)            :: g_Dr2_u
    !(out) ӥեǡ 2  R ʬ

    real(8), dimension(1,size(u_data))  :: au_work
    ! 

    real(8), dimension(1,0:im)          :: ag_work
    ! 
    
    au_work(1,:) = u_data
    ag_work = ag_Dr2_au(au_work)
    g_Dr2_u = ag_work(1,:)

  end function g_Dr2_u

  !--------------- ʬ׻ -----------------
    function a_Int_ag(ag)
      !
      ! 1 ʻǡ¤ 2 ʬ
      !
      real(8), dimension(:,0:), intent(in)     :: ag
      !(in)ϳʻǡ

      real(8), dimension(size(ag,1))           :: a_Int_ag
      !(out) ʬǡ
      integer :: i

      if ( size(ag,2) < im+1 ) then
         call MessageNotify('E','a_Int_ag', &
              'The Grid points of input data too small.')
      elseif ( size(ag,2) > im+1 ) then
         call MessageNotify('W','a_Int_ag', &
              'The Grid points of input data too large.')
      endif

      a_Int_ag = 0.0d0
      do i=0,im
         a_Int_ag(:) = a_Int_ag(:) + ag(:,i)*g_R_Weight(i)
      enddo
    end function a_Int_ag

    function Int_g(g)
      !
      ! 1 ʻǡʬʿ.
      !
      real(8), dimension(0:im), intent(in)   :: g
      !(in) ʻǡ

      real(8)                                :: Int_g
      !(out) ʬ

      Int_g = sum(g*g_R_Weight)
    end function Int_g

    function a_Avr_ag(ag)
      !
      ! 1 ʻǡ¤ 2 ʿ
      !
      real(8), dimension(:,0:), intent(in)   :: ag
      !(in)ϳʻǡ

      real(8), dimension(size(ag,1))         :: a_Avr_ag
      !(out) ʿѤǡ

      a_Avr_ag = a_Int_ag(ag)/sum(g_R_Weight)
    end function a_Avr_ag

    function Avr_g(g)
      !
      ! 1 ʻǡʿ
      !
      real(8), dimension(0:im), intent(in)   :: g
      !(in) ʻǡ

      real(8)                                :: Avr_g
      !(out) ʬ

      Avr_g = Int_g(g)/sum(g_R_Weight)
    end function Avr_g

!---- Dirichlet (ˡ) ----

  subroutine au_BoundaryTau_D_2d(au_data,value)
    !
    ! Dirichlet Ŭ(ˡ, 2 )
    ! ¦(i=0)ǤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: au_data ! ǡ(m,0:km)
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:), intent(in), optional  :: value
    !(in) (m)

    real(8), dimension(:,:,:), allocatable  :: alu
    integer, dimension(:,:), allocatable    :: kp
    real(8), dimension(size(nd),0:km)        :: au_work
    real(8), dimension(size(nd),0:im)        :: ag_work
    real(8), dimension(size(au_data,1))   :: value0           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(au_data,2)-1 < km ) then
       call MessageNotify('E','au_BoundaryTau_D', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(au_data,2)-1 > km ) then
       call MessageNotify('W','au_BoundaryTau_D', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(value)) then
       value0=0
    else
       value0 = value
    endif

    if ( first ) then
       first = .false.

       allocate(alu(size(nd),0:km,0:km),kp(size(nd),0:km))

       alu=0.0D0
       do k=0,km
          alu(:,k,k) = 1.0D0
       enddo

       do k=0,km
          au_work = 0.0
          au_work(:,k) = 1.0
          ag_work = ag_au(au_work)
          alu(:,km,k) = ag_work(:,0)
       enddo

       call ludecomp(alu,kp)
    endif

    au_data(:,km)   = value0
    au_data = lusolve(alu,kp,au_data)

  end subroutine au_BoundaryTau_D_2d

  subroutine au_BoundaryTau_D_1d(u_data,value)
    !
    ! Dirichlet Ŭ(ˡ, 1 )
    ! ξǤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: u_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), intent(in), optional                :: value
    !(in) 

    real(8), dimension(1,0:km)                   :: au_work
    real(8), dimension(1)                        :: vwork           ! 

    if (.not. present(value)) then
       vwork(1)=0
    else
       vwork(1) = value
    endif

    au_work(1,:)=u_data
    call au_BoundaryTau_D_2d(au_work,vwork)
    u_data=au_work(1,:)

  end subroutine au_BoundaryTau_D_1d

!---- Neumann (ˡ) ----

  subroutine au_BoundaryTau_N_2d(au_data,value)
    !
    ! ¦ Neumann Ŭ(ˡ, 2 )
    ! i=0 ǸۤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: au_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:), intent(in), optional    :: value
    !(in) (m)

    real(8), dimension(:,:,:), allocatable  :: alu
    integer, dimension(:,:), allocatable    :: kp
    real(8), dimension(size(nd),0:km)        :: au_work
    real(8), dimension(size(nd),0:im)        :: ag_work
    real(8), dimension(size(au_data,1))   :: value0           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(au_data,2)-1 < km ) then
       call MessageNotify('E','au_BoundaryTau_DN', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(au_data,2)-1 > km ) then
       call MessageNotify('W','au_BoundaryTau_DN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(value)) then
       value0=0
    else
       value0 = value
    endif

    if ( first ) then
       first = .false.
       allocate(alu(size(nd),0:km,0:km),kp(size(nd),0:km))

       alu=0.0D0
       do k=0,km
          alu(:,k,k) = 1.0D0
       enddo

       do k=0,km
          au_work = 0.0
          au_work(:,k) = 1.0
          ag_work = ag_Dr_au(au_work)
          alu(:,km,k) = ag_work(:,0)
       enddo

       call ludecomp(alu,kp)
    endif

    au_data(:,km)   = value0
    au_data = lusolve(alu,kp,au_data)

  end subroutine au_BoundaryTau_N_2d

  subroutine au_BoundaryTau_N_1d(u_data,value)
    !
    ! Dirichlet/Neumann Ŭ(ˡ, 1 )
    ! i=0 ǸۤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: u_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), intent(in), optional                :: value
    !(in) 

    real(8), dimension(1,0:km)                   :: au_work
    real(8), dimension(1)                        :: vwork           ! 

    if (.not. present(value)) then
       vwork(1)=0
    else
       vwork(1) = value
    endif

    au_work(1,:)=u_data
    call au_BoundaryTau_N_2d(au_work,vwork)
    u_data=au_work(1,:)

  end subroutine au_BoundaryTau_N_1d

!---- Dirichlet (¶֤Ǥɾ) ----

  subroutine au_BoundaryGrid_D_2d(au_data,value)
    !
    ! Dirichlet Ŭ(¶֤Ǥɾ, 2 )
    ! ¦ǤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: au_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:), intent(in), optional    :: value
    !(in) (m)

    real(8), dimension(:,:,:), allocatable     :: alu
    integer, dimension(:,:), allocatable       :: kp
    real(8), dimension(size(au_data,1),0:im)   :: ag_data
    real(8), dimension(size(nd),0:km)          :: au_work
    real(8), dimension(size(au_data,1))        :: value0 ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( im /= km ) then
       call MessageNotify('E','au_BoundaryGrid_DD', &
            'Chebyshev truncation and number of grid points should be same.')
    endif

    if ( size(au_data,2)-1 < km ) then
       call MessageNotify('E','au_BoundaryGrid_DD', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(au_data,2)-1 > km ) then
       call MessageNotify('W','au_BoundaryGrid_DD', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(value)) then
       value0=0
    else
       value0=value   
    endif

    if ( first ) then
       first = .false.
       allocate(alu(size(nd),0:im,0:km),kp(size(nd),0:im))

       do k=0,km
          au_work = 0
          au_work(:,k)=1.0
          alu(:,:,k) = ag_au(au_work)
       enddo

       call ludecomp(alu,kp)
    endif

    ag_data = ag_au(au_data)
    ag_data(:,0)  = value0
    au_data = lusolve(alu,kp,ag_data)

  end subroutine au_BoundaryGrid_D_2d

  subroutine au_BoundaryGrid_D_1d(u_data,value)
    !
    ! Dirichlet Ŭ(¶֤Ǥɾ, 1 )
    ! ¦ǤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: u_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), intent(in), optional                :: value
    !(in) 

    real(8), dimension(1,0:km)                   :: au_work
    real(8), dimension(1)                        :: vwork           ! 

    if (.not. present(value)) then
       vwork(1)=0
    else
       vwork(1) = value
    endif

    au_work(1,:)=u_data
    call au_BoundaryGrid_D_2d(au_work,vwork)
    u_data=au_work(1,:)

  end subroutine au_BoundaryGrid_D_1d

!---- Neumann (¶֤Ǥɾ) ----

  subroutine au_BoundaryGrid_N_2d(au_data,value)
    !
    ! ¦ Neumann Ŭ(¶֤Ǥɾ, 2 )
    ! i=0 ǸۤͤͿ.
    !
    real(8), dimension(:,0:),intent(inout)         :: au_data
    !(inout) ŬѤӥեǡ(m,0:km)

    real(8), dimension(:), intent(in), optional    :: value
    !(in) (m)

    real(8), dimension(:,:,:), allocatable   :: alu
    integer, dimension(:,:), allocatable     :: kp
    real(8), dimension(size(au_data,1),0:im) :: ag_data
    real(8), dimension(size(nd),0:km)        :: au_work
    real(8), dimension(size(nd),0:im)        :: ag_work
    real(8), dimension(size(au_data,1))      :: value0   ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( im /= km ) then
       call MessageNotify('E','au_BoundaryGrid_N', &
            'Chebyshev truncation and number of grid points should be same.')
    endif

    if ( size(au_data,2)-1 < km ) then
       call MessageNotify('E','au_BoundaryGrid_N', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(au_data,2)-1 > km ) then
       call MessageNotify('W','au_BoundaryGrid_DN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(value)) then
       value0=0
    else
       value0 = value
    endif

    if ( first ) then
       first = .false.
       allocate(alu(size(nd),0:im,0:km),kp(size(nd),0:im))

       do k=0,km
          au_work = 0
          au_work(:,k)=1.0
          ag_work = ag_au(au_work)
          alu(:,:,k) = ag_work
       enddo

       do k=0,km
          au_work = 0
          au_work(:,k)=1.0
          ag_work = ag_Dr_au(au_work)
          alu(:,0,k) = ag_work(:,0)
       enddo

       call ludecomp(alu,kp)
    endif

    ag_data = ag_au(au_data)
    ag_data(:,0)  = value0
    au_data = lusolve(alu,kp,ag_data)

  end subroutine au_BoundaryGrid_N_2d

  subroutine au_BoundaryGrid_N_1d(u_data,value)
    !
    ! ¦ Neumann Ŭ(¶֤Ǥɾ, 1 )
    ! i=0 ǸۤͤͿ.
    !
    real(8), dimension(0:km),intent(inout)       :: u_data
    !(inout) ŬѤӥեǡ(0:km)

    real(8), intent(in), optional                :: value
    !(in) 

    real(8), dimension(1,0:km)                   :: au_work
    real(8), dimension(1)                        :: vwork           ! 

    if (.not. present(value)) then
       vwork(1)=0
    else
       vwork(1) = value
    endif

    au_work(1,:)=u_data
    call au_BoundaryGrid_N_2d(au_work,vwork)
    u_data=au_work(1,:)

  end subroutine au_BoundaryGrid_N_1d

end module au_module

