! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GDNcAttrInquire(var, attrname, xtype)
  use gtdata_netcdf_types, only: GD_NC_VARIABLE, GD_NC_VARIABLE_ENTRY
  use gtdata_netcdf_internal, only: vtable_lookup
  use gtdata_netcdf_generic, only: GDNcXTypeName, InquirePlus
  use netcdf_f77, only: NF_MAX_NAME, nf_inq_atttype, NF_NOERR
  use dc_url, only: GT_PLUS
  implicit none
  type(GD_NC_VARIABLE), intent(in):: var
  character(len=*), intent(in):: attrname
  character(len=*), intent(out), optional:: xtype
  type(GD_NC_VARIABLE_ENTRY):: ent
  integer:: varid, i_xtype, stat
  character(len=NF_MAX_NAME):: anam
  stat = vtable_lookup(var, ent)
  if (stat /= NF_NOERR) return
  if (present(xtype)) then
    call InquirePlus(var, attrname, varid, anam)
    stat = nf_inq_atttype(ent%fileid, varid, anam, xtype=i_xtype)
    if (stat /= NF_NOERR) i_xtype = 0
    call GDNcXTypeName(i_xtype, xtype)
  endif
end subroutine

subroutine GDNcAttrInquirePlus(var, attrname, varid, nf_attrname)
  !
  ! ۂɃANZXƂɎg varid, attrname 𓾂.
  ! attrname ̐擪 '+' ---> 摮w.
  ! attrname ̐擪 '-' ---> ϐA摮̏Ō.
  !
  use gtdata_netcdf_types, only: GD_NC_VARIABLE, GD_NC_VARIABLE_ENTRY
  use gtdata_netcdf_internal, only: vtable_lookup
  use dc_url, only: GT_PLUS
  use netcdf_f77, only: NF_GLOBAL, nf_noerr, nf_inq_attlen
  type(GD_NC_VARIABLE), intent(in):: var
  character(len=*), intent(in):: attrname
  integer, intent(out):: varid
  type(GD_NC_VARIABLE_ENTRY):: ent
  character(len=*), intent(out):: nf_attrname
  integer:: stat, n
  stat = vtable_lookup(var, ent)
  if (stat /= NF_NOERR) return
  if (attrname(1:1) == GT_PLUS) then
    varid = NF_GLOBAL
    nf_attrname = attrname(2: )
  else if (attrname(1:1) == '-') then
    varid = ent%varid
    nf_attrname = attrname(2: )
    stat = nf_inq_attlen(ent%fileid, varid, nf_attrname, n)
    if (stat == NF_NOERR) return
    varid = NF_GLOBAL
  else
    varid = ent%varid
    nf_attrname = attrname
  endif
end subroutine GDNcAttrInquirePlus
