* Sample program for gtool_history/gtool5        2001/02/27 S.Takehiro
* 
* Solving diffusion equation 
*     du/dt = kappa d^2 u/dx^2
* for giving values of u at x=0 and 1. 
*
      program diffeq

      integer nx, nt, ndisp
        parameter( nx=30 )                       ! åɿ
        parameter( nt=200 )                      ! ֥ƥå׿
        parameter( ndisp=10 )                    ! ϴֳ
      double precision  dx, dt, kappa
        parameter( dx=1.0/(nx-1))                ! åɴֳ
        parameter( dt=0.0005 )                   ! ֳִ
        parameter( kappa=1.0D0 )                 ! ǮȻ
      double precision x(nx)                     ! ɸѿ
      double precision temp(nx), temp1(nx)       ! 

      integer i,it                               ! ѿ

      character*1  dims(2), units(2)
      character*6  xtypes(2)
      character*12 lnames(2)
      integer      dimsiz(2)
      data      dims    /'x','t'/
      data      dimsiz  /nx,0/
      data      xtypes  /'double','double'/
      data      lnames  /'X-coordinate','time        '/
      data      units   /'m','s'/

      do i=1,nx
        x(i)=dx*(i-1)                            ! ɸ
      enddo

      do i=1,nx
        temp(i) = exp(-((x(i)-0.5)/0.1)**2)      ! 
      enddo

      call hscrea( 'diff77.nc', 'Diffusion equation',      ! ҥȥ꡼ 
     &             'Sample Fortran77 progam of gtool_history/gtool5', 
     &             'GFD_Dennou Club davis project', 
     &             2, dims, dimsiz, xtypes, lnames, units, 
     &             0.0, real(ndisp*dt)          )

      call hsp1d('x',x,nx)                                     ! ѿ
      call hsavar('temp',2,dims,'temperature','K','double')    ! ѿ

      call hsp1d('temp',temp,nx)                               ! ѿ
      call hsaatd('temp','+gt_user_davis_kappa',kappa,1)       ! °

      do it=1,nt                                 ! ʬ
         do i=2,nx-1
            temp1(i) = temp(i) 
     &               + kappa*(temp(i+1)-2*temp(i)+temp(i-1))
     &                   /dx**2*dt
         enddo
         do i=1,nx
            temp(i) = temp1(i)
         enddo

         if ( mod(nt,ndisp) .eq. 0 ) then
            call hsp1d('temp',temp,nx)                      ! ѿ
         endif
      enddo

      call hsclse

      stop
      end
