!------------------------------------------------------------------------
!   Υե˵Ҥ⥸塼뷲,
!   gtool5 饤֥Υ塼ȥꥢǻѤ뤿,
!   spml Fortran90 饤֥
!   <http://www.gfd-dennou.org/library/spmodel>
!   Υ⥸塼ΰȴ褷ΤǤ.
!   饤󥹤ϥꥸʥ spml ˽򤹤뤿,
!   Ѥۤ˺ݤƤ spml Υ饤󥹤򻲾Ȥ.
!------------------------------------------------------------------------

!--
!----------------------------------------------------------------------
!     Copyright (c) 2002--2006 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_base_module
!
!  spml/w_base_module ⥸塼ϵ̾Ǥ 2 ήαưĴȡ
!  Ѥڥȥˡˤäƿͷ׻뤿Υ⥸塼 w_module
!  β⥸塼Ǥ, ڥȥ׻δŪ Fortran90 ؿ
!  .
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼Ƥ
!  . ڥȥǡӳʻǡγǼˡѴξܤ׻
!  ˡˤĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!== 
!
!      2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2005/03/13  ݹ  l_nm, nm_l ǰϤ褦˳ĥ
!      2005/07/04  ݹ  OpenMP Ѵ롼б
!                            Х󥯶򤱤뤿κɲ
!      2005/07/10  ݹ  OpenMP åȥåפΥå
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2007/11/21  ݹ  ֥롼å
!      2008/02/23  ʿ ʻǡ(im,jm)  (0:im-1, 0:jm-1)
!                             ѹ.
!      2008/06/25  ʿ ʻǡ(0:im-1,1:jm) ѹ
!      2008/07/04  ʿ Ȥ RDoc Ѥ
!      2008/12/28  ݹ   xy_w, w_xy ΥȤɲ
!      2009/01/09  ݹ   w_base_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
!++
module w_base_module
  !
  != w_base_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_module_snip.f90,v 1.2 2009-02-28 12:24:52 morikawa Exp $
  ! Copyright&License:: See COPYRIGHT[link:../../COPYRIGHT]
  !
  !== .
  !
  ! spml/w_base_module ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿
  ! ⥸塼 w_module β⥸塼Ǥ, ڥȥˡ
  ! Ū Fortran90 ؿ󶡤.
  !
  !  ISPACK  SPPACK  SNPACK  Fortran77 ֥롼
  ! ƤǤ. ڥȥǡӳʻǡγǼˡ
  ! Ѵξܤ׻ˡˤĤƤ ISPACK/SNPACK,SPPACK Υޥ
  ! 奢򻲾Ȥ줿.
  !
  use dc_message
  implicit none

  integer               :: im=64            ! ʻ()
  integer               :: jm=32            ! ʻ()
  integer               :: nm=21            ! ȿ
  integer               :: np=1             ! OPENMP 祹åɿ

  logical               :: openmp=.false.   ! OPENMP å

  integer               :: it(6)            ! Ѵ
  real(8), allocatable  :: t(:)             ! Ѵ
  integer, allocatable  :: ip(:)            ! Ѵ
  real(8), allocatable  :: p(:), r(:)       ! Ѵ
  integer, allocatable  :: ia(:)            ! Ѵ
  real(8), allocatable  :: a(:)             ! Ѵ
  real(8), allocatable  :: y(:,:)           ! Ѵ

  real(8), allocatable  :: q(:)             ! 
  real(8), allocatable  :: ww(:), ws(:)     ! 
  real(8), allocatable  :: wv(:)            ! (OPENMP)

  real(8), allocatable  :: x_Lon(:), y_Lat(:)                ! ٷ
  real(8), allocatable  :: x_Lon_Weight(:), y_Lat_Weight(:)  ! ɸŤ
  real(8), allocatable  :: xy_Lon(:,:), xy_Lat(:,:)

  real(8), allocatable  :: xy_work(:,:)     ! w_xy,xy_w Ѵ
  integer               :: id=65, jd=33     ! xy_work 礭

  real(8), parameter    :: pi=3.1415926535897932385D0

  private

  public im, jm, nm                           ! ʻ, ȿ, Ⱦ
  public it, t, y, ip, p, r, ia, a            ! ѴѺ
  public openmp, np                           ! OPENMP ѿ

  public w_base_Initial                       ! ֥롼
  public x_Lon, y_Lat                         ! ʻҺɸ
  public x_Lon_Weight, y_Lat_Weight           ! ʻҺɸŤ
  public xy_Lon, xy_Lat                       ! ʻҺɸ(im,jm)
  public l_nm, nm_l                           ! ȿǼ
  public xy_w, w_xy                           ! Ѵؿ

  interface l_nm
     module procedure l_nm_array00
     module procedure l_nm_array01
     module procedure l_nm_array10
     module procedure l_nm_array11
  end interface

  interface nm_l
     module procedure nm_l_int
     module procedure nm_l_array
  end interface

  save im, jm, nm                             ! ʻ, ȿ, Ⱦ¤򵭲
  save it, t, y, ip, p, r, ia, a              ! Ѵ򵭲
  save id, jd                                 ! Ѵ礭

  contains
  !---------------  -----------------
    subroutine w_base_Initial(n_in,i_in,j_in,np_in)
      !
      ! ڥȥѴγʻ, ȿ OPENMP ѻ
      ! 祹åɿꤹ.
      !
      ! ºݤλѤˤϾ̥֥롼 w_Initial Ѥ뤳.
      !
      integer,intent(in) :: i_in              !(in) ʻ()
      integer,intent(in) :: j_in              !(in) ʻ()
      integer,intent(in) :: n_in              !(in) ȿ
      integer,intent(in), optional :: np_in   !(in) OPENMP Ǥκ祹åɿ

      integer :: iw, i, j

      im = i_in  ; jm = j_in  ; nm = n_in

      if ( present(np_in) )then
         np = np_in

         if ( np .gt. 1 ) then
            openmp = .true. 
            allocate(wv((nm+4)*(nm+3)*np))
            call MessageNotify('M','w_base_Initial', &
                 'OpenMP computation was set up.')
         else
            openmp = .false. 
         endif

      else
         openmp = .false. 
      endif

      if ( im/2*2 .eq. im ) then
         id = im+1 
      else
         id = im
      endif
      if ( openmp ) then
         jd = jm
      else if ( jm/2*2 .eq. jm ) then
         jd = jm+1
      else
         jd = jm
      endif
      allocate(xy_work(id,jd))                ! Ѵ
      xy_work = 0.

      allocate(t(im*2))                       ! Ѵ
      allocate(ip(((nm+1)/2+nm+1)*2))         ! Ѵ
      allocate(p(((nm+1)/2+nm+1)*jm))         ! Ѵ
      allocate(r(((nm+1)/2*2+3)*(nm/2+1)))    ! Ѵ
      allocate(ia((nm+1)*(nm+1)*4))           ! Ѵ
      allocate(a((nm+1)*(nm+1)*6))            ! Ѵ
      allocate(y(jm/2,4))                     ! Ѵ

      allocate(q(((nm+1)/2+nm+1)*jm))         ! 
      if ( openmp ) then
         iw=(im+nm+1)*3*jm/2
      else
         iw=max((nm+4)*(nm+3),jd*3*(nm+1),jd*im)
      endif
      allocate(ws(iw),ww(iw))                 ! 

      allocate(x_Lon(0:im-1))                ! ʻɸǼ()
      allocate(x_Lon_Weight(0:im-1))
      allocate(xy_Lon(0:im-1,1:jm))
      allocate(y_Lat(1:jm))
      allocate(y_Lat_Weight(1:jm))             ! ʻɸǼ
      allocate(xy_Lat(0:im-1,1:jm))        ! ʻɸǼ

      call sninit(nm,im,jm,it,t,y,ip,p,r,ia,a)

      do i=0,im-1
         x_Lon(i)  = 2*pi/im*i               ! ٺɸ
         x_Lon_Weight(i) = 2*pi/im           ! ٺɸŤ
      enddo


      do j=1,jm/2
         y_Lat(jm/2+j)   =  asin(y(j,1))        ! ٺɸ
         y_Lat(jm/2-j+1) = -asin(y(j,1))        ! ٺɸ
         y_Lat_Weight(jm/2+j)   = 2*y(j,2)      ! ٽŤ(Gauss grid)
         y_Lat_Weight(jm/2-j+1) = 2*y(j,2)      ! ٽŤ(Gauss grid)
      enddo

      do j=1,jm
         xy_Lon(:,j) = x_Lon
      enddo

      do i=0,im-1
         xy_Lat(i,:) = y_Lat
      enddo

      call MessageNotify('M','w_base_initial',&
           'w_base_module (2009/01/09) is initialized')

    end subroutine w_base_Initial

  !--------------- Ѵ -----------------

    function l_nm_array00(n,m)
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  n,m Ȥͤξ, ֤ͤ. 
      !
      integer               :: l_nm_array00   
      !(out) ڥȥǡγǼ 

      integer, intent(in)   :: n     !(in) ȿ
      integer, intent(in)   :: m     !(in) Ӿȿ           

      call snnm2l(n,m,l_nm_array00)
    end function l_nm_array00

    function l_nm_array01(n,marray)           ! ڥȥǡγǼ 
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1  n ,  2  marray  1 ξ, 
      ! marray Ʊ礭 1 ֤. 
      !
      integer, intent(in)  :: n               !(in) ȿ
      integer, intent(in)  :: marray(:)       !(in) Ӿȿ
      integer              :: l_nm_array01(size(marray))
      !(out) ڥȥǡ

      integer              :: i 

      do i=1, size(marray)
         l_nm_array01(i) = l_nm_array00(n,marray(i))
      enddo
    end function l_nm_array01

    function l_nm_array10(narray,m)
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1  narray  1 ,  2   m ξ, 
      ! narray Ʊ礭 1 ֤. 
      !
      integer, intent(in)  :: narray(:)           !(in) ȿ  
      integer, intent(in)  :: m                   !(in) Ӿȿ
      integer              :: l_nm_array10(size(narray))
      !(out) ڥȥǡ

      integer              :: i 

      do i=1, size(narray)
         l_nm_array10(i) = l_nm_array00(narray(i),m)
      enddo
    end function l_nm_array10

    function l_nm_array11(narray,marray)
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1,2  narray, marray Ȥ 1 ξ, 
      ! narray, marray Ʊ礭 1 ֤. 
      ! narray, marray Ʊ礭ǤʤФʤʤ. 
      !
      integer, intent(in)  :: narray(:)          !(in) ȿ  
      integer, intent(in)  :: marray(:)          !(in) Ӿȿ
      integer              :: l_nm_array11(size(narray))
      !(out) ڥȥǡ

      integer              :: i 

      if ( size(narray) .ne. size(marray) ) then
         call MessageNotify('E','l_nm_array11',&
              'dimensions of input arrays  n and m are different.')
      endif

      do i=1, size(narray)
         l_nm_array11(i) = l_nm_array00(narray(i),marray(i))
      enddo
    end function l_nm_array11

    function nm_l_int(l)
      ! 
      ! ڥȥǡγǼ(l)ȿ(n)ȿ(m)֤.
      !
      !  l ͤξ, бȿӾȿ
      ! Ĺ 2  1 ֤ͤ. 
      ! nm_l(1) ȿ, nm_l(2) ӾȿǤ. 
      !
      integer               :: nm_l_int(2)  !(out) ȿ, Ӿȿ
      integer, intent(in)   :: l            !(in) ڥȥǡγǼ
      
      call snl2nm(l,nm_l_int(1),nm_l_int(2))
    end function nm_l_int

    function nm_l_array(larray)
      ! 
      ! ڥȥǡγǼ(l)ȿ(n)ȿ(m)֤.
      !
      !  larray  1 ξ, 
      ! larray б n, m Ǽ 2 ֤. 
      ! nm_l_array(:,1) ȿ, nm_l_array(:,2) ӾȿǤ. 
      !
      integer, intent(in)  :: larray(:)
      !(out) ȿ, Ӿȿ

      integer              :: nm_l_array(size(larray),2)
      !(in) ڥȥǡγǼ

      integer              :: i

      do i=1, size(larray)
         nm_l_array(i,:) = nm_l_int(larray(i))
      enddo
    end function nm_l_array

    function xy_w(w_data,ipow,iflag)
      !
      ! ڥȥǡʻҥǡѴ(1 ).
      !
      real(8)               :: xy_w(0:im-1,1:jm)
      !(out) ʻǡ

      real(8), intent(in)   :: w_data((nm+1)*(nm+1))
      !(in) ڥȥǡ

      integer, intent(in), optional  :: ipow      
      !(in) Ѥ 1/cos μ. ά 0. 

      integer, intent(in), optional  :: iflag
      !(in) Ѵμ
      !    0 : ̾Ѵ
      !   -1 : ʬѤѴ
      !    1 : ʬ cosա/ߦ ѤѴ
      !    2 : sinդѤѴ
      !    ά 0.
      !
      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval, i, j

      logical :: first=.true.                    ! Ƚꥹå
      save first

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      if ( openmp ) then
         if ( first ) then
            call MessageNotify('M','xy_w', &
                 'OpenMP routine SNTSOG/SNPACK is used for spherical harmonic transformation.')
         endif
         call sntsog(nm,im,id,jm,1,w_data,xy_work,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,wv,ipval,ifval)
      else
         call snts2g(nm,im,id,jm,jd,1,w_data,xy_work,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)
      endif
      do i=0,im-1
        do j=1,jm
          xy_w(i,j) = xy_work(i+1,j)
        enddo
      enddo
      first = .false.

    end function xy_w

    function w_xy(xy_data,ipow,iflag)
      !
      ! ʻҥǡ饹ڥȥǡ()Ѵ(1 ).
      !
      real(8)               :: w_xy((nm+1)*(nm+1))
      !(out) ڥȥǡ

      real(8), intent(in)   :: xy_data(0:im-1,1:jm)
      !(in) ʻǡ

      integer, intent(in), optional  :: ipow
      !(in) ѴƱ˺Ѥ 1/cos μ. ά 0.

      integer, intent(in), optional  :: iflag
      ! Ѵμ
      !    0 : ̾Ѵ
      !   -1 : ʬѤѴ 
      !    1 : ʬ 1/cosա(f cos^2)/ߦ ѤѴ
      !    2 : sinդѤѴ
      !  ά 0.


      integer, parameter  :: ipow_default  = 0    ! åǥե
      integer, parameter  :: iflag_default = 0    ! åǥե

      integer ipval, ifval, i, j

      logical :: first=.true.                     ! Ƚꥹå
      save first

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif
      
      do i=0,im-1
        do j=1,jm
          xy_work(i+1,j)=xy_data(i,j)
        enddo
      enddo

      if ( openmp ) then
         if ( first ) then
            call MessageNotify('M','w_xy', &
                 'OpenMP routine SNTGOS/SNPACK is used for spherical harmonic transformation.')
         endif
         call sntgos(nm,im,id,jm,1,xy_work,w_xy,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,wv,ipval,ifval)
      else
         call sntg2s(nm,im,id,jm,jd,1,xy_work,w_xy,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)
      endif
      first = .false.

    end function w_xy

  end module w_base_module
!--
!----------------------------------------------------------------------
!     Copyright (c) 2002-2006 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_deriv_module
!
!  spml/w_deriv_module ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 w_module β⥸塼Ǥ, ڥȥˡ
!  ʬ׻Τ Fortran90 ؿ󶡤. 
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!  Υ⥸塼Ȥˤä w_base_initial Ƥ
!  ȿ, ʻ򤷤Ƥɬפ. 
!
!
!  2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2005/07/04  ݹ  OPENMP Ѵ롼б
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2008/05/31  ݹ  롼ʬΥ
!      2008/06/22  ʿ ʻǡ󳫻 1  0 .
!      2008/06/23  ʿ ʻǡγǼ (0:im-1, 1:jm) .
!      2008/07/01  ʿ Ȥ RDoc Ѥ
!      2009/01/09  ݹ  w_deriv_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
!++
module w_deriv_module
  !
  != w_deriv_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_module_snip.f90,v 1.2 2009-02-28 12:24:52 morikawa Exp $
  ! Copyright&License:: See COPYRIGHT[link:../../COPYRIGHT]
  !
  !== 
  !
  ! spml/w_deriv_module ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿 
  ! ⥸塼 w_module β⥸塼Ǥ, ڥȥˡ
  ! ʬ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  ! Υ⥸塼Ȥˤä w_base_initial Ƥ
  ! ȿ, ʻ򤷤Ƥɬפ. 
  !
  use dc_message, only : MessageNotify
  use w_base_module, only : im, jm, nm, it, t, y, ip, p, r, ia, a, &
                            w_base_Initial, xy_w, w_xy
  implicit none

  real(8), allocatable  :: rn(:,:)            
  ! ץ饷黻
  !
  ! ڥȥǡΥץ饷׻뤿η
  ! Υ((nm+1)*(nm+1), 2)
  !
  ! r(L,1) ˤ L ܤγǼ֤ΥڥȥФץ饷׻
  !  -n(n+1) ͤǼƤ.
  !
  integer, allocatable  :: irm(:,:)           
  ! ʬ黻
  !
  ! ڥȥǡηʬ׻뤿η.
  ! 󥵥 ( (nm+1)*(nm+1),2 ) Ǥ.
  !
  ! LܤγǼ֤Υڥȥ뤬ʤ, irm(L,1)ˤбγǼ֤,
  ! irm(L,2) ˤȿ m ǼƤ. ޤ, LܤγǼ֤Υڥȥ
  ! ʤ, irm(L,1)ˤбγǼ֤, irm(L,2)ˤ -m Ǽ
  ! Ƥ.
  !
  integer, allocatable  :: ip2(:), ip3(:)     ! 䥳ӥ׻
  real(8), allocatable  :: p2(:), p3(:)       ! 䥳ӥ׻
  real(8), allocatable  :: r2(:), r3(:)       ! 䥳ӥ׻

  real(8), allocatable  :: q(:)               ! 
  real(8), allocatable  :: ww(:),ws(:)        ! 

  private

  public w_deriv_Initial                      ! 
  public w_Lapla_w, w_LaplaInv_w              ! ץ饷ȵձ黻
  public w_DLon_w                             ! ʬ
  public xy_GradLon_w, xy_GradLat_w           ! ۷ʬ
  public w_DivLon_xy, w_DivLat_xy             ! ȯʬ
  public w_Div_xy_xy                          ! ȯʬ
  public w_Jacobian_w_w                       ! 䥳ӥ
  public xy_GradLambda_w, xy_GradMu_w         ! ۷ʬ(,̺ɸ)
  public w_DivLambda_xy, w_DivMu_xy           ! ȯʬ(,̺ɸ)

  public rn, irm                              ! ץ饷/ʬ黻

  save rn, irm, ip2, ip3, p2, p3, r2, r3

  contains

  !---------------  -----------------
    subroutine w_deriv_initial
      !
      ! ڥȥʬ׻ɬפȤʤΰꤹ. 
      !
      ! ¾δؿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ. 
      !
      ! Υ֥롼ñȤѤΤǤʤ, 
      ! ̥֥롼 w_Initial Ѥ뤳.
      !
      integer iw

      allocate(rn((nm+1)*(nm+1),2))           ! ץ饷黻
      allocate(irm((nm+1)*(nm+1),2))          ! ʬ黻
      call spnini(nm,rn)
      call spmini(nm,irm)

      allocate(ip2(2*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p2(2*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r2(2*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      allocate(ip3(3*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p3(3*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r3(3*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      call snkini(nm,jm,2,ip,p,r,ip2,p2,r2)
      call snkini(nm,jm,3,ip,p,r,ip3,p3,r3)

      allocate(q(3*((nm+1)/2+nm+1)*jm))       ! 
      iw=3*max( ((nm+1)/2*2+3)*(nm/2+2)*2, &
                jm*((nm+1)/2+nm+1)*2, jm*jm )
      allocate(ws(iw),ww(iw))                 ! 

      call MessageNotify('M','w_deriv_initial',&
           'w_deriv_module (2009/01/09) is initialized')

    end subroutine w_deriv_initial

  !--------------- ʬ׻ -----------------
    function w_Lapla_w(w_data)
      !
      ! ϥڥȥǡ˥ץ饷
      !
      !    ^2 = 1/cos^2ա^2/ߦ^2 + 1/cosա/ߦ(cosբ/ߦ)
      !
      ! Ѥ(1 ).
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8)              :: w_Lapla_w((nm+1)*(nm+1))
      !(out) ϥڥȥǡΥץ饷

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call spclap(nm,w_data,w_Lapla_w,rn(1,1))
    end function w_Lapla_w

    function w_LaplaInv_w(w_data)
      !
      ! ϥڥȥǡ˵եץ饷
      !
      !    ^{-2}
      !      =[1/cos^2ա^2/ߦ^2 + 1/cosա/ߦ(cosբ/ߦ)]^{-1}
      !
      ! Ѥ(1 ).
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8)              :: w_LaplaInv_w((nm+1)*(nm+1))
      !(out) ڥȥǡεեץ饷

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call spclap(nm,w_data,w_LaplaInv_w,rn(1,2))
    end function w_LaplaInv_w

    function w_DLon_w(w_data)
      !
      ! ڥȥǡ˷ʬ /ߦ Ѥ(1 ).
      !
      ! ڥȥǡηʬȤ, бʻǡ
      ! ʬ/ߦˤѤǡΥڥȥѴΤȤǤ.
      ! 
      real(8)              :: w_DLon_w((nm+1)*(nm+1))
      !(out) ڥȥǡηʬ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call spclam(nm,w_data,w_DLon_w,irm)

    end function w_DLon_w

    function xy_GradLon_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ 1/cosա/ߦ 
      ! Ѥʻǡ֤(1 ).
      !
      real(8)              :: xy_GradLon_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradLon_w = xy_w(w_data,ipow=1,iflag=-1)

    end function xy_GradLon_w

    function xy_GradLat_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(1 ).
      !
      real(8)              :: xy_GradLat_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradLat_w = xy_w(w_data,ipow=1,iflag=1)

    end function xy_GradLat_w

    function w_DivLon_xy(xy_data)
      !
      ! ʻǡȯʬ 1/cosա/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLon_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ
      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLon_xy = w_xy(xy_data,ipow=1,iflag=-1)

    end function w_DivLon_xy

    function w_DivLat_xy(xy_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLat_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLat_xy = w_xy(xy_data,ipow=1,iflag=1)

    end function w_DivLat_xy

    function w_Div_xy_xy(xy_u,xy_v)
      !
      ! 2 Ĥϳʻǡ٥ȥʬȤȯ׻, 
      ! ڥȥǡȤ֤(1 ).
      !
      real(8)              :: w_Div_xy_xy((nm+1)*(nm+1))
      !(out) 2 Ĥϳʻǡ٥ȥʬȤȯΥڥȥǡ

      real(8), intent(in)  :: xy_u(0:im-1,1:jm)
      !(in) ٥ȥʬγʻǡ

      real(8), intent(in)  :: xy_v(0:im-1,1:jm)
      !(in) ٥ȥʬγʻǡ

      w_Div_xy_xy = w_Divlon_xy(xy_u) + w_Divlat_xy(xy_v)

    end function w_Div_xy_xy

    function w_Jacobian_w_w(w_a,w_b)
      ! 2 ĤΥڥȥǡ˥䥳ӥ
      !
      !   J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
      !          = f/ߦˡ1/cosաg/ߦ
      !             - g/ߦˡ1/cosաf/ߦ
      !
      ! Ѥ(1 ).

      real(8)             :: w_Jacobian_w_w((nm+1)*(nm+1))
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), intent(in) :: w_a((nm+1)*(nm+1))
      !(in) 1ܤϥڥȥǡ
      
      real(8), intent(in) :: w_b((nm+1)*(nm+1))
      !(in) 2ܤϥڥȥǡ

      call spnjcb(nm,im,im,jm,jm,w_a,w_b,w_Jacobian_w_w,&
           it,t,y,ip2,p2,r2,ip3,p3,r3,ia,a,q,ws,ww)

    end function w_Jacobian_w_w

  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xy_GradLambda_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ(1 ).
      !
      real(8)              :: xy_GradLambda_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ
      
      xy_GradLambda_w = xy_w(w_data,ipow=0,iflag=-1)

    end function xy_GradLambda_w

    function xy_GradMu_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤(1 ).
      !
      real(8)              :: xy_GradMu_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradMu_w = xy_w(w_data,ipow=0,iflag=1)

    end function xy_GradMu_w

    function w_DivLambda_xy(xy_data)
      !
      ! ʻǡȯʬ 1/(1-^2)/ߦ (=sin) 
      ! ѤƥڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLambda_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLambda_xy = w_xy(xy_data,ipow=2,iflag=-1)

    end function w_DivLambda_xy

    function w_DivMu_xy(xy_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivMu_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivMu_xy = w_xy(xy_data,ipow=2,iflag=1)

    end function w_DivMu_xy

  end module w_deriv_module
!--
!----------------------------------------------------------------------
! Copyright (c) 2002-2008 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_module
!
!   spml/w_module ⥸塼ϵ̾Ǥ 2 ήαư
!   ĴȡѤڥȥˡˤäƿͷ׻뤿
!   Fortran90 ؿ󶡤. 
!
!   w_module ϼºݤˤϴѴ, ʬ׻, ʬʿѷ׻, ڥȥ
!   򤽤줾ôäƤ벼⥸塼 w_base_module, w_deriv_module, 
!   w_integral_module, w_spectrum_module ʤäƤ.
!
!    ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ.
!   ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!   ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2002/02/02  ݹ  1 
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/25  ݹ  ⥸塼̾ѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2002/10/07  ݹ  , ̺ɸʬɲ
!      2005/04/23  ݹ  ڥȥϥ⥸塼ɲ
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2006/03/19  ݹ  ѿ³򥳥Ȥɲ
!      2007/10/28  ݹ  ִؿ⥸塼ɲ
!      2007/11/21  ݹ  ֥롼å
!      2008/05/31  ݹ  ֥롼󿷤˺
!      2008/07/01  ʿ Ȥ RDoc Ѥ
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!
!++
module w_module
  !
  != w_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_module_snip.f90,v 1.2 2009-02-28 12:24:52 morikawa Exp $
  ! Copyright&License:: See COPYRIGHT[link:../../COPYRIGHT]
  !
  !== 
  !
  ! spml/w_module ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿
  ! Fortran90 ؿ󶡤. 
  !
  ! w_module ϼºݤˤϴѴ, ʬ׻, ʬʿѷ׻, ڥȥ
  ! 򤽤줾ôäƤ벼⥸塼 w_base_module, w_deriv_module, 
  ! w_integral_module, w_spectrum_module ʤäƤ.
  !
  !  ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ.
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (w_, nm_, n_, xy_, x_, y_) , ֤ͤη򼨤Ƥ.
  !   w_  :: ڥȥǡ
  !   xy_ :: 2 ʻǡ
  !   nm_ :: ڥȥǡ¤ 3 (ڥȥǡ¤Ӥ
  !          ȿ n, Ӿȿ m ǻꤵ 2 )
  !   n_  :: ڥȥǡ¤ 2  (ڥȥǡ¤Ӥ
  !          ȿ n ǻꤵ 1 )
  !   x_  ::  1 ʻǡ
  !   y_  ::  1 ʻǡ
  !
  ! * ؿ̾δ֤ʸ(DLon, GradLat, GradLat, DivLon, DivLat, Lapla, 
  !   LaplaInv, Jacobian), δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_w_w, _w, _xy, _x, _y) , ѿηڥȥǡ
  !   ӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _w   :: ڥȥǡ
  !   _w_w :: 2 ĤΥڥȥǡ
  !   _xy  :: 2 ʻǡ
  !   _x   ::  1 ʻǡ
  !   _y   ::  1 ʻǡ
  !
  !=== ƥǡμ
  !
  ! * xy : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:im-1,1:jm). 
  !   * im, jm Ϥ줾, ٺɸγʻǤ, ֥롼
  !     w_Initial ˤƤ餫ꤷƤ.
  !
  ! * w : ڥȥǡ.
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1)). 
  !   * nm ϵĴȡκȿǤ, ֥롼 w_Initial ˤ
  !     餫ꤷƤ. 
  !   * ڥȥǡγǼΤϴؿ l_nm, nm_l ˤä
  !     Ĵ٤뤳ȤǤ.
  !
  ! * nm : ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(0:nm,-nm:nm). 
  !      1 ʿȿ,   2 Ӿȿɽ. 
  !   * nm ϵĴȡκȿǤ, ֥롼 w_Initial ˤ
  !     餫ꤷƤ.
  !
  ! * n : ڥȥǡ¤ 1 .
  !   * ѿμȼ real(8), dimension(0:nm). 
  !   *  1 ʿȿɽ. nm ϵĴȡκȿǤ, 
  !     ֥롼 w_Initial ˤƤ餫ꤷƤ.
  !
  ! * x, y : ,  1 ʻǡ.
  !   * ѿμȼϤ줾 real(8), dimension(0:im-1) 
  !      real(8), dimension(1:jm).
  !
  ! * w_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * xy_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  ! * x_, y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !
  !== ѿ³
  !
  !====  
  !
  ! w_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! x_Lon, y_Lat     ::  ʻɸ(, ٺɸ)Ǽ 1 
  ! x_Lon_Weight, y_Lat_Weight ::  ŤߺɸǼ 1 
  ! xy_Lon, xy_Lat   :: ʻǡη١ٺɸ(X,Y)
  !                     (ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! xy_w :: ڥȥǡʻҥǡؤѴ
  ! w_xy :: ʻҥǡ饹ڥȥǡؤѴ
  ! l_nm, nm_l :: ڥȥǡγǼ֤ȿӾȿѴ 
  !
  !==== ʬ
  !
  ! w_Lapla_w       :: ڥȥǡ˥ץ饷Ѥ
  ! rn              :: ڥȥǡΥץ饷׻뤿η. 
  ! irm             :: ʬ黻
  ! w_LaplaInv_w    :: ڥȥǡ˥ץ饷εѴѤ
  ! w_DLon_w        :: ڥȥǡ˷ʬ/ߦˤѤ
  ! xy_GradLon_w    :: ڥȥǡ
  !                    ۷ʬ 1/cosա/ߦˤѤ
  ! xy_GradLat_w    :: ڥȥǡ˸۷ʬ/ߦդѤ
  ! w_DivLon_xy     :: ʻҥǡȯʬ 1/cosա/ߦˤѤ
  ! w_DivLat_xy     :: ʻҥǡ
  !                    ȯʬ 1/cosա(g cos)/ߦդѤ
  ! w_Div_xy_xy     :: ٥ȥʬǤ 2 ĤγʻҥǡȯѤ
  ! w_Jacobian_w_w  :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  !
  !==== ʬ(,=sin ɸ)
  !
  ! xy_GradLambda_w :: ڥȥǡ˸۷ʬ/ߦˤѤ
  ! xy_GradMu_w     :: ڥȥǡ
  !                    ۷ʬ (1-^2)/ߦ̤Ѥ
  ! w_DivLambda_xy  :: ʻҥǡ
  !                    ȯʬ 1/(1-^2)/ߦˤѤ
  ! w_DivMu_xy      :: ʻҥǡȯʬ/ߦ̤Ѥ
  !
  !==== 
  !
  ! Interpolate_w :: ڥȥǡǤդǤͤ. 
  !
  !==== ʬʿ
  !
  ! IntLonLat_xy, AvrLonLat_xy :: 2 ʻǡΰʬʿ
  ! y_IntLon_xy, y_AvrLon_xy   :: 2 ʻǡηʬʿ
  ! IntLon_x, AvrLon_x         :: 1 (X)ʻǡηʬʿ
  ! x_IntLat_xy, x_AvrLat_xy   :: 2 ʻǡΰʬʿ
  ! IntLat_y, AvrLat_y         :: 1 (Y)ʻǡΰʬʿ
  !
  !==== ڥȥ
  !
  ! nm_EnergyFromStreamfunc_w  :: ήؿ饨ͥ륮ڥȥ׻
  !                               (ʿȿ n, Ӿȿ m )
  ! n_EnergyFromStreamfunc_w   :: ήؿ饨ͥ륮ڥȥ׻
  !                               (ʿȿ n ) 
  ! nm_EnstrophyFromStreamfunc_w  :: ήؿ饨󥹥ȥեڥȥ
  !                                  ׻ (ʿȿ n, Ӿȿ m )
  ! n_EnstrophyFromStreamfunc_w   :: ήؿ饨󥹥ȥեڥȥ
  !                                  ׻ (ʿȿ n )
  ! w_spectrum_VMiss              ::  »
  !
  !
  use w_base_module
  use w_deriv_module

  private

  public w_Initial                            ! 

  public x_Lon, y_Lat                         ! ʻҺɸ
  public x_Lon_weight, y_Lat_Weight           ! ʻҺɸŤ
  public xy_Lon, xy_Lat                       ! ʻҺɸ(im,jm)
  public xy_w, w_xy, l_nm, nm_l               ! Ѵؿ

  public rn, irm                              ! ץ饷/ʬ黻
  public w_Lapla_w, w_LaplaInv_w              ! ץ饷ȵձ黻
  public w_DLon_w                             ! ʬ
  public xy_GradLon_w, xy_GradLat_w           ! ۷ʬ
  public w_DivLon_xy, w_DivLat_xy             ! ȯʬ
  public w_Div_xy_xy                          ! ȯʬ
  public w_Jacobian_w_w                       ! 䥳ӥ
  public xy_GradLambda_w, xy_GradMu_w         ! ۷ʬ(,̺ɸ)
  public w_DivLambda_xy, w_DivMu_xy           ! ȯʬ(,̺ɸ)

  public Interpolate_w                        ! ִؿ

  public IntLonLat_xy                         ! ٷʬ
  public y_IntLon_xy, IntLon_x                ! ʬ    
  public x_IntLat_xy, IntLat_y                ! ʬ    
  public AvrLonLat_xy                         ! ٷʿ
  public y_AvrLon_xy, AvrLon_x                ! ʿ    
  public x_AvrLat_xy, AvrLat_y                ! ʿ    

  public nm_EnergyFromStreamfunc_w            ! ͥ륮ڥȥ           
                                              ! (ʿȿ n, Ӿȿ m )
  public n_EnergyFromStreamfunc_w             ! ͥ륮ڥȥ
                                              ! (ʿȿ n ) 
  public nm_EnstrophyFromStreamfunc_w         ! 󥹥ȥեڥȥ     
                                              ! (ʿȿ n, Ӿȿ m )
  public n_EnstrophyFromStreamfunc_w          ! 󥹥ȥեڥȥ  
                                              !  (ʿȿ n )
  public w_spectrum_VMiss                     ! »

contains

  !---------------  -----------------
    subroutine w_initial(n_in,i_in,j_in,np_in)
      !
      ! ڥȥѴγʻ, ȿ OPENMP ѻ
      ! 祹åɿꤹ.
      !
      ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
      ! ʤФʤʤ. 
      !
      ! np_in  1 礭ͤꤹ ISPACK εĴȡѴ 
      ! OPENMP ׻롼Ѥ. ׻¹Ԥˤ, 
      ! ¹Ի˴Ķѿ OMP_NUM_THREADS  np_in ʲοꤹ
      ! ƥ˱ɬפȤʤ. 
      !
      ! np_in  1 礭ͤꤷʤ׻롼ϸƤФʤ.
      !
      integer,intent(in) :: i_in              !(in) ʻ()
      integer,intent(in) :: j_in              !(in) ʻ()
      integer,intent(in) :: n_in              !(in) ȿ
      integer,intent(in), optional :: np_in   !(in) OPENMP Ǥκ祹åɿ

!      integer iw

      if ( present (np_in) )then
         call w_base_initial(n_in,i_in,j_in,np_in)
      else
         call w_base_initial(n_in,i_in,j_in)
      endif

      call w_deriv_initial

    end subroutine w_initial

end module w_module
