! -*- coding: utf-8; mode: f90 -*-
!-------------------------------------------------------------------------------------
! Copyright (c) 2000-2016 Gtool Development Group. All rights reserved.
!-------------------------------------------------------------------------------------
! ** Important**
!
! This file is generated from gtvarputnum.erb by ERB included Ruby 2.3.1.
! Please do not edit this file directly. @see "gtvarputnum.erb"
!-------------------------------------------------------------------------------------
!
!== 変数への数値データの出力
!
! 変数 *var* へ数値データ *value* が出力されます。
! *nvalue* には配列長を代入する必要があります。
!
! 数値データ出力の際にエラーが生じた場合、メッセージを出力
! してプログラムは強制終了します。*err* を与えてある場合には
! の引数に .true. が返り、プログラムは終了しません。
!
! 出力しようとするデータの型が *var* の型と異なる場合、データは *var* の
! 型に変換されます。 この変換は netCDF の機能を用いています。
! 詳しくは {netCDF 日本語版マニュアル}[link:../xref.htm#label-10]
! の 3.3 型変換 を参照してください。
!
! *Get* は複数のサブルーチンの総称名であり、
! *value* に多次元配列を与えることも可能です。上記の
! サブルーチンを参照してください。
!
subroutine GTVarPutDouble(var, value, nvalue, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_internal_map, only: &
    & var_class, &
    & vtb_class_netcdf, &
    & map_to_internal_specs
  use gtdata_netcdf_generic,  only: put
  use gtdata_netcdf_types, only: GD_NC_VARIABLE
  use dc_error,    only: StoreError, GT_EFAKE
  ! use dc_trace,    only: BeginSub, EndSub
  use dc_types,    only: DP
  implicit none
  type(GT_VARIABLE), intent(in)            :: var
  integer,           intent(in)            :: nvalue
  real(DP),          intent(in)            :: value(nvalue)
  logical,           intent(out), optional :: err
  ! Variables for Intenal work
  integer:: class, cid, stat, ndims
  integer, pointer:: specs(:, :)
  character(len = *), parameter:: subname = "GTVarPutDouble"
  continue
  call var_class(var, class, cid)
  call map_to_internal_specs(var, specs, ndims)
  if (class == vtb_class_netcdf) then
    call put(GD_NC_VARIABLE(cid), start=specs(:, 1), count=specs(:, 2), &
      & stride=specs(:, 3), imap=specs(:, 4), value=value, &
      & siz=nvalue, iostat=stat)
  else
    stat = gt_efake
  endif
  call StoreError(stat, subname, err=err)
  deallocate(specs)
end subroutine GTVarPutDouble

subroutine GTVarPutReal(var, value, nvalue, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_internal_map, only: &
    & var_class, &
    & vtb_class_netcdf, &
    & map_to_internal_specs
  use gtdata_netcdf_generic,  only: put
  use gtdata_netcdf_types, only: GD_NC_VARIABLE
  use dc_error,    only: StoreError, GT_EFAKE
  ! use dc_trace,    only: BeginSub, EndSub
  use dc_types,    only: SP
  implicit none
  type(GT_VARIABLE), intent(in)            :: var
  integer,           intent(in)            :: nvalue
  real(SP),          intent(in)            :: value(nvalue)
  logical,           intent(out), optional :: err
  ! Variables for Intenal work
  integer:: class, cid, stat, ndims
  integer, pointer:: specs(:, :)
  character(len = *), parameter:: subname = "GTVarPutReal"
  continue
  call var_class(var, class, cid)
  call map_to_internal_specs(var, specs, ndims)
  if (class == vtb_class_netcdf) then
    call put(GD_NC_VARIABLE(cid), start=specs(:, 1), count=specs(:, 2), &
      & stride=specs(:, 3), imap=specs(:, 4), value=value, &
      & siz=nvalue, iostat=stat)
  else
    stat = gt_efake
  endif
  call StoreError(stat, subname, err=err)
  deallocate(specs)
end subroutine GTVarPutReal

subroutine GTVarPutInt(var, value, nvalue, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_internal_map, only: &
    & var_class, &
    & vtb_class_netcdf, &
    & map_to_internal_specs
  use gtdata_netcdf_generic,  only: put
  use gtdata_netcdf_types, only: GD_NC_VARIABLE
  use dc_error,    only: StoreError, GT_EFAKE
  ! use dc_trace,    only: BeginSub, EndSub
  implicit none
  type(GT_VARIABLE), intent(in)            :: var
  integer,           intent(in)            :: nvalue
  integer,           intent(in)            :: value(nvalue)
  logical,           intent(out), optional :: err
  ! Variables for Intenal work
  integer:: class, cid, stat, ndims
  integer, pointer:: specs(:, :)
  character(len = *), parameter:: subname = "GTVarPutInt"
  continue
  call var_class(var, class, cid)
  call map_to_internal_specs(var, specs, ndims)
  if (class == vtb_class_netcdf) then
    call put(GD_NC_VARIABLE(cid), start=specs(:, 1), count=specs(:, 2), &
      & stride=specs(:, 3), imap=specs(:, 4), value=value, &
      & siz=nvalue, iostat=stat)
  else
    stat = gt_efake
  endif
  call StoreError(stat, subname, err=err)
  deallocate(specs)
end subroutine GTVarPutInt

subroutine GTVarPutChar(var, value, nvalue, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_internal_map, only: &
    & var_class, &
    & vtb_class_netcdf, &
    & map_to_internal_specs
  use gtdata_netcdf_generic,  only: put
  use gtdata_netcdf_types, only: GD_NC_VARIABLE
  use dc_error,    only: StoreError, GT_EFAKE
  ! use dc_trace,    only: BeginSub, EndSub
  implicit none
  type(GT_VARIABLE), intent(in)            :: var
  integer,           intent(in)            :: nvalue
  character(*),      intent(in)            :: value(nvalue)
  logical,           intent(out), optional :: err
  ! Variables for Intenal work
  integer:: class, cid, stat, ndims
  integer, pointer:: specs(:, :)
  character(len = *), parameter:: subname = "GTVarPutChar"
  continue
  call var_class(var, class, cid)
  call map_to_internal_specs(var, specs, ndims)
  if (class == vtb_class_netcdf) then
    call put(GD_NC_VARIABLE(cid), start=specs(:, 1), count=specs(:, 2), &
      & stride=specs(:, 3), imap=specs(:, 4), value=value, &
      & siz=nvalue, iostat=stat)
  else
    stat = gt_efake
  endif
  call StoreError(stat, subname, err=err)
  deallocate(specs)
end subroutine GTVarPutChar


subroutine GTVarPutDouble1(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutDouble
  use dc_types,       only: DP
  real(DP), intent(in) :: value(:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutDouble(var, value, size(value), err)
end subroutine GTVarPutDouble1

subroutine GTVarPutDouble2(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutDouble
  use dc_types,       only: DP
  real(DP), intent(in) :: value(:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutDouble(var, value, size(value), err)
end subroutine GTVarPutDouble2

subroutine GTVarPutDouble3(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutDouble
  use dc_types,       only: DP
  real(DP), intent(in) :: value(:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutDouble(var, value, size(value), err)
end subroutine GTVarPutDouble3

subroutine GTVarPutDouble4(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutDouble
  use dc_types,       only: DP
  real(DP), intent(in) :: value(:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutDouble(var, value, size(value), err)
end subroutine GTVarPutDouble4

subroutine GTVarPutDouble5(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutDouble
  use dc_types,       only: DP
  real(DP), intent(in) :: value(:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutDouble(var, value, size(value), err)
end subroutine GTVarPutDouble5

subroutine GTVarPutDouble6(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutDouble
  use dc_types,       only: DP
  real(DP), intent(in) :: value(:,:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutDouble(var, value, size(value), err)
end subroutine GTVarPutDouble6

subroutine GTVarPutDouble7(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutDouble
  use dc_types,       only: DP
  real(DP), intent(in) :: value(:,:,:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutDouble(var, value, size(value), err)
end subroutine GTVarPutDouble7

subroutine GTVarPutReal1(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutReal
  use dc_types,       only: SP
  real(SP), intent(in) :: value(:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutReal(var, value, size(value), err)
end subroutine GTVarPutReal1

subroutine GTVarPutReal2(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutReal
  use dc_types,       only: SP
  real(SP), intent(in) :: value(:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutReal(var, value, size(value), err)
end subroutine GTVarPutReal2

subroutine GTVarPutReal3(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutReal
  use dc_types,       only: SP
  real(SP), intent(in) :: value(:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutReal(var, value, size(value), err)
end subroutine GTVarPutReal3

subroutine GTVarPutReal4(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutReal
  use dc_types,       only: SP
  real(SP), intent(in) :: value(:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutReal(var, value, size(value), err)
end subroutine GTVarPutReal4

subroutine GTVarPutReal5(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutReal
  use dc_types,       only: SP
  real(SP), intent(in) :: value(:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutReal(var, value, size(value), err)
end subroutine GTVarPutReal5

subroutine GTVarPutReal6(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutReal
  use dc_types,       only: SP
  real(SP), intent(in) :: value(:,:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutReal(var, value, size(value), err)
end subroutine GTVarPutReal6

subroutine GTVarPutReal7(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutReal
  use dc_types,       only: SP
  real(SP), intent(in) :: value(:,:,:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutReal(var, value, size(value), err)
end subroutine GTVarPutReal7

subroutine GTVarPutInt1(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutInt
  integer,  intent(in) :: value(:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutInt(var, value, size(value), err)
end subroutine GTVarPutInt1

subroutine GTVarPutInt2(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutInt
  integer,  intent(in) :: value(:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutInt(var, value, size(value), err)
end subroutine GTVarPutInt2

subroutine GTVarPutInt3(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutInt
  integer,  intent(in) :: value(:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutInt(var, value, size(value), err)
end subroutine GTVarPutInt3

subroutine GTVarPutInt4(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutInt
  integer,  intent(in) :: value(:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutInt(var, value, size(value), err)
end subroutine GTVarPutInt4

subroutine GTVarPutInt5(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutInt
  integer,  intent(in) :: value(:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutInt(var, value, size(value), err)
end subroutine GTVarPutInt5

subroutine GTVarPutInt6(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutInt
  integer,  intent(in) :: value(:,:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutInt(var, value, size(value), err)
end subroutine GTVarPutInt6

subroutine GTVarPutInt7(var, value, err)
  use gtdata_types,   only: GT_VARIABLE
  use gtdata_generic, only: Put, GTVarPutInt
  integer,  intent(in) :: value(:,:,:,:,:,:,:)
  type(GT_VARIABLE), intent(inout):: var
  logical  ,intent(out), optional:: err
  continue
  call GTVarPutInt(var, value, size(value), err)
end subroutine GTVarPutInt7

