!--
!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_spectrum_module_sjpack_cuda
!
!  spml/wa_spectrum_module_sjpack_cuda ⥸塼ϵ̾Ǥήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 wa_module_sjpack_cuda β⥸塼Ǥ, 
!  ڥȥϷ׻Τ Fortran90 ؿ󶡤. 
!
!  ̾ 1 إǥ w_spectrum_module_sjpack_cuda ⥸塼
!  ¿إǥѤ˳ĥΤǤ, ƱʣĤΥڥȥǡ, 
!  ʻǡФѴԤ.
!
!   ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2011/03/12  ݹ wa_spectrum_module_sjpackk  CUDA Ѥ˲¤
!
!++
module wa_spectrum_module_sjpack_cuda
  !
  != wa_spectrum_module_sjpack_cuda
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wa_spectrum_module_sjpack_cuda.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  !  spml/wa_spectrum_module_sjpack_cuda ⥸塼ϵ̾Ǥήαư
  !  ĴȡѤڥȥˡˤäƿͷ׻뤿 
  !  ⥸塼 wa_module_sjpack_cuda β⥸塼Ǥ, 
  !  ڥȥϷ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ̾ 1 إǥ w_spectrum_module_sjpack_cuda ⥸塼
  !  ¿إǥѤ˳ĥΤǤ, ƱʣĤΥڥȥǡ, 
  !  ʻǡФѴԤ.
  !
  !   ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use w_base_module_sjpack_cuda, only : nm=>nn, l_nm

  implicit none

  private
 
  public nma_EnergyFromStreamfunc_wa      ! ͥ륮ڥȥ
                                          ! (ʿȿ n, Ӿȿ m )
  public na_EnergyFromStreamfunc_wa       ! ͥ륮ڥȥ
                                          ! (ʿȿ n )
  public nma_EnstrophyFromStreamfunc_wa   ! 󥹥ȥեڥȥ
                                          ! (ʿȿ n, Ӿȿ m )
  public na_EnstrophyFromStreamfunc_wa    ! 󥹥ȥեڥȥ
                                          !  (ʿȿ n )
  public wa_spectrum_VMiss                ! »

  real(8) :: wa_spectrum_VMiss = -999.000 ! »ͽ

  contains

  !--------------- ͥ륮ڥȥ׻ -----------------
    function nma_EnergyFromStreamfunc_wa(wa_Strfunc)
      ! 
      ! ήؿΥڥȥǡ饨ͥ륮εĴȡʬ
      ! (ڥȥ)׻(¿).
      !
      !  * ȿ n, Ӿȿ m ήؿΥڥȥʬ(n,m) 
      !    ͥ륮ڥȥ (1/2)n(n+1)|(n,m)|^2 ȷ׻.
      !
      !  * ڥȥ (n,m) ʬȿ n, ȿ m μʬ, 
      !    (n,-m) ʬȿ n, ȿ m εʬǼƤ.
      !
      !  * ƤΥͥ륮ڥȥʬ¤4Ф򤫤Τ̾Ǥ
      !    ͥ륮.
      !
      !  * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !    »ͤͤϥ⥸塼ѿ w_spectrum_VMiss ˤäǤ
      !    (ͤ -999.0)
      !
      real(8), intent(in)   :: wa_Strfunc(:,:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,-nm:nm,size(wa_Strfunc,2)) &
           :: nma_EnergyFromStreamfunc_wa
      !(out) ͥ륮ڥȥ(ʿȿ n, Ӿȿ m )

      integer n,m                             ! DO ѿ

      nma_EnergyFromStreamfunc_wa = wa_spectrum_VMiss

      do n=0,nm
         nma_EnergyFromStreamfunc_wa(n,0,:) &
                 = 0.5 * n*(n+1) * wa_Strfunc(l_nm(n,0),:)**2
         do m=1,n
             nma_EnergyFromStreamfunc_wa(n,m,:) &
                 = 0.5 * n*(n+1) * (  wa_Strfunc(l_nm(n,m),:)**2 &
                                    + wa_Strfunc(l_nm(n,-m),:)**2 )
             nma_EnergyFromStreamfunc_wa(n,-m,:) &
                  = nma_EnergyFromStreamfunc_wa(n,m,:)
         enddo
      enddo
    end function nma_EnergyFromStreamfunc_wa

    function na_EnergyFromStreamfunc_wa(wa_Strfunc)
      !
      ! ήؿΥڥȥǡȿΥͥ륮ʬ(ڥȥ)
      ! ׻(¿).
      !
      !  * ȿ n ήؿΥڥȥʬ(n,m) 
      !    ͥ륮ڥȥϦ[m=-nm]^nm(1/2)n(n+1)|(n,m)|^2 
      !    ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ 4Ф򤫤Τ
      !    ̾Ǥͥ륮.
      !
      real(8), intent(in)   :: wa_Strfunc(:,:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,size(wa_Strfunc,2)) &
           :: na_EnergyFromStreamfunc_wa
      !(out) ͥ륮ڥȥ (ʿȿ n ) 

      integer n,m                            ! DO ѿ
  
      do n=0,nm
         na_EnergyFromStreamfunc_wa(n,:) = &
                0.5 * n*(n+1) * wa_StrFunc(l_nm(n,0),:)**2
         do m=1,n
            na_EnergyFromStreamfunc_wa(n,:) = na_EnergyFromStreamfunc_wa(n,:)+ &
                2 * 0.5 * n*(n+1) &
                * (wa_StrFunc(l_nm(n,m),:)**2+wa_StrFunc(l_nm(n,-m),:)**2)
         enddo
      enddo

    end function na_EnergyFromStreamfunc_wa

  !--------------- 󥹥ȥեڥȥ׻ -----------------

    function nma_EnstrophyFromStreamfunc_wa(wa_Strfunc)  ! 
      !
      ! ήؿΥڥȥǡ饨󥹥ȥեεĴȡʬ
      ! (ڥȥ)׻(¿). 
      !
      ! * ȿ n, Ӿȿ m ήؿΥڥȥʬ(n,m) 
      !    󥹥ȥեڥȥ (1/2)n^2(n+1)^2|(n,m)|^2 ȷ׻.
      !
      ! * ƤΥ󥹥ȥեڥȥʬ¤4/R^2򤫤Τ
      !   ̾Ǥ󥹥ȥե.  R ϵ̤Ⱦ¤Ǥ.
      !
      ! * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !   »ͤͤϥ⥸塼ѿ w_spectrum_VMiss ˤäǤ
      !   (ͤ -999.0)
      !
      real(8), intent(in)   :: wa_Strfunc(:,:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,-nm:nm,size(wa_Strfunc,2)) &
           :: nma_EnstrophyFromStreamfunc_wa
      ! 󥹥ȥեڥȥ (ʿȿ n, Ӿȿ m )

      integer n,m                             ! DO ѿ

      nma_EnstrophyFromStreamfunc_wa = wa_spectrum_VMiss

      do n=0,nm
         nma_EnstrophyFromStreamfunc_wa(n,0,:) &
                 = 0.5 * n**2 * (n+1)**2 &
                    * wa_Strfunc(l_nm(n,0),:)**2
         do m=1,n
            nma_EnstrophyFromStreamfunc_wa(n,m,:) &
                 = 0.5 * n**2 * (n+1)**2 &
                    * (wa_Strfunc(l_nm(n,m),:)**2+wa_Strfunc(l_nm(n,-m),:)**2)
            nma_EnstrophyFromStreamfunc_wa(n,-m,:) &
                 = nma_EnstrophyFromStreamfunc_wa(n,m,:)
         enddo
      enddo
    end function nma_EnstrophyFromStreamfunc_wa

    function na_EnstrophyFromStreamfunc_wa(wa_Strfunc)  ! 
      !
      ! ήؿΥڥȥǡȿΥͥ륮ʬ(ڥȥ)
      ! ׻(¿)
      !
      ! * ȿ n ήؿΥڥȥʬ(n,m) 饨󥹥ȥե
      !   ڥȥϦ[m=-nm]^nm(1/2)n^2(n+1)^2|(n,m)|^2 ȷ׻.
      !    
      ! * ƤΥͥ륮ڥȥʬ¤ 4/R^2 򤫤Τ
      !   ̾Ǥ󥹥ȥե.
      !
      real(8), intent(in)   :: wa_Strfunc(:,:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,size(wa_Strfunc,2)) &
           :: na_EnstrophyFromStreamfunc_wa      ! 󥹥ȥեڥȥ
      !(out) 󥹥ȥեڥȥ(ʿȿ n )

      integer n,m                                ! DO ѿ

      do n=0,nm
         na_EnstrophyFromStreamfunc_wa(n,:)  &
              = 0.5 * n**2 * (n+1)**2 * wa_StrFunc(l_nm(n,0),:)**2
         do m=1,n
            na_EnstrophyFromStreamfunc_wa(n,:) &
               =  na_EnstrophyFromStreamfunc_wa(n,:) &
               + 2* 0.5 * n**2 * (n+1)**2 &
                * (wa_StrFunc(l_nm(n,m),:)**2+wa_StrFunc(l_nm(n,-m),:)**2)
         enddo
      enddo

    end function na_EnstrophyFromStreamfunc_wa

end module wa_spectrum_module_sjpack_cuda
