!--
!----------------------------------------------------------------------
! Copyright (c) 2009-2013 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  l_module_sjpack
!
!   spml/l_module_sjpack ⥸塼ϵ̾Ǥη˰ͤӾŪ 
!   1 ήαư른ɥ¿༰Ѥڥȥˡˤä
!   ͷ׻뤿 Fortran90 ؿ󶡤. 
!
!    ISPACK  SJPACK  Fortran77 ֥롼ƤǤ.
!   ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!   ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
!
!   ؿ, ֥롼̾ȵǽ l_module ΤΤƱ߷פƤ. 
!   ä use ʸ l_module  l_module_sjpack ѹ 
!   SJPACK εǽȤ褦ˤʤ. 
!
!  2009/09/22  ݹ  l_module 򸵤 SJPACK Ѥ˲¤
!      2010/09/22  ݹ  
!      2013/02/24  ݹ  l_Finalize Ƴ
!
!++
module l_module_sjpack
  !
  != l_module_sjpack
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: l_module_sjpack.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  !   spml/l_module_sjpack ⥸塼ϵ̾Ǥη˰ͤӾŪ 
  !   1 ήαư른ɥ¿༰Ѥڥȥˡˤä
  !   ͷ׻뤿 Fortran90 ؿ󶡤. 
  !
  !    ISPACK  SJPACK  Fortran77 ֥롼ƤǤ.
  !   ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !   ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  !   ؿ, ֥롼̾ȵǽ l_module ΤΤƱ߷פƤ. 
  !   ä use ʸ l_module  l_module_sjpack ѹ 
  !   SJPACK εǽȤ褦ˤʤ. 
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (l_, y_) , ֤ͤη򼨤Ƥ.
  !   l_ :: ڥȥ(른ɥ¿༰ʬ)ǡ
  !   y_ :: 1 ٳʻǡ
  !
  ! * ؿ̾δ֤ʸ(GradLat, DivLat, Lapla, LaplaInv), 
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_l, _y) , ѿηڥȥǡ
  !   ӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _l :: ڥ(른ɥ¿༰ʬ)ǡ
  !   _y ::  1 ʻǡ
  !
  !=== ƥǡμ
  !
  ! * p : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(0:nn). 
  !   * nn ϥ른ɥ¿༰κ缡Ǥ, ֥롼 l_Initial ˤ
  !     餫ꤷƤ. 
  !
  ! * y :  1 ʻǡ.
  !   * ѿμȼ real(8), dimension(1:jm).
  !
  ! * l_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !
  !== ѿ³
  !
  !====  
  !
  ! l_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! 
  !==== λ 
  !
  ! l_Finalize :: ⥸塼νλ(դβ)򤪤ʤ. 
  ! 
  !==== ɸѿ
  !
  ! y_Lat        ::  ʻɸ(, ٺɸ)Ǽ 1 
  ! y_Lat_Weight ::  ŤߺɸǼ 1 
  !
  !==== Ѵ
  !
  ! y_l :: ڥȥǡʻҥǡؤѴ
  ! l_y :: ʻҥǡ饹ڥȥǡؤѴ
  !
  !==== ʬ
  !
  ! l_Lapla_l       :: ڥȥǡ˥ץ饷Ѥ
  ! l_LaplaInv_l    :: ڥȥǡ˥ץ饷εѴѤ
  ! y_GradLat_l     :: ڥȥǡ˸۷ʬ/ߦդѤ
  ! l_DivLat_y      :: ʻҥǡȯʬ
  !                    1 /cosա(g cos)/ߦդѤ
  !
  !==== ʬ(,=sin ɸ)
  !
  ! y_GradMu_l     :: ڥȥǡ
  !                   ۷ʬ (1-^2)/ߦ̤Ѥ
  ! l_DivMu_y      :: ʻҥǡȯʬ/ߦ̤Ѥ
  !
  !==== 
  !
  ! Interpolate_l  :: ڥȥǡǤդǤͤ. 
  !
  !==== ʬʿ
  !
  ! IntLat_y, AvrLat_y :: 1 (Y)ʻǡΰʬʿ
  !
  !==== ڥȥ
  !
  ! 
  !
  use dc_message, only : MessageNotify

  implicit none

  private

  public l_Initial                            ! 
  public l_Finalize                           ! λ

  public y_Lat                                ! ʻҺɸ
  public y_Lat_Weight                         ! ʻҺɸŤ

  public y_l, l_y                             ! Ѵؿ
  public l_Lapla_l, l_LaplaInv_l              ! ץ饷ȵձ黻
  public y_GradLat_l                          ! ۷ʬ
  public l_DivLat_y                           ! ȯʬ

  public y_GradMu_l                           ! ۷ʬ
  public l_DivMu_y                            ! ȯʬ

  public IntLat_y, AvrLat_y                   ! ʿ

  public Interpolate_l                        ! ַ׻

  integer               :: jm=32            ! ʻ()
  integer               :: nm=21            ! ׻ȿ
  integer               :: nn=22            ! ȿ(ȿ)
  integer               :: mm=0             ! ȿ(ȿ)

  real(8), allocatable  :: p(:,:), r(:)     ! Ѵ
  real(8), allocatable  :: c(:)             ! ʬ

  real(8), allocatable  :: y_Lat(:)         ! ٷ
  real(8), allocatable  :: y_Lat_Weight(:)  ! ɸŤ

  logical               :: l_initialize = .false.  ! ե饰

  save jm, nm, nn, mm, p, r, c, y_Lat, y_Lat_Weight, l_initialize

contains

  !---------------  -----------------
    subroutine l_initial(n_in,j_in)
      !
      ! ڥȥѴγʻ, ȿꤹ.
      !
      ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
      ! ʤФʤʤ. 
      !
      integer,intent(in) :: j_in              !(in) ʻ()
      integer,intent(in) :: n_in              !(in) ȿ

      integer :: j

      jm = j_in ; nn = n_in ; nm = n_in+1 ; mm = 1

      allocate(p(jm/2,mm+4))                  ! Ѵ
      allocate(r((mm+1)*(2*nm-mm-1)+1))       ! Ѵ
      allocate(c(2*nn+1))                     ! ʬ

      allocate(y_Lat(jm),y_Lat_Weight(jm))      ! ɸѿ

      call ljinit(mm,nm,jm,p,r)

      call ljinic(nn,c)

      do j=1,jm/2
         y_Lat(jm/2+j)   =  asin(p(j,1))        ! ٺɸ
         y_Lat(jm/2-j+1) = -asin(p(j,1))        ! ٺɸ
         y_Lat_Weight(jm/2+j)   = 2*p(j,2)      ! ٽŤ(Gauss grid)
         y_Lat_Weight(jm/2-j+1) = 2*p(j,2)      ! ٽŤ(Gauss grid)
      enddo

      l_initialize = .true.

      call MessageNotify(&
        'M','l_initial','l_module_sjpack (2013/02/24) is initialized')

    end subroutine l_initial

  !--------------- Ѵ -----------------
    function y_l(l_data)
      !
      ! ڥȥǡʻҥǡѴ(1 ).
      !
      real(8)               :: y_l(1:jm)
      !(out) ʻǡ

      real(8), intent(in)   :: l_data(0:nn)
      !(in) ڥȥǡ

      real(8)  :: q(jm/2*5)                ! ѴѺ
      real(8)  :: ws(nn+1)                 ! ѴѺ

      call ljtszg(nm,nn,jm,l_data,y_l,p,q,r,ws,0)

    end function y_l

    function l_y(y_data)
      !
      ! ڥȥǡʻҥǡѴ(1 ).
      !
      real(8)               :: l_y(0:nn)
      !(in) ڥȥǡ

      real(8), intent(in)   :: y_data(1:jm)
      !(in) ʻǡ


      real(8)  :: q(jm/2*5)               ! ѴaѺ
      real(8)  :: ws(nn+1)                ! ѴѺ

      call ljtgzs(nm,nn,jm,l_y,y_data,p,q,r,ws,0)

    end function l_y


  !--------------- ʬ׻ -----------------
    function l_Lapla_l(l_data)
      !
      ! ϥڥȥǡ˥ץ饷
      !
      !    ^2 = 1/cosա/ߦ(cosբ/ߦ)
      !
      ! Ѥ. 
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8)              :: l_Lapla_l(0:nn)
      !(out) ϥڥȥǡΥץ饷

      real(8), intent(in)  :: l_data(0:nn)
      !(in) ϥڥȥǡ

      integer :: n

      do n=0,nn
         l_Lapla_l(n) = -n*(n+1)*l_data(n)
      enddo

    end function l_Lapla_l

    function l_LaplaInv_l(l_data)
      !
      ! ϥڥȥǡ˵եץ饷
      !
      !    ^{-2}
      !      =[1/cosա/ߦ(cosբ/ߦ)]^{-1}
      !
      ! Ѥ. 
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8)              :: l_LaplaInv_l(0:nn)
      !(out) ڥȥǡεեץ饷

      real(8), intent(in)  :: l_data(0:nn)
      !(in) ϥڥȥǡ

      integer ::  n

      l_LaplaInv_l(0) = 0.0D0
      do n=1,nn
         l_LaplaInv_l(n) = -l_data(n)/(n*(n+1))
      enddo

    end function l_LaplaInv_l

    function y_GradLat_l(l_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(1 ).
      !
      real(8)              :: y_GradLat_l(1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: l_data(0:nn)
      !(in) ϥڥȥǡ

      real(8)              :: work(0:nn+1)
      ! ȥڥȥǡ

      real(8)  :: q(jm/2*5)                ! ѴѺ
      real(8)  :: ws(nn+2)                 ! ѴѺ

      call ljcszy(nn,l_data,work,c)
      call ljtszg(nm,nn+1,jm,work,y_GradLat_l,p,q,r,ws,1)

    end function y_GradLat_l

    function l_DivLat_y(y_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤. 
      !
      real(8)              :: l_DivLat_y(0:nn)
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: y_data(1:jm)
      !(in) ϳʻǡ

      real(8)              :: work(0:nn+1)
      ! ȥڥȥǡ

      real(8)  :: q(jm/2*5)                ! ѴѺ
      real(8)  :: ws(nn+2)                 ! ѴѺ

      call ljtgzs(nm,nn+1,jm,work,y_data,p,q,r,ws,1)
      call ljcyzs(nn,work,l_DivLat_y,c)

    end function l_DivLat_y

  !--------------- ʬ׻ (̺ɸ) -----------------
    function y_GradMu_l(l_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤. 
      !
      real(8)              :: y_GradMu_l(1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: l_data(0:nm)
      !(in) ϥڥȥǡ

      y_GradMu_l = y_GradLat_l(l_data)*cos(y_Lat)

    end function y_GradMu_l

    function l_DivMu_y(y_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: l_DivMu_y(0:nn)
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: y_data(1:jm)
      !(in) ϳʻǡ

      l_DivMu_y = l_DivLat_y(y_data/cos(y_Lat))

    end function l_DivMu_y

  !--------------- ʬ׻ -----------------
    function IntLat_y(y_data)
      !
      ! 1 (Y)ʻǡ Y ʬ.
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: y_data(1:jm)    !(in)  1 (Y)ʻǡ
      real(8)             :: IntLat_y        !(out) ʬ

      IntLat_y = sum(y_data * y_Lat_weight)

    end function IntLat_y

  !--------------- ʿѷ׻ -----------------
    function AvrLat_y(y_data)
      !
      ! 1 (Y)ʻǡΰ(Y)ʿ.
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: y_data(1:jm)    !(in)  1 ٳʻǡ
      real(8)             :: AvrLat_y        !(out) ʿ

      AvrLat_y = IntLat_y(y_data)/sum(y_Lat_weight)

    end function AvrLat_y

  !--------------- ַ׻ -----------------    
    function Interpolate_l(l_data,alat)
      !
      !  alat ˤؿͤ
      ! Υ른ɥѴ l_data ַ׻
      !
      real(8), intent(IN) :: l_data(0:nn)           ! ڥȥǡ
      real(8), intent(IN) :: alat                   ! ֤()
      real(8)             :: Interpolate_l          ! ֤
      
      real(8) :: mu
      real(8) :: y0, y1, y2
      integer :: k

      mu = sin(alat)
      Interpolate_l = 0.0D0

      !---- a_n^0 L_n^0 η׻
      y2 = 0 ; y1 = 0
      do k=nn,1,-1
         y0 = alpha(k,mu) * y1 + beta(k+1)*y2 + l_data(k)
         y2 = y1 ; y1 = y0
      enddo
      Interpolate_l = beta(1) * y2 + mu*sqrt(3.0D0) * y1 + l_data(0) 

    end function Interpolate_l

  !--------------- 롼 -----------------
    function alpha(n,x)
      !
      !   P_n η
      !
      integer, intent(IN) :: n
      real(8), intent(IN) :: x
      real(8)             :: alpha

      alpha = sqrt( (2.0D0*n+3)*(2.0D0*n+1)/((n+1)*(n+1)) ) * x
    end function alpha

    function beta(n)
      !
      !   P_{n-1} η
      !
      integer, intent(IN) :: n
      real(8)             :: beta

      beta = - sqrt( (2.0D0*n+3)*n*n/((2*n-1)*(n+1)*(n+1)) )
    end function beta

  !--------------- λ -----------------
    subroutine l_Finalize
      !
      ! ⥸塼νλ(դβ)򤪤ʤ. 
      !
      ! ٤ѹݤˤϤΥ֥롼Ƥǽλ
      ! ʤäΤ˺ l_Initial ǽꤷʤ
      ! ʤʤ. 
      !
      if ( .not. l_initialize ) then
         call MessageNotify('W','l_finalize',&
              'l_module_sjpack not initialized yet')
         return
      endif

      deallocate(p)                     ! Ѵ
      deallocate(r)                     ! Ѵ
      deallocate(c)                     ! ʬ

      deallocate(y_Lat,y_Lat_Weight)    ! ɸѿ

      l_initialize = .false.

      call MessageNotify('M','l_finalize',&
           'l_module_sjpack (2013/02/24) is finalized')

    end subroutine l_Finalize

end module l_module_sjpack
