$LOAD_PATH.unshift("../lib/")
require "numru/gphys/gphys.rb"
require "test/unit"
include NumRu
include NMath

class AssocCoordsTest < Test::Unit::TestCase
  def setup
    #@nx = 10
    #@ny = 7
    @nx = 5
    @ny = 3
    @nz = 2
    @nt = 2
    x = (NArray.sfloat(@nx).indgen! + 0.5) * (2*PI/@nx)
    y = NArray.sfloat(@ny).indgen! * (2*PI/(@ny-1))
    z = NArray.sfloat(@nz).indgen! 
    t = NArray.sfloat(@nt).indgen!
    vx = VArray.new( x ).rename("x")
    vy = VArray.new( y ).rename("y")
    vz = VArray.new( z ).rename("z")
    vt = VArray.new( t ).rename("t")
    xax = Axis.new().set_pos(vx)
    yax = Axis.new().set_pos(vy)
    zax = Axis.new().set_pos(vz)
    tax = Axis.new().set_pos(vt)
    xygrid = Grid.new(xax, yax)
    xyzgrid = Grid.new(xax, yax, zax)
    xyztgrid = Grid.new(xax, yax, zax, tax)

    sqrt2 = sqrt(2.0)
    p = NArray.sfloat(@nx,@ny)
    q = NArray.sfloat(@nx,@ny)
    for j in 0...@ny
      p[true,j] = NArray.sfloat(@nx).indgen!(2*j,1)*sqrt2
      q[true,j] = NArray.sfloat(@nx).indgen!(2*j,-1)*sqrt2
    end
    vp = VArray.new( p ).rename("p")
    vq = VArray.new( q ).rename("q")
    gp = GPhys.new(xygrid, vp) 
    gq = GPhys.new(xygrid, vq) 
    r = NArray.sfloat(@nz).indgen! * 2
    vr = VArray.new( r ).rename("r")
    gr = GPhys.new( Grid.new(zax), vr ) 

    d = sin(x.newdim(1,1)) * cos(y.newdim(0,1)) + z.newdim(0,0)
    vd = VArray.new( d ).rename("d")
    @gd = GPhys.new(xyzgrid, vd)
    @gd.set_assoc_coords([gp,gq,gr])

    s = p + r.reshape(1,1,@nz)
    vs = VArray.new( s ).rename("s")
    gs = GPhys.new( Grid.new(xax,yax,zax), vs )
    u = NArray.sfloat(@ny).indgen!
    vu = VArray.new( u ).rename("u")
    gu = GPhys.new( Grid.new(yax), vu ) 
    d2 = d * NArray.sfloat(1,1,1,@nt).indgen
    vd2 = VArray.new( d2 ).rename("d2")
    @gd2 = GPhys.new( xyztgrid, vd2 )
    @gd2.set_assoc_coords([gp,gq,gs,gu])

    #p @gd
  end

  def test_gd
    # make sure @gd has proper associated coordinates.
    assert_equal( @gd.coord("p").rank, 2 )
    assert_equal( @gd.coord("p").shape, [@nx,@ny] )
    assert_equal( @gd.coord("q").rank, 2 )
    assert_equal( @gd.coord("r").rank, 1 )
  end

  def test_divide_and_join
    # make sure to divide a GPhys into chunks and joining them
    # restores the original assoccoords.
    chunks = Array.new
    [0..@nx/2,@nx/2+1..-1].each do |ix|
      [0..@ny/2,@ny/2+1..-1].each do |iy|
        chunks.push( @gd[ix,iy,true].copy )
      end
    end
    gd2 = GPhys.join(chunks)
    assert_equal( gd2.coord("p").shape, [@nx,@ny] )
    assert_equal( gd2.coord("p").val, @gd.coord("p").val )
  end

  def test_cut_twice
    c = @gd2[true,0,true,true] #=> [@nx,@nz,@nt]
    c2 = c[true,true,0]        #=> [@nx,@nz]
    assert_equal( c2.coord("p").shape, [@nx] )
    assert_equal( c2.coord("q").shape, [@nx] )
    assert_equal( c2.coord("s").shape, [@nx,@nz] )
  end

  def test_mean
    c = @gd2.mean("y") #=> [@nx,@nz,@nt]
    assert_equal( c.coord("p").shape, [@nx] )
    assert_equal( c.coord("q").shape, [@nx] )
    assert_equal( c.coord("s").shape, [@nx,@nz] )
  end

end
