!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!   yt_kxrgrad_yt, ggg_kgrad_yt, yt_qoperator_yt Υƥ
!  
program yttest5

  use yt_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ri=0.5, ro=1.5      ! ⳰Ⱦ

  real(8), dimension(im,jm,0:km)     :: ggg_data
  real(8), dimension(im,jm,0:km)     :: ggg_psi
  real(8), dimension(im,jm,0:km)     :: ggg_kxrgrad
  real(8), dimension(im,jm,0:km)     :: ggg_kgrad
  real(8), dimension(im,jm,0:km)     :: ggg_qoperator


  integer, parameter :: n=2
  real(8), parameter :: eps = 1D-8

  integer :: i,j,k

  write( 6,* ) 'Test for yt_kxrgrad_yt, ggg_kgrad_yt, yt_qoperator_yt'
  write( 6,* ) 'Output is displayed if computational error is larger than',eps

  call yt_initial(im,jm,km,nm,lm,ri,ro)

! -----------------  1 --------------------
  ggg_psi = ggg_rad**n * cos(ggg_lat)*sin(ggg_lon)   ! r**2 Y_1^1

  ggg_kxrgrad = ggg_rad**n * cos(ggg_lat)*cos(ggg_lon)

  ! k  r**n Y_1^1 = (n-1)*r**(n-1)* Y_2^1
  ggg_kgrad = (n-1)*ggg_rad**(n-1)* cos(ggg_lat)*sin(ggg_lat)*sin(ggg_lon) 

  ! Q r**n Y_1^1 = -3*(n-1)*r**(n-1)* Y_2^1
  ggg_qoperator = - 3*(n-1)*ggg_rad**(n-1)* cos(ggg_lat)*sin(ggg_lat)*sin(ggg_lon) 

  write(6,*)
  write(6,*)'Y_1^1 field'
  call checkresult

! -----------------  2 --------------------
  ggg_psi = cos(ggg_lat)*sin(ggg_lat) * sin(ggg_lon) ! Y_2^1

  ggg_kxrgrad = cos(ggg_lat)*sin(ggg_lat) * cos(ggg_lon) ! Y_2^1

  ! k Y_2^1 = (- 4 Y_3^1 / 15 - Y_1^1 /5) 
  ggg_kgrad = cos(2*ggg_lat)*cos(ggg_lat)*sin(ggg_lon)/ggg_rad

  ggg_qoperator = (16*sin(ggg_lat)**2 - 5)*cos(ggg_lat)*sin(ggg_lon)/ggg_rad

  write(6,*)
  write(6,*)'Y_2^1 field'
  call checkresult

  stop
contains

  subroutine checkresult
    write(6,*)'Checking k x r grad '
    ggg_data = ggg_yt(yt_kxrgrad_yt(yt_ggg(ggg_psi)))

    do k=0,km
       do j=1,jm
          do i=1,im
             if ( abs(ggg_data(i,j,k)-ggg_kxrgrad(i,j,k)) > eps ) then
                write(6,*) i,j,k, ggg_data(i,j,k), ggg_kxrgrad(i,j,k)
             endif
          end do
       end do
    end do

    write(6,*)'Checking k grad '
    ggg_data = ggg_kgrad_yt(yt_ggg(ggg_psi))

    do k=0,km
       do j=1,jm
          do i=1,im
             if ( abs(ggg_data(i,j,k)-ggg_kgrad(i,j,k)) > eps ) then
                write(6,*) i,j,k, ggg_data(i,j,k), ggg_kgrad(i,j,k)
             endif
          end do
       end do
    end do

    write(6,*)'Checking Q operator '
    ggg_data = ggg_yt(yt_qoperator_yt(yt_ggg(ggg_psi)))

    do k=0,km
       do j=1,jm
          do i=1,im
             if ( abs(ggg_data(i,j,k)-ggg_qoperator(i,j,k)) > eps ) then
                write(6,*) i,j,k, ggg_data(i,j,k), ggg_qoperator(i,j,k)
             endif
          end do
       end do
    end do
  end subroutine checkresult
end program yttest5

