
# line 10 "ncgen.y"
#ifndef lint
static char SccsId[] = "$Id: ncgentab.c,v 1.2 2002/01/20 22:33:53 russ Exp $";
#endif
#include        <string.h>
#include	<stdlib.h>
#include	<netcdf.h>
#include 	"generic.h"
#include        "ncgen.h"
#include	"genlib.h"	/* for grow_darray() et al */

typedef struct Symbol {		/* symbol table entry */
	char    	*name;
	struct Symbol   *next;
	unsigned	is_dim : 1;	/* appears as netCDF dimension */
	unsigned	is_var : 1;	/* appears as netCDF variable */
	unsigned	is_att : 1;	/* appears as netCDF attribute */
	int             dnum;	        /* handle as a dimension */
	int             vnum;	        /* handle as a variable */
	} *YYSTYPE1;

/* True if string a equals string b*/
#define	STREQ(a, b)	(*(a) == *(b) && strcmp((a), (b)) == 0)
#define NC_UNSPECIFIED ((nc_type)0)	/* unspecified (as yet) type */

#define YYSTYPE YYSTYPE1
YYSTYPE symlist;		/* symbol table: linked list */

extern int derror_count;	/* counts errors in netcdf definition */
extern int lineno;		/* line number for error messages */

static int not_a_string;	/* whether last constant read was a string */
static char termstring[MAXTRST]; /* last terminal string read */
static double double_val;	/* last double value read */
static float float_val;		/* last float value read */
static int int_val;		/* last int value read */
static short short_val;		/* last short value read */
static char char_val;		/* last char value read */
static signed char byte_val;	/* last byte value read */

static nc_type type_code;	/* holds declared type for variables */
static nc_type atype_code;	/* holds derived type for attributes */
static char *netcdfname;	/* to construct netcdf file name */
static void *att_space;		/* pointer to block for attribute values */
static nc_type valtype;		/* type code for list of attribute values  */

static char *char_valp;		/* pointers used to accumulate data values */
static signed char *byte_valp;
static short *short_valp;
static int *int_valp;
static float *float_valp;
static double *double_valp;
static void *rec_cur;		/* pointer to where next data value goes */
static void *rec_start;		/* start of space for data */
# define NC_UNLIMITED_K 257
# define BYTE_K 258
# define CHAR_K 259
# define SHORT_K 260
# define INT_K 261
# define FLOAT_K 262
# define DOUBLE_K 263
# define IDENT 264
# define TERMSTRING 265
# define BYTE_CONST 266
# define CHAR_CONST 267
# define SHORT_CONST 268
# define INT_CONST 269
# define FLOAT_CONST 270
# define DOUBLE_CONST 271
# define DIMENSIONS 272
# define VARIABLES 273
# define NETCDF 274
# define DATA 275
# define FILLVALUE 276
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE long
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 751 "ncgen.y"


/* PROGRAMS */

#ifdef vms
void
#else
int
#endif
yyerror(	/* called for yacc syntax error */
     char *s)
{
	derror(s);
#ifndef vms
	return -1;
#endif
}

/* undefine yywrap macro, in case we are using bison instead of yacc */
#ifdef yywrap
#undef yywrap
#endif

int
yywrap(void)			/* returns 1 on EOF if no more input */
{
    return  1;
}


/* Symbol table operations for ncgen tool */

YYSTYPE lookup(       /* find sname in symbol table (linear search) */
	char *sname)
{
    YYSTYPE sp;
    for (sp = symlist; sp != (YYSTYPE) 0; sp = sp -> next)
	if (STREQ(sp -> name, sname)) {
	    return sp;
	}
    return 0;			/* 0 ==> not found */
}

YYSTYPE install(  /* install sname in symbol table */
	char *sname)
{
    YYSTYPE sp;

    sp = (YYSTYPE) emalloc (sizeof (struct Symbol));
    sp -> name = (char *) emalloc (strlen (sname) + 1);/* +1 for '\0' */
    (void) strcpy (sp -> name, sname);
    sp -> next = symlist;	/* put at front of list */
    sp -> is_dim = 0;
    sp -> is_var = 0;
    sp -> is_att = 0;
    symlist = sp;
    return sp;
}

void
clearout(void)	/* reset symbol table to empty */
{
    YYSTYPE sp, tp;
    for (sp = symlist; sp != (YYSTYPE) 0;) {
	tp = sp -> next;
	free (sp -> name);
	free ((char *) sp);
	sp = tp;
    }
    symlist = 0;
}

/* get lexical input routine generated by lex  */
#include "ncgenyy.c"
static const yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 75
# define YYLAST 232

static const yytabelem yyact[]={

    97,    98,    96,    99,   100,   101,   102,    46,    14,     6,
     2,   103,    70,    71,    69,    72,    73,    74,    75,    58,
    22,    16,    40,    59,    14,    14,     3,    90,    15,    21,
    86,    57,    67,    50,    13,    84,    53,    44,    61,    43,
    43,    83,    77,    63,    52,    48,    36,    38,    92,    94,
    82,    93,    64,    19,    55,    42,    81,    51,    11,    25,
    18,    39,    10,    95,    91,    89,    78,    27,    60,    68,
    66,    37,    35,    12,    85,    80,    65,    49,    41,    28,
    26,    62,     9,    27,    47,    24,    20,    17,    45,    23,
     7,     5,     4,    51,     1,    62,     0,    56,    79,    76,
    54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    87,     0,     0,     0,    88,     0,     0,     0,     0,
     0,     0,   105,    87,   104,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    16,     0,     0,     0,     0,     0,
     0,     0,     0,     8,    29,    30,    31,    32,    33,    34,
    16,    16 };

static const yytabelem yypact[]={

  -264, -1000,   -97, -1000,  -263,   -50,  -244, -1000,   -34,   -33,
   -13, -1000, -1000,   -11,  -242, -1000, -1000,  -244,    -4, -1000,
   -24, -1000, -1000,  -268,   -34,   -14, -1000, -1000,  -243, -1000,
 -1000, -1000, -1000, -1000, -1000,   -15, -1000,   -25,  -242, -1000,
 -1000,    -5, -1000,  -244,  -238,  -102,  -243,   -16, -1000,     8,
 -1000, -1000, -1000,  -253, -1000, -1000, -1000, -1000, -1000, -1000,
  -243,   -17, -1000, -1000,  -243,    16,     6, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,   -18, -1000,   -26, -1000,
 -1000,  -244,  -253, -1000, -1000,     7, -1000, -1000, -1000,     5,
 -1000,  -265, -1000,  -244, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000 };

static const yytabelem yypgo[]={

     0,    94,    92,    91,    90,    89,    88,    87,    60,    53,
    86,    29,    85,    82,    59,    80,    58,    62,    79,    77,
    33,    28,    76,    75,    74,    30,    73,    71,    70,    34,
    61,    32,    69,    68,    38,    66,    65,    27,    64,    63 };

static const yytabelem yyr1[]={

     0,     2,     5,     1,     3,     3,     7,     7,     8,     8,
     9,     9,    10,    11,     4,     4,     4,    12,    12,    14,
    14,    13,    13,    17,    15,    18,    18,    18,    18,    18,
    18,    19,    19,    22,    20,    21,    23,    23,    24,    24,
    25,    27,    16,    26,    26,    29,    30,    28,    28,    31,
    32,    32,    32,    32,    32,    32,    32,     6,     6,    33,
    33,    35,    34,    36,    36,    38,    37,    39,    39,    39,
    39,    39,    39,    39,    39 };

static const yytabelem yyr2[]={

     0,     1,     1,    17,     0,     4,     4,     6,     2,     6,
     7,     7,     3,     2,     0,     4,     2,     4,     6,     2,
     2,     4,     6,     2,     4,     3,     3,     3,     3,     3,
     3,     2,     6,     1,     7,     2,     0,     6,     2,     6,
     3,     1,     9,     6,     5,     3,     3,     2,     6,     3,
     3,     3,     3,     3,     3,     3,     3,     0,     4,     4,
     6,     1,     9,     2,     6,     1,     5,     3,     3,     3,
     3,     3,     3,     3,     3 };

static const yytabelem yychk[]={

 -1000,    -1,   274,   123,    -2,    -3,   272,    -4,   273,   -13,
   -17,   -16,   -26,   -29,    58,   -21,   264,    -7,    -8,    -9,
   -10,   -11,   264,    -5,   -12,   -14,   -15,   -16,   -18,   258,
   259,   260,   261,   262,   263,   -17,    59,   -27,    58,   -30,
   264,    -8,    59,    44,    61,    -6,   275,   -14,    59,   -19,
   -20,   -21,    59,    61,   -30,    59,    -9,   269,   257,   125,
   -33,   -34,   -29,    59,    44,   -22,   -28,   -31,   -32,   267,
   265,   266,   268,   269,   270,   271,   -34,    59,   -35,   -20,
   -23,    40,    44,    59,    61,   -24,   -25,   -11,   -31,   -36,
   -37,   -38,    41,    44,    44,   -39,   267,   265,   266,   268,
   269,   270,   271,   276,   -25,   -37 };

static const yytabelem yydef[]={

     0,    -2,     0,     1,     4,    14,     0,     2,     0,    16,
     0,    23,    41,     0,     0,    45,    35,     5,     0,     8,
     0,    12,    13,    57,    15,     0,    19,    20,     0,    25,
    26,    27,    28,    29,    30,     0,    21,     0,     0,    44,
    46,     0,     6,     0,     0,     0,     0,     0,    17,    24,
    31,    33,    22,     0,    43,     7,     9,    10,    11,     3,
    58,     0,    61,    18,     0,    36,    42,    47,    49,    50,
    51,    52,    53,    54,    55,    56,     0,    59,     0,    32,
    34,     0,     0,    60,    65,     0,    38,    40,    48,    62,
    63,     0,    37,     0,    65,    66,    67,    68,    69,    70,
    71,    72,    73,    74,    39,    64 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"NC_UNLIMITED_K",	257,
	"BYTE_K",	258,
	"CHAR_K",	259,
	"SHORT_K",	260,
	"INT_K",	261,
	"FLOAT_K",	262,
	"DOUBLE_K",	263,
	"IDENT",	264,
	"TERMSTRING",	265,
	"BYTE_CONST",	266,
	"CHAR_CONST",	267,
	"SHORT_CONST",	268,
	"INT_CONST",	269,
	"FLOAT_CONST",	270,
	"DOUBLE_CONST",	271,
	"DIMENSIONS",	272,
	"VARIABLES",	273,
	"NETCDF",	274,
	"DATA",	275,
	"FILLVALUE",	276,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
      "ncdesc : NETCDF '{'",
      "ncdesc : NETCDF '{' dimsection vasection",
      "ncdesc : NETCDF '{' dimsection vasection datasection '}'",
      "dimsection : /* empty */",
      "dimsection : DIMENSIONS dimdecls",
      "dimdecls : dimdecline ';'",
      "dimdecls : dimdecls dimdecline ';'",
      "dimdecline : dimdecl",
      "dimdecline : dimdecline ',' dimdecl",
      "dimdecl : dimd '=' INT_CONST",
      "dimdecl : dimd '=' NC_UNLIMITED_K",
      "dimd : dim",
      "dim : IDENT",
      "vasection : /* empty */",
      "vasection : VARIABLES vadecls",
      "vasection : gattdecls",
      "vadecls : vadecl ';'",
      "vadecls : vadecls vadecl ';'",
      "vadecl : vardecl",
      "vadecl : attdecl",
      "gattdecls : gattdecl ';'",
      "gattdecls : gattdecls gattdecl ';'",
      "gattdecl : attdecl",
      "vardecl : type varlist",
      "type : BYTE_K",
      "type : CHAR_K",
      "type : SHORT_K",
      "type : INT_K",
      "type : FLOAT_K",
      "type : DOUBLE_K",
      "varlist : varspec",
      "varlist : varlist ',' varspec",
      "varspec : var",
      "varspec : var dimspec",
      "var : IDENT",
      "dimspec : /* empty */",
      "dimspec : '(' dimlist ')'",
      "dimlist : vdim",
      "dimlist : dimlist ',' vdim",
      "vdim : dim",
      "attdecl : att",
      "attdecl : att '=' attvallist",
      "att : avar ':' attr",
      "att : ':' attr",
      "avar : var",
      "attr : IDENT",
      "attvallist : aconst",
      "attvallist : attvallist ',' aconst",
      "aconst : attconst",
      "attconst : CHAR_CONST",
      "attconst : TERMSTRING",
      "attconst : BYTE_CONST",
      "attconst : SHORT_CONST",
      "attconst : INT_CONST",
      "attconst : FLOAT_CONST",
      "attconst : DOUBLE_CONST",
      "datasection : /* empty */",
      "datasection : DATA datadecls",
      "datadecls : datadecl ';'",
      "datadecls : datadecls datadecl ';'",
      "datadecl : avar",
      "datadecl : avar '=' constlist",
      "constlist : dconst",
      "constlist : constlist ',' dconst",
      "dconst : /* empty */",
      "dconst : const",
      "const : CHAR_CONST",
      "const : TERMSTRING",
      "const : BYTE_CONST",
      "const : SHORT_CONST",
      "const : INT_CONST",
      "const : FLOAT_CONST",
      "const : DOUBLE_CONST",
      "const : FILLVALUE",
};
#endif /* YYDEBUG */
/*
 * *****************************************************************
 * *                                                               *
 * *    Copyright Compaq Computer Corporation, 2000                *
 * *                                                               *
 * *   The software contained on this media  is  proprietary  to   *
 * *   and  embodies  the  confidential  technology  of  Compaq    *
 * *   Computer Corporation.  Possession, use,  duplication  or    *
 * *   dissemination of the software and media is authorized only  *
 * *   pursuant to a valid written license from Compaq Computer    *
 * *   Corporation.                                                *
 * *                                                               *
 * *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
 * *   by the U.S. Government is subject to restrictions  as  set  *
 * *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
 * *   or  in  FAR 52.227-19, as applicable.                       *
 * *                                                               *
 * *****************************************************************
 */
/*
 * HISTORY
 */
/*
 * @(#)$RCSfile: ncgentab.c,v $ $Revision: 1.2 $ (DEC) $Date: 2002/01/20 22:33:53 $
 */
/*
** Skeleton parser driver for yacc output
*/

/* external references for c++ and ANSI C
 * Define YY_NOPROTO to suppress the prototype declarations
 * GNUC and DECC define __STDC__ differently
 */
#ifdef __GNUC__
#if !__STDC__
#define YY_NOPROTO
#endif /* __STDC__ */
#elif !defined(__STDC__) &&  !defined (__cplusplus)
#define YY_NOPROTO
#endif /* __STDC__ */

/* Disable array out of bounds info messages */
#if defined (__DECC)
#pragma message disable (badsubscript,subscrbounds,unreach)
#endif

#ifndef YY_NOPROTO
#if defined (__cplusplus)
extern "C" {
extern void yyerror(char *); 
extern int yylex();
#else /* __cplusplus */
extern int yylex(void);
#endif /* __cplusplus */
#if defined (__cplusplus)
}
#endif /* __cplusplus */
#endif /* YY_NOPROTO */
/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** local variables used by the parser
 * these should be static in order to support
 * multiple parsers in a single executable program. POSIX 1003.2-1993
 */
static YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
static int yys[ YYMAXDEPTH ];		/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static YYSTYPE *yypvt;			/* top of value stack for $vars */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

/*
** global variables used by the parser - renamed as a result of -p
*/
int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || 
               ( yy_n >= YYLAST )       || 
               (yyact[yy_n ] < 0))
               	goto yydefault;

		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register const int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(yytmp){

case 1:	/* ncdesc : NETCDF '{' */
# line 97 "ncgen.y"
{ init_netcdf(); } /*NOTREACHED*/ break;
case 2:	/* ncdesc : NETCDF '{' dimsection vasection */
# line 100 "ncgen.y"
{
		       if (derror_count == 0)
			 define_netcdf(netcdfname);
		   } /*NOTREACHED*/ break;
case 3:	/* ncdesc : NETCDF '{' dimsection vasection datasection '}' */
# line 106 "ncgen.y"
{
		       if (derror_count == 0)
			 close_netcdf();
		   } /*NOTREACHED*/ break;
case 10:	/* dimdecl : dimd '=' INT_CONST */
# line 121 "ncgen.y"
{ if (int_val <= 0)
			 derror("dimension length must be positive");
		     dims[ndims].size = int_val;
		     ndims++;
		   } /*NOTREACHED*/ break;
case 11:	/* dimdecl : dimd '=' NC_UNLIMITED_K */
# line 127 "ncgen.y"
{  if (rec_dim != -1)
			 derror("only one NC_UNLIMITED dimension allowed");
		     rec_dim = ndims; /* the unlimited (record) dimension */
		     dims[ndims].size = NC_UNLIMITED;
		     ndims++;
		   } /*NOTREACHED*/ break;
case 12:	/* dimd : dim */
# line 135 "ncgen.y"
{ if (yypvt[-0]->is_dim == 1) {
		        derror( "duplicate dimension declaration for %s",
		                yypvt[-0]->name);
		     }
	             yypvt[-0]->is_dim = 1;
		     yypvt[-0]->dnum = ndims;
		     /* make sure dims array will hold dimensions */
		     grow_darray(ndims,  /* must hold ndims+1 dims */
				 &dims); /* grow as needed */
		     dims[ndims].name = (char *) emalloc(strlen(yypvt[-0]->name)+1);
		     (void) strcpy(dims[ndims].name, yypvt[-0]->name);
		     /* name for use in generated Fortran and C variables */
		     dims[ndims].lname = decodify(yypvt[-0]->name);
		   } /*NOTREACHED*/ break;
case 25:	/* type : BYTE_K */
# line 168 "ncgen.y"
{ type_code = NC_BYTE; } /*NOTREACHED*/ break;
case 26:	/* type : CHAR_K */
# line 169 "ncgen.y"
{ type_code = NC_CHAR; } /*NOTREACHED*/ break;
case 27:	/* type : SHORT_K */
# line 170 "ncgen.y"
{ type_code = NC_SHORT; } /*NOTREACHED*/ break;
case 28:	/* type : INT_K */
# line 171 "ncgen.y"
{ type_code = NC_INT; } /*NOTREACHED*/ break;
case 29:	/* type : FLOAT_K */
# line 172 "ncgen.y"
{ type_code = NC_FLOAT; } /*NOTREACHED*/ break;
case 30:	/* type : DOUBLE_K */
# line 173 "ncgen.y"
{ type_code = NC_DOUBLE; } /*NOTREACHED*/ break;
case 33:	/* varspec : var */
# line 179 "ncgen.y"
{
		    static struct vars dummyvar;

		    dummyvar.name = "dummy";
		    dummyvar.type = NC_DOUBLE;
		    dummyvar.ndims = 0;
		    dummyvar.dims = 0;
		    dummyvar.fill_value.doublev = NC_FILL_DOUBLE;
		    dummyvar.has_data = 0;

		    nvdims = 0;
		    /* make sure variable not re-declared */
		    if (yypvt[-0]->is_var == 1) {
		       derror( "duplicate variable declaration for %s",
		               yypvt[-0]->name);
		    }
	            yypvt[-0]->is_var = 1;
		    yypvt[-0]->vnum = nvars;
		    /* make sure vars array will hold variables */
		    grow_varray(nvars,  /* must hold nvars+1 vars */
				&vars); /* grow as needed */
		    vars[nvars] = dummyvar; /* to make Purify happy */
		    vars[nvars].name = (char *) emalloc(strlen(yypvt[-0]->name)+1);
		    (void) strcpy(vars[nvars].name, yypvt[-0]->name);
		    /* name for use in generated Fortran and C variables */
		    vars[nvars].lname = decodify(yypvt[-0]->name);
		    vars[nvars].type = type_code;
		    /* set default fill value.  You can override this with
		     * the variable attribute "_FillValue". */
		    nc_getfill(type_code, &vars[nvars].fill_value);
		    vars[nvars].has_data = 0; /* has no data (yet) */
		   } /*NOTREACHED*/ break;
case 34:	/* varspec : var dimspec */
# line 212 "ncgen.y"
{
		    vars[nvars].ndims = nvdims;
		    nvars++;
		   } /*NOTREACHED*/ break;
case 40:	/* vdim : dim */
# line 226 "ncgen.y"
{
		    if (nvdims >= NC_MAX_VAR_DIMS) {
		       derror("%s has too many dimensions",vars[nvars].name);
		    }
		    if (yypvt[-0]->is_dim == 1)
		       dimnum = yypvt[-0]->dnum;
		    else {
		       derror( "%s is not declared as a dimension",
			       yypvt[-0]->name);
	               dimnum = ndims;
		    }
		    if (rec_dim != -1 && dimnum == rec_dim && nvdims != 0) {
		       derror("unlimited dimension must be first");
		    }
		    grow_iarray(nvdims, /* must hold nvdims+1 ints */
				&vars[nvars].dims); /* grow as needed */
		    vars[nvars].dims[nvdims] = dimnum;
                    nvdims++;
		   } /*NOTREACHED*/ break;
case 41:	/* attdecl : att */
# line 247 "ncgen.y"
{
		       valnum = 0;
		       valtype = NC_UNSPECIFIED;
		       /* get a large block for attributes, realloc later */
		       att_space = emalloc(MAX_NC_ATTSIZE);
		       /* make all kinds of pointers point to it */
		       char_valp = (char *) att_space;
		       byte_valp = (signed char *) att_space;
		       short_valp = (short *) att_space;
		       int_valp = (int *) att_space;
		       float_valp = (float *) att_space;
		       double_valp = (double *) att_space;
		   } /*NOTREACHED*/ break;
case 42:	/* attdecl : att '=' attvallist */
# line 261 "ncgen.y"
{
		       {	/* check if duplicate attribute for this var */
			   int i;
			   for(i=0; i<natts; i++) { /* expensive */
			       if(atts[i].var == varnum &&
				  STREQ(atts[i].name,atts[natts].name)) {
				   derror("duplicate attribute %s:%s",
					  vars[varnum].name,atts[natts].name);
			       }
			   }
		       }
		       atts[natts].var = varnum ;
		       atts[natts].type = valtype;
		       atts[natts].len = valnum;
		       /* shrink space down to what was really needed */
		       att_space = erealloc(att_space, valnum*nctypesize(valtype));
		       atts[natts].val = att_space;
		       if (STREQ(atts[natts].name, _FillValue) &&
			   atts[natts].var != NC_GLOBAL) {
			   nc_putfill(atts[natts].type,
				       atts[natts].val,
				       &vars[atts[natts].var].fill_value);
			   if(atts[natts].type != vars[atts[natts].var].type) {
			       derror("variable %s: %s type mismatch",
				      vars[atts[natts].var].name, _FillValue);
			   }
		       }
		       natts++;
		   } /*NOTREACHED*/ break;
case 44:	/* att : ':' attr */
# line 293 "ncgen.y"
{
		    varnum = NC_GLOBAL;  /* handle of "global" attribute */
		   } /*NOTREACHED*/ break;
case 45:	/* avar : var */
# line 299 "ncgen.y"
{ if (yypvt[-0]->is_var == 1)
		       varnum = yypvt[-0]->vnum;
		    else {
		      derror("%s not declared as a variable, fatal error",
			     yypvt[-0]->name);
		      YYABORT;
		      }
		   } /*NOTREACHED*/ break;
case 46:	/* attr : IDENT */
# line 309 "ncgen.y"
{
		       /* make sure atts array will hold attributes */
		       grow_aarray(natts,  /* must hold natts+1 atts */
				   &atts); /* grow as needed */
		       atts[natts].name = (char *) emalloc(strlen(yypvt[-0]->name)+1);
		       (void) strcpy(atts[natts].name,yypvt[-0]->name);
		       /* name for use in generated Fortran and C variables */
		       atts[natts].lname = decodify(yypvt[-0]->name);
		   } /*NOTREACHED*/ break;
case 49:	/* aconst : attconst */
# line 323 "ncgen.y"
{
		    if (valtype == NC_UNSPECIFIED)
		      valtype = atype_code;
		    if (valtype != atype_code)
		      derror("values for attribute must be all of same type");
		   } /*NOTREACHED*/ break;
case 50:	/* attconst : CHAR_CONST */
# line 332 "ncgen.y"
{
		       atype_code = NC_CHAR;
		       *char_valp++ = char_val;
		       valnum++;
		   } /*NOTREACHED*/ break;
case 51:	/* attconst : TERMSTRING */
# line 338 "ncgen.y"
{
		       atype_code = NC_CHAR;
		       {
			   /* don't null-terminate attribute strings */
			   size_t len = strlen(termstring);
			   if (len == 0) /* need null if that's only value */
			       len = 1;
			   (void)strncpy(char_valp,termstring,len);
			   valnum += len;
			   char_valp += len;
		       }
		   } /*NOTREACHED*/ break;
case 52:	/* attconst : BYTE_CONST */
# line 351 "ncgen.y"
{
		       atype_code = NC_BYTE;
		       *byte_valp++ = byte_val;
		       valnum++;
		   } /*NOTREACHED*/ break;
case 53:	/* attconst : SHORT_CONST */
# line 357 "ncgen.y"
{
		       atype_code = NC_SHORT;
		       *short_valp++ = short_val;
		       valnum++;
		   } /*NOTREACHED*/ break;
case 54:	/* attconst : INT_CONST */
# line 363 "ncgen.y"
{
		       atype_code = NC_INT;
		       *int_valp++ = int_val;
		       valnum++;
		   } /*NOTREACHED*/ break;
case 55:	/* attconst : FLOAT_CONST */
# line 369 "ncgen.y"
{
		       atype_code = NC_FLOAT;
		       *float_valp++ = float_val;
		       valnum++;
		   } /*NOTREACHED*/ break;
case 56:	/* attconst : DOUBLE_CONST */
# line 375 "ncgen.y"
{
		       atype_code = NC_DOUBLE;
		       *double_valp++ = double_val;
		       valnum++;
		   } /*NOTREACHED*/ break;
case 61:	/* datadecl : avar */
# line 390 "ncgen.y"
{
		       valtype = vars[varnum].type; /* variable type */
		       valnum = 0;	/* values accumulated for variable */
		       vars[varnum].has_data = 1;
		       /* compute dimensions product */
		       var_size = nctypesize(valtype);
		       if (vars[varnum].ndims == 0) { /* scalar */
			   var_len = 1;
		       } else if (vars[varnum].dims[0] == rec_dim) {
			   var_len = 1; /* one record for unlimited vars */
		       } else {
			   var_len = dims[vars[varnum].dims[0]].size;
		       }
		       for(dimnum = 1; dimnum < vars[varnum].ndims; dimnum++)
			 var_len = var_len*dims[vars[varnum].dims[dimnum]].size;
		       /* allocate memory for variable data */
		       if (var_len*var_size != (size_t)(var_len*var_size)) {
			   derror("variable %s too large for memory",
				  vars[varnum].name);
			   exit(9);
		       }
		       rec_len = var_len;
		       rec_start = malloc ((size_t)(rec_len*var_size));
		       if (rec_start == 0) {
			   derror ("out of memory\n");
			   exit(3);
		       }
		       rec_cur = rec_start;
		       switch (valtype) {
			 case NC_CHAR:
			   char_valp = (char *) rec_start;
			   break;
			 case NC_BYTE:
			   byte_valp = (signed char *) rec_start;
			   break;
			 case NC_SHORT:
			   short_valp = (short *) rec_start;
			   break;
			 case NC_INT:
			   int_valp = (int *) rec_start;
			   break;
			 case NC_FLOAT:
			   float_valp = (float *) rec_start;
			   break;
			 case NC_DOUBLE:
			   double_valp = (double *) rec_start;
			   break;
		       }
		 } /*NOTREACHED*/ break;
case 62:	/* datadecl : avar '=' constlist */
# line 440 "ncgen.y"
{
		       if (valnum < var_len) { /* leftovers */
			   nc_fill(valtype,
				    var_len - valnum,
				    rec_cur,
				    vars[varnum].fill_value);
		       }
		       /* put out var_len values */
		       vars[varnum].nrecs = valnum / rec_len;
		       if (derror_count == 0)
			   put_variable(rec_start);
		       free ((char *) rec_start);
		 } /*NOTREACHED*/ break;
case 65:	/* dconst : Empty */
# line 458 "ncgen.y"
{
		       if(valnum >= var_len) {
			   if (vars[varnum].dims[0] != rec_dim) { /* not recvar */
			       derror("too many values for this variable, %d >= %d",
				      valnum, var_len);
			       exit (4);
			   } else { /* a record variable, so grow data
				      container and increment var_len by
				      multiple of record size */
			       ptrdiff_t rec_inc = (char *)rec_cur
				   - (char *)rec_start;
			       var_len = rec_len * (1 + valnum / rec_len);
			       rec_start = erealloc(rec_start, var_len*var_size);
			       rec_cur = (char *)rec_start + rec_inc;
			       char_valp = (char *) rec_cur;
			       byte_valp = (signed char *) rec_cur;
			       short_valp = (short *) rec_cur;
			       int_valp = (int *) rec_cur;
			       float_valp = (float *) rec_cur;
			       double_valp = (double *) rec_cur;
			   }
		       }
		       not_a_string = 1;
                   } /*NOTREACHED*/ break;
case 66:	/* dconst : const */
# line 483 "ncgen.y"
{
		       if (not_a_string) {
			   switch (valtype) {
			     case NC_CHAR:
			       rec_cur = (void *) char_valp;
			       break;
			     case NC_BYTE:
			       rec_cur = (void *) byte_valp;
			       break;
			     case NC_SHORT:
			       rec_cur = (void *) short_valp;
			       break;
			     case NC_INT:
			       rec_cur = (void *) int_valp;
			       break;
			     case NC_FLOAT:
			       rec_cur = (void *) float_valp;
			       break;
			     case NC_DOUBLE:
			       rec_cur = (void *) double_valp;
			       break;
			   }
		       }
		   } /*NOTREACHED*/ break;
case 67:	/* const : CHAR_CONST */
# line 510 "ncgen.y"
{
		       atype_code = NC_CHAR;
		       switch (valtype) {
			 case NC_CHAR:
			   *char_valp++ = char_val;
			   break;
			 case NC_BYTE:
			   *byte_valp++ = char_val;
			   break;
			 case NC_SHORT:
			   *short_valp++ = char_val;
			   break;
			 case NC_INT:
			   *int_valp++ = char_val;
			   break;
			 case NC_FLOAT:
			   *float_valp++ = char_val;
			   break;
			 case NC_DOUBLE:
			   *double_valp++ = char_val;
			   break;
		       }
		       valnum++;
		   } /*NOTREACHED*/ break;
case 68:	/* const : TERMSTRING */
# line 535 "ncgen.y"
{
		       not_a_string = 0;
		       atype_code = NC_CHAR;
		       {
			   size_t len = strlen(termstring);

			   if(valnum + len > var_len) {
			       if (vars[varnum].dims[0] != rec_dim) {
				   derror("too many values for this variable, %d>%d", 
					  valnum+len, var_len);
				   exit (5);
			       } else {/* a record variable so grow it */
				   ptrdiff_t rec_inc = (char *)rec_cur
				       - (char *)rec_start;
				   var_len += rec_len * (len + valnum - var_len)/rec_len;
				   rec_start = erealloc(rec_start, var_len*var_size);
				   rec_cur = (char *)rec_start + rec_inc;
				   char_valp = (char *) rec_cur;
			       }
			   }
			   switch (valtype) {
			     case NC_CHAR:
			       {
				   int ld;
				   size_t i, sl;
				   (void)strncpy(char_valp,termstring,len);
				   ld = vars[varnum].ndims-1;
				   if (ld > 0) {/* null-fill to size of last dim */
				       sl = dims[vars[varnum].dims[ld]].size;
				       for (i =len;i<sl;i++)
					   char_valp[i] = '\0';
				       if (sl < len)
					   sl = len;
				       valnum += sl;
				       char_valp += sl;
				   } else { /* scalar or 1D strings */
				       valnum += len;
				       char_valp += len;
				   }
				   rec_cur = (void *) char_valp;
			       }
			       break;
			     case NC_BYTE:
			     case NC_SHORT:
			     case NC_INT:
			     case NC_FLOAT:
			     case NC_DOUBLE:
			       derror("string value invalid for %s variable",
				      nctype(valtype));
			       break;
			   }
		       }
		   } /*NOTREACHED*/ break;
case 69:	/* const : BYTE_CONST */
# line 589 "ncgen.y"
{
		       atype_code = NC_BYTE;
		       switch (valtype) {
			 case NC_CHAR:
			   *char_valp++ = byte_val;
			   break;
			 case NC_BYTE:
			   *byte_valp++ = byte_val;
			   break;
			 case NC_SHORT:
			   *short_valp++ = byte_val;
			   break;
			 case NC_INT:
			   *int_valp++ = byte_val;
			   break;
			 case NC_FLOAT:
			   *float_valp++ = byte_val;
			   break;
			 case NC_DOUBLE:
			   *double_valp++ = byte_val;
			   break;
		       }
		       valnum++;
		   } /*NOTREACHED*/ break;
case 70:	/* const : SHORT_CONST */
# line 614 "ncgen.y"
{
		       atype_code = NC_SHORT;
		       switch (valtype) {
			 case NC_CHAR:
			   *char_valp++ = short_val;
			   break;
			 case NC_BYTE:
			   *byte_valp++ = short_val;
			   break;
			 case NC_SHORT:
			   *short_valp++ = short_val;
			   break;
			 case NC_INT:
			   *int_valp++ = short_val;
			   break;
			 case NC_FLOAT:
			   *float_valp++ = short_val;
			   break;
			 case NC_DOUBLE:
			   *double_valp++ = short_val;
			   break;
		       }
		       valnum++;
		   } /*NOTREACHED*/ break;
case 71:	/* const : INT_CONST */
# line 639 "ncgen.y"
{
		       atype_code = NC_INT;
		       switch (valtype) {
			 case NC_CHAR:
			   *char_valp++ = int_val;
			   break;
			 case NC_BYTE:
			   *byte_valp++ = int_val;
			   break;
			 case NC_SHORT:
			   *short_valp++ = int_val;
			   break;
			 case NC_INT:
			   *int_valp++ = int_val;
			   break;
			 case NC_FLOAT:
			   *float_valp++ = int_val;
			   break;
			 case NC_DOUBLE:
			   *double_valp++ = int_val;
			   break;
		       }
		       valnum++;
		   } /*NOTREACHED*/ break;
case 72:	/* const : FLOAT_CONST */
# line 664 "ncgen.y"
{
		       atype_code = NC_FLOAT;
		       switch (valtype) {
			 case NC_CHAR:
			   *char_valp++ = float_val;
			   break;
			 case NC_BYTE:
			   *byte_valp++ = float_val;
			   break;
			 case NC_SHORT:
			   *short_valp++ = float_val;
			   break;
			 case NC_INT:
			   *int_valp++ = float_val;
			   break;
			 case NC_FLOAT:
			   *float_valp++ = float_val;
			   break;
			 case NC_DOUBLE:
			   *double_valp++ = float_val;
			   break;
		       }
		       valnum++;
		   } /*NOTREACHED*/ break;
case 73:	/* const : DOUBLE_CONST */
# line 689 "ncgen.y"
{
		       atype_code = NC_DOUBLE;
		       switch (valtype) {
			 case NC_CHAR:
			   *char_valp++ = double_val;
			   break;
			 case NC_BYTE:
			   *byte_valp++ = double_val;
			   break;
			 case NC_SHORT:
			   *short_valp++ = double_val;
			   break;
			 case NC_INT:
			   *int_valp++ = double_val;
			   break;
			 case NC_FLOAT:
			   if (double_val == NC_FILL_DOUBLE)
			     *float_valp++ = NC_FILL_FLOAT;
			   else
			     *float_valp++ = double_val;
			   break;
			 case NC_DOUBLE:
			   *double_valp++ = double_val;
			   break;
		       }
		       valnum++;
		   } /*NOTREACHED*/ break;
case 74:	/* const : FILLVALUE */
# line 717 "ncgen.y"
{
		       /* store fill_value */
		       switch (valtype) {
		       case NC_CHAR:
			   nc_fill(valtype, 1, (void *)char_valp++,
				   vars[varnum].fill_value);
			   break;
		       case NC_BYTE:
			   nc_fill(valtype, 1, (void *)byte_valp++,
				   vars[varnum].fill_value);
			   break;
		       case NC_SHORT:
			   nc_fill(valtype, 1, (void *)short_valp++,
				   vars[varnum].fill_value);
			   break;
		       case NC_INT:
			   nc_fill(valtype, 1, (void *)int_valp++,
				   vars[varnum].fill_value);
			   break;
		       case NC_FLOAT:
			   nc_fill(valtype, 1, (void *)float_valp++,
				   vars[varnum].fill_value);
			   break;
		       case NC_DOUBLE:
			   nc_fill(valtype, 1, (void *)double_valp++,
				   vars[varnum].fill_value);
			   break;
		       }
		       valnum++;
		   } /*NOTREACHED*/ break;
}


	goto yystack;		/* reset registers in driver code */
}
