
require "narray"
require "ispack_raw.so"
require "numru/dcl"

#include Math
include NMath # NArrayޤ뤴sin,expʤɤα黻Ǥ⥸塼롣
include NumRu::DCL

def check(mm,time,pv) # ͥ륮󥹥ȥեå
  omg = 1.0
#  psi = NArray.float((mm+1)*(mm+1))
  psi = ISPACK::ndca2p(mm,omg,pv)
  ene = ISPACK::ndgeea(mm,psi)
  ens = ISPACK::ndgena(mm,psi)
  printf("%4.2f %12.10f %12.10f\n",time, ene, ens)
end

def pv0init(mm,jm,im,p,q,r,it,t,y) # 
  omg = 1.0
#  u0 = 180.0 * 86.4 / 40000.0 # m/s -> a Omega
#  phi0 = 50.0 * PI / 180.0    # deg -> rad
#  b0  = 10.0 * PI / 180.0     # deg -> rad
  u0 = 270.0 * 86.4 / 40000.0 # m/s -> a Omega
  phi0 = 55.0 * PI / 180.0    # deg -> rad
  b0  = 4.0 * PI / 180.0     # deg -> rad

#  u = NArray.float(jm*im).fill(0.0)
  u = NArray.float(jm*im)
#  u[0..jm-1] = u0*cos(y)*sech( 2.0*(y-phi0)/b0 ) # sechå
  u[0..jm-1] = u0*cos(y)*(1+tanh( (y-phi0)/b0 ))/2.0 # tanhå
  for i in 0..im-1
    u[(i*jm)..(i*jm+jm-1)] = u[0..jm-1]
  end

  v = NArray.float(jm*im).fill(0.0)

  pv0 = ISPACK::stvrsa(mm,jm,im,u,v,p,q,r,it,t) # u,vб٤Ѵ
#  pv0 = ISPACK::ndtv2a(mm,omg,pv0)            # б٤б٤Ѵ
  pv0 = ISPACK::ndtv2a(omg,pv0)            # б٤б٤Ѵ

  return pv0
end

def derivative(pv,pv0,mm,jm,im,p4,q,r,it,t) # dq/dt = -J(,q) -(q-q0) +ͦ(q-q0)

  rank = 1
  nu = 1.0/(mm*(mm+1)-2.0)**rank
  alpha = 0.1

  omg = 1.0
  psi = ISPACK::ndca2p(mm,omg,pv)
  jacobian = ISPACK::stajba(mm,jm,im,psi,pv,p4,q,r,it,t) * (-2*PI)
  relax = - alpha * (pv - pv0)
#  pv1 = pv - pv0
#  viscous = nu * ISPACK::stclfa(mm, pv1)
#  viscous = nu * ISPACK::stclfa(mm, pv - pv0)
  viscous = nu * (ISPACK::stclfa(mm, pv - pv0)+2.0*(pv - pv0))**rank

  dpvdt = jacobian + relax + viscous
  return dpvdt
end

def integral(time,pv,mm,jm,im,dt,p4,q,r,it,t,pv0) # 󥲥åʬ

  d1 = derivative(pv,pv0,mm,jm,im,p4,q,r,it,t)
  w = pv + d1*dt/2.0
  d2 = derivative(w,pv0,mm,jm,im,p4,q,r,it,t)
  w = pv + d2*dt/2.0
  d3 = derivative(w,pv0,mm,jm,im,p4,q,r,it,t)
  w = pv + d3*dt
  d4 = derivative(w,pv0,mm,jm,im,p4,q,r,it,t)

  pv = pv + (d1 + d2*2.0 + d3*2.0 + d4)/6.0*dt
  time  = time + dt

  return time,pv
end

def drawinit
  sglset('lcorner',false)
  gllset('lmiss',true)
  gliset('msglev',2)

  sglset('lsoftf',false)
  sglset('lfull',true)
  sglset('lcntl',true)
  udlset('lmsg',false)

  sglset( 'lclip', true )
  sgiset( 'ifont', 2 )
  sglset( 'lfprop', true )

  swistx( 'iwidth', 512 )
  swistx( 'iheight', 512 )

  swlset( 'lalt', TRUE )
  swlset( 'lwait', FALSE )

  gropn(1)

  sgrset( 'stlat1', 45.0 )
  sgrset( 'stlat2', 30.0 )
  umlset( 'lgridmn', FALSE )
  umiset( 'indexmj', 1 )
  umiset( 'itypemj', 3 )
  sgstxs( 0.035 )
  sgstxi( 3 )
end

def draw(s,mm,jm,im,p,q,r,it,t)
  sgfrm
  sgswnd( 0.0, 360.0, -90.0, 90.0 )   # e  (oxAx)
  sgssim( 0.5, 0.0,0.0 )           # g{/S
  sgsmpl( 0.0, 90.0, 0.0 )           # eS]p
  sgstxy( -180.0, 180.0, 30.0, 90.0 ) # NbsO
  sgstrn( 33 )                    # n}^
  sgstrf                          # m

  g = ISPACK::sts2ga(mm,jm,im,s,p,q,r,it,t).transpose
  umpgrd
  udsfmt('(i3)')                      # label format
  udiset('icycle',5)
  udgcla(1.0,5.0,0.2)

  g1 = NArray.sfloat(jm,(im+1))
  g1[0..jm*im-1] = g
  g1[jm*im..jm*(im+1)-1] = g[0..jm-1]
  nbr = ( ((jm*2+3)*((im+1)*2+3)+15)/16 +1 )*3
#  udcntz(g1.transpose(1,0),im+1,im+1,jm,nbr)
  udcntz(g1.transpose(1,0))
end

#mm = 85
#jm = 128
#im = 256
mm = 21
jm = 32
im = 64
lm = (mm+1)*(mm+1)

time = 0.0
dt = 1.0/80.0
#omg = 1.0

q,r,it,t = ISPACK::stinit(mm,jm,im) # Ĵ´ؿν
p = NArray.sfloat(jm*im).fill!(0.0) # ΰ
p4 = NArray.sfloat(jm*im*4).fill!(0.0) # ΰ
y,x = ISPACK::stogrd(jm,im,q) # åɤκɸ

pv0 = pv0init(mm,jm,im,p,q,r,it,t,y)
#pv = pv0 + 0.001000000 # ͤ
pv = pv0 + 0.000001000000 # ͤ
#file = File.new("test.data","r")
#pv = NArray.to_na( file.read(lm*8), "float", lm )
#p pv
#pv = NArray.to_na( file.gets, "float", lm)
#file.close

drawinit

check(mm,time,pv)
draw(pv,mm,jm,im,p,q,r,it,t)

for i in 1..10
  for j in 1..80
    time,pv = integral(time,pv,mm,jm,im,dt,p4,q,r,it,t,pv0)
  end
  check(mm,time,pv)
  draw(pv,mm,jm,im,p,q,r,it,t)
end

