require "mkmf"

def have_librarys(*lib)
  printf "checking librarys lib%s... ", lib.join(", lib")
  STDOUT.flush

  libs = "-l" + lib.join(" -l") + " " + $libs
  r = try_link(<<"SRC", libs)
int main() { return 0; }
SRC
  unless r
    print "no\n"
    return false
  end

  $libs = libs
  print "yes\n"
  return true
end

case RUBY_PLATFORM
when "i386-linux"
  dir_config("--with-elf","/usr/include","/usr/lib")
  if ! have_library("elf") then
    STDERR.print "cannot find library file for elf\n"
    STDERR.print "ruby extconf.rb --with-elf-lib=(path of libelf.a)\n"
    exit 1
  end

  dir_config("--with-ffc","/usr/include","/usr/FFC/lib")
  if ! have_librarys("fj9f6","fj9i6") then
    STDERR.print "cannot find library file for fj9f6,fj9i6\n"
    STDERR.print "ruby extconf.rb --with-ffc-lib=(path of libfj9{r,i}6.so)\n"
    exit 1
  end

when /sparc-solaris2.[5-8]/
  dir_config("--with-sun","/usr/include","/opt/SUNWspro/lib")
  dir_config("--with-sun","/usr/local/opt/SUNWspro/SC4.0/include",
             "/usr/local/opt/SUNWspro/SC4.0/lib")
  if ! have_librarys("F77","sunmath") then
    STDERR.print "cannot find library file for F77,sunmath\n"
    STDERR.print "ruby extconf.rb --with-sun-lib=(path of libF77.so,libsunmath.so)\n"
    exit 1
  end
  have_librarys("M77","V77")

else

    STDERR.print "unsuported platform: "+RUBY_PLATFORM+"\n"
    exit 1

end

dir_config("--with-ispack","/usr/local/lib","/usr/local/lib")
if ! have_library("isp") then
  STDERR.print "cannot find library file for isp\n"
  STDERR.print "ruby extconf.rb --with-ispack-lib=(path of libisp.a)\n"
  exit 1
end

create_makefile("ispack_raw")
