#*********************************************************************#
#     convection.f: c2packȤäƥ٥ʡή׻ץ
#                                                  2000/10/16 K.Ishioka
#*********************************************************************#
# 05/07/20 test_c2pack.rb FortranץRubyˤ R.Mizuta
#----------------------------------------------------------------------
require "narray"
require "ispack.rb"
require "numru/dcl"
include NumRu
include NMath

# ѥ᥿ 

      jm=64;im=128    #ʻ(jm: y, im: x)
      lm=42;km=42     #ȿ

      nstep=200                 #ȯŸ륹ƥå׿
      h=10.0                     #եåɽΤλֳִ
      m=2                       #runge-kuttaǤΥƥåʬ      

      deltat=h/m                #runge-kuttaλֹ

      Isplit=0        #⡼ʬ򤷤ưɤΥե饰

      dl = NArray.float(km*2+1,lm,2,2) #ͭ⡼ɤȯŸ˻Ȥ
      diff = NArray.float(km*2+1,lm,2) #Ǵ̤Τ˻Ȥ      

#--------------------------------------------------
# ¸ѥ᥿. ʪͤϤȤꤢΤΤCGSñ̤ͿƤ.
#      
      alpha=2.1e-4              #ĥΨ
      grav=980e0                #ϲ®
      dkappa=1.4e-3             #ǮȻ
      dnu=1.0e-2                #Ǵ
      Depth=1.0e0               #忼
      Dtemp=0.1e0               #üȲüβٺ
      dleng=2*sqrt(2.0e0)*Depth #ʿμ

      Rat=2*Depth/dleng

      dkappb=dkappa*(PI/Depth)*(PI/Depth)
      dnud=dnu*(PI/Depth)*(PI/Depth)      

      Coef1=alpha*grav*2*PI/dleng
      Coef2=Dtemp/PI*Rat

      raylgh=alpha*grav*Dtemp*Depth**3/(dnu*dkappa)
      rc=PI**4*27/4

      print 'rayleigh number=',raylgh,"\n"
      print 'critical rayleigh number=',rc,"\n"

# Ϳ줿, SBGDZNǻȤDL(Ǵˤ븺̤Ϳ)
# ꤹ. ʤ, SBGDZNRunge-KuttaǸƤӽФ뤬, κ,
# DT=DELTAT/2ǸƤӽФ뤫, θ, DLϰʲΤ
# Ǥ.

      k = (NArray.float(km*2+1).indgen! - km).newdim!(1)
      l = (NArray.float(lm).indgen! + 1).newdim!(0)
      if(Isplit == 1) then
        rk=Rat*k
        a=-dnud*(rk*rk+l*l)
        b=-alpha*grav*2*PI/dleng*k
        c=-Dtemp/PI*rk/(rk*rk+l*l)
        d=-dkappb*(rk*rk+l*l)
        sigma1=(a+d-sqrt((a-d)*(a-d)+4*b*c))/2
        sigma2=(a+d+sqrt((a-d)*(a-d)+4*b*c))/2
        esig1=exp(sigma1*deltat/2)
        esig2=exp(sigma2*deltat/2)
        sig21=sigma2-sigma1
        dl[true,true,0,0] = ((sigma2-a)*esig1+(a-sigma1)*esig2)/sig21
        dl[true,true,0,1]=b/sig21*(-esig1+esig2)
        dl[true,true,1,0]=c/sig21*(-esig1+esig2)          
        dl[true,true,1,1]=((sigma2-d)*esig1+(d-sigma1)*esig2)/sig21
      else
        diff[true,true,0] = exp(-dnud*deltat/2*((Rat*k)*(Rat*k)+l*l))
        diff[true,true,1] = exp(-dkappb*deltat/2*((Rat*k)*(Rat*k)+l*l))          
      end

# C2PACKν

      c2 = C2PACK.new(lm,km,jm,im,Rat)

# եåν

      DCL::swiset('iwidth',  400)
      DCL::swiset('iheight', 400)
      DCL::swlset('lwait',false)
      DCL::swlset('lalt',true)
      DCL::sgpset('lfull',true)
      DCL::sglset('lcorner',false)

      DCL::gropn(1)
      DCL::uzpset('inner',-1)
      DCL::sldiv('t',1,2)
      DCL::slrat(1.0,0.5)
      DCL::glpset('lmiss',true)
      DCL::sgpset('lcntl',true)

      ipat0=25
      dlev=0.005
      nlev=20
      idlev=3

      for i in 1..nlev
        ipat=(ipat0+i*idlev)*1000+999
        if(i == 1) then
          tlev1=999.0
        else
          tlev1=(i-1)*dlev
        end
        if(i == nlev) then
          tlev2=999.0
        else
          tlev2=i*dlev
        end
        DCL::uestlv(tlev1,tlev2,ipat)
      end

#----------------------------------------------------------------------
#     ٤Υڥȥ뷸(Z)ν
#----------------------------------------------------------------------
    def sbiniz(c2)
# Ǥ, ԰ʱؤäͿ,
# C2G2SAȤäƥڥȥ뷸Ѵ, Zνͤ
# Ƥ.

      lm, km, jm, im = c2.lm, c2.km, c2.jm, c2.im
      z = NArray.float(km*2+1,lm,2).fill!(0.0)   #٤ΤȲ٥ڥȥ뷸
      g0 = NArray.float(jm+1,im).fill!(0.0)
      g0[jm/2,im/2] = 1e-6
      z[true,true,1] = c2.g2sa(g0,1)

      return z
    end
#----------------------------------------------------------------------
#     Zб򥰥եåɽ.
#----------------------------------------------------------------------
    def sbgrph(t,z,lm,km,jm,im,c2)

      rg = NArray.sfloat(im+1,jm+1)        #եå˻Ȥ

      ctime = sprintf('%6.1f',t)

# پɽ      

      z1 = z[true,true,1]
      g = c2.s2ga(z1,1)

      for i in 0..im-1
        for j in 0..jm
#          rg[i,j]=wg[j,i,0]+Dtemp/Depth*(jm-j)/(jm)
          rg[i,j]=g[j,i]+Dtemp/Depth*(jm-j)/(jm)
        end
      end

      for j in 0..jm
        rg[im,j]=rg[0,j]
      end

      DCL::grfrm
      DCL::sgsvpt(0.13,0.93,0.08,0.08+1/(2*sqrt(2.0))*0.8)
      DCL::sgswnd(0.0,2*sqrt(2.0),0.0,1.0)
      DCL::sgstrn(1)
      DCL::sgstrf

      DCL::uetone(rg)
      DCL::usdaxs
      DCL::uxsttl('t','temperature',0.0)
      DCL::uxsttl('t','t='+ctime,1.0)
#      p rg
      DCL::udcntr(rg)

# ήؿɽ        

      k = (NArray.float(km*2+1).indgen! - km).newdim!(1)
      l = (NArray.float(lm).indgen! + 1).newdim!(0)
      s = -z[true,true,0]/((Rat*k)*(Rat*k)+l*l)
      g = c2.s2ga(s,1)

      rg[0..-2,true] = g.transpose(1,0)
      rg[-1,true] = rg[0,true]

      DCL::grfrm
      DCL::sgsvpt(0.13,0.93,0.15,0.15+1/(2*sqrt(2.0))*0.8)
      DCL::sgswnd(0.0,2*sqrt(2.0),0.0,1.0)
      DCL::sgstrn(1)
      DCL::sgstrf

      DCL::usdaxs      
      DCL::udcntr(rg)
      DCL::uxsttl('t','stream-function',0.0)      

    end
#----------------------------------------------------------------------
#     λ
#----------------------------------------------------------------------
    def sbclos

      DCL::grcls

    end

#----------------------------------------------------------------------
#     (T)ӱ٤Υڥȥ뷸(Z)ϤȤ, Υ
#     ȥ뷸(DZ)륵֥롼(Runge-KuttaǻȤ)
#----------------------------------------------------------------------
    def sbgdzn(t,z,lm,km,c2)

      z0 = z[true,true,0]
      z1 = z[true,true,1]

      dz0,dz1 = c2.ajb2(z0,z1)

      if(Isplit != 1) then
        k = (NArray.float(km*2+1).indgen! - km).newdim!(1)
        l = (NArray.float(lm).indgen! + 1).newdim!(0)
        dz0 = dz0.reshape(km*2+1,lm) - Coef1*k*z[-1..0,true,1]
        dz1 = dz1.reshape(km*2+1,lm) - Coef2*k*(-z[-1..0,true,0]/((Rat*k)*(Rat*k)+l*l))
      end

      dz = z.dup.fill!(0)
      dz[true,true,0] = dz0
      dz[true,true,1] = dz1

      return dz
    end
#----------------------------------------------------------------------
#     (T)ӻֹ(DT)ϤȤ, (Ǵ)ˤZ
#     TT+DTˤȯŸ򤯥֥롼(Runge-KuttaǻȤ)
#----------------------------------------------------------------------
    def sbgdzl(t,dt,z,dl,diff)

      if(Isplit == 1) then
        tmpz1 = z[-1..0,true,0]
        z[-1..0,true,0] = dl[true,true,0,0]*tmpz1 - dl[true,true,0,1]*z[true,true,1]
        z[true,true,1] = -dl[true,true,1,0]*tmpz1 + dl[true,true,1,1]*z[true,true,1]
      else
        z = diff * z
      end

      return z
    end

alias subl sbgdzl
alias subn sbgdzn

def integral(dt,t,z,lm,km,dl,diff,c2) # 󥲥åʬ

  dt = dt.to_f

  dz1 = subn(t,z,lm,km,c2)
  dz2 = z + dz1*dt/2
  dz3 = z + dz1*dt/6

  z = subl(t,dt/2,z,dl,diff)
  dz2 = subl(t,dt/2,dz2,dl,diff)
  dz3 = subl(t,dt/2,dz3,dl,diff)
  dz1 = subn(t+dt/2,dz2,lm,km,c2)

  dz2 = z + dz1*dt/2
  dz3 = dz3 + dz1*dt/3

  dz1 = subn(t+dt/2,dz2,lm,km,c2)

  dz2 = z + dz1*dt
  dz3 = dz3 + dz1*dt/3

  dz2 = subl(t+dt/2,dt/2,dz2,dl,diff)
  dz3 = subl(t+dt/2,dt/2,dz3,dl,diff)
  dz1 = subn(t+dt,dz2,lm,km,c2)

  t = t + dt
  z = dz3 + dz1*dt/6

  return t,z
end

# 

      z = sbiniz(c2)

# ȯŸӥեåɽ

      t=0                       #tϻɽѿ
      sbgrph(t,z,lm,km,jm,im,c2)

      for istep in 1..nstep
        m.times do
          t,z = integral(h/m,t,z,lm,km,dl,diff,c2)
        end
        sbgrph(t,z,lm,km,jm,im,c2)
      end

# λ

      sbclos()

