require "mkmf"


name = "Misc"


dir_config("vtk","/usr/local/include/vtk","/usr/local/lib/vtk")
unless have_header("vtkConfigure.h")
  puts "header file for vtk is not found\n"
  puts "please retry with --with-vtk-include=path\n"
  exit 1
end

dir_config("narray",$sitearchdir,$sitearchdir)
narray = have_header("narray.h")
unless narray
  puts "if you have narray and you want to compile with narray\n"
  puts "please retry with --with-narray-include=path\n"
end



File.open("lib/Misc.rb","w"){|f|
  print "creating lib/Misc.rb\n"
  if narray
    f.print "require 'narray'\n"
  end
  f.print "require 'vtk/Common'\n"
  f.print "require 'vtk/Misc.so'\n"
}

$LIBS = $LIBS+" -lstdc++"
create_makefile("vtk/#{name}")
create_header("extconf.h")
