%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkIO_typemaps.i


%{
#include "vtkVolumeReader.h"
%}

%import vtkImageSource.h


%{
extern void vtkVolumeReader_freefunc(void *ptr)
{
    vtkVolumeReader *obj;
    obj = (vtkVolumeReader*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[2]{
   int *GetImageRange()
}
%ignore GetImageRange(int data[2]);
%ignore GetImageRange(int _arg[2]);
%ignore GetImageRange(int &_arg1,int &_arg2);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetDataSpacing()
}
%ignore GetDataSpacing(double data[3]);
%ignore GetDataSpacing(double _arg[3]);
%ignore GetDataSpacing(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetDataOrigin()
}
%ignore GetDataOrigin(double data[3]);
%ignore GetDataOrigin(double _arg[3]);
%ignore GetDataOrigin(double &_arg1,double &_arg2,double &_arg3);

%include vtkVolumeReader.h
