%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkGraphics_typemaps.i


%{
#include "vtkProjectedTexture.h"
%}

%import vtkDataSetToDataSetFilter.h


%{
extern void vtkProjectedTexture_freefunc(void *ptr)
{
    vtkProjectedTexture *obj;
    obj = (vtkProjectedTexture*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetPosition()
}
%ignore GetPosition(float data[3]);
%ignore GetPosition(float _arg[3]);
%ignore GetPosition(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetFocalPoint()
}
%ignore GetFocalPoint(float data[3]);
%ignore GetFocalPoint(float _arg[3]);
%ignore GetFocalPoint(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetOrientation()
}
%ignore GetOrientation(float data[3]);
%ignore GetOrientation(float _arg[3]);
%ignore GetOrientation(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetUp()
}
%ignore GetUp(float data[3]);
%ignore GetUp(float _arg[3]);
%ignore GetUp(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetAspectRatio()
}
%ignore GetAspectRatio(float data[3]);
%ignore GetAspectRatio(float _arg[3]);
%ignore GetAspectRatio(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[2]{
   float *GetSRange()
}
%ignore GetSRange(float data[2]);
%ignore GetSRange(float _arg[2]);
%ignore GetSRange(float &_arg1,float &_arg2);

%typemap(ruby,out) float value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[2]{
   float *GetTRange()
}
%ignore GetTRange(float data[2]);
%ignore GetTRange(float _arg[2]);
%ignore GetTRange(float &_arg1,float &_arg2);

%include vtkProjectedTexture.h
